<?php
/**
 * @package	   TGM-Plugin-Activation
 * @subpackage Example
 * @version	   2.6.1
 * @author	   Thomas Griffin <thomas@thomasgriffinmedia.com>
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */

/* Include TGM class */
require_once get_template_directory() . '/includes/tgm/class-tgm-plugin-activation.php';


add_action( 'tgmpa_register', 'tabligh_register_required_plugins' );

/* Include Your Plugins */
function tabligh_register_required_plugins() {

	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	 
	$plugins = array(

		/* Theme Options Panel */
		array(
            'name'      => esc_html__('Redux Framework','tabligh'),
            'slug'      => esc_html__('redux-framework','tabligh'),
            'required'  => true,
			'force_activation' => false,
        ),
		
		/* Event Manager */
		array(
            'name'      => esc_html__('Event Manager','tabligh'),
            'slug'      => esc_html__('events-manager','tabligh'),
            'required'  => true,
        ),
		
		
		/* Contact Form 7 */
		array(
            'name'      => esc_html__('Contact Form 7', 'tabligh'),
            'slug'      => esc_html__('contact-form-7','tabligh'),
            'required'  => false,
        ),
		
		/* Charitable */
		array(
            'name'      => esc_html__('Charitable', 'tabligh'),
            'slug'      => esc_html__('charitable','tabligh'),
            'required'  => false,
        ),
		
		/* Elementor */
		array(
            'name'      => esc_html__('Elementor', 'tabligh'),
            'slug'      => esc_html__('elementor','tabligh'),
            'required'  => false,
        ),
		
		/* One Click Demo Import */
		array(
            'name'      => esc_html__('One Click Demo Import', 'tabligh'),
            'slug'      => esc_html__('one-click-demo-import','tabligh'),
            'required'  => false,
        ),
		
		/* Woocommerce */
		array(
            'name'      => esc_html__('Woocommerce', 'tabligh'),
            'slug'      => esc_html__('woocommerce','tabligh'),
            'required'  => false,
        ),

		/*  Theme Nucleus */
		array(
			'name'     				=> esc_html__('Ingeniofy','tabligh'),
			'slug'     				=> esc_html__('ingeniofy','tabligh'),
			'source'   				=> get_template_directory() . '/framework/extensions/plugins/ingeniofy.zip',
			'required' 				=> true,
			'version' 				=> '',
			'force_activation' 		=> false,
			'force_deactivation' 	=> false,
			'external_url' 			=> '',
		),
	);
	
	/* Change this to your theme text domain, used for internationalising strings */
	$theme_text_domain = 'tabligh';

	$config = array(
		'domain'       		=> 'tabligh',         	/*  Text domain - likely want to be the same as your theme. */
		'default_path' 		=> '',                         	/* Default absolute path to pre-packaged plugins */
		'menu'         		=> 'install-required-plugins', 	/* Menu slug */
		'has_notices'      	=> true,                       	/* Show admin notices or not */
		'is_automatic'    	=> false,					   	/* Automatically activate plugins after installation or not */
		'message' 			=> '',							/* Message to output right before the plugins table */
		'strings'      		=> array(
			'page_title'                       			=> esc_html__( 'Install Required Plugins', 'tabligh' ),
			'menu_title'                       			=> esc_html__( 'Install Plugins', 'tabligh' ),
			'installing'                       			=> esc_html__( 'Installing Plugin: %s', 'tabligh' ), // %1$s = plugin name
			'oops'                             			=> esc_html__( 'Something went wrong with the plugin API.', 'tabligh' ),
			'notice_can_install_required'     			=> _n_noop( esc_html__('This theme requires the following plugin: %1$s.', 'tabligh'), esc_html__('This theme requires the following plugins: %1$s.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_can_install_recommended'			=> _n_noop( esc_html__('This theme recommends the following plugin: %1$s.', 'tabligh'), esc_html__('This theme recommends the following plugins: %1$s.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_cannot_install'  					=> _n_noop( esc_html__('Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'tabligh'), esc_html__('Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_can_activate_required'    			=> _n_noop( esc_html__('The following required plugin is currently inactive: %1$s.', 'tabligh'), esc_html__('The following required plugins are currently inactive: %1$s.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_can_activate_recommended'			=> _n_noop( esc_html__('The following recommended plugin is currently inactive: %1$s.', 'tabligh'), esc_html__('The following recommended plugins are currently inactive: %1$s.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_cannot_activate' 					=> _n_noop( esc_html__('Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'tabligh'), esc_html__('Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_ask_to_update' 						=> _n_noop( esc_html__('The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'tabligh'), esc_html__('The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'tabligh' )), /* %1$s = plugin name(s) */
			'notice_cannot_update' 						=> _n_noop( esc_html__('Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'tabligh'), esc_html__('Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'tabligh' )), /* %1$s = plugin name(s) */
			'install_link' 					  			=> _n_noop( esc_html__('Begin installing plugin', 'tabligh'), esc_html__('Begin installing plugins', 'tabligh' )),
			'activate_link' 				  			=> _n_noop( esc_html__('Activate installed plugin', 'tabligh'), esc_html__('Activate installed plugins', 'tabligh' )),
			'return'                           			=> esc_html__( 'Return to Required Plugins Installer', 'tabligh' ),
			'plugin_activated'                 			=> esc_html__( 'Plugin activated successfully.', 'tabligh' ),
			'complete' 									=> esc_html__( 'All plugins installed and activated successfully. %s', 'tabligh' ), /* %1$s = dashboard link */
			'nag_type'									=> 'updated' /* Determines admin notice type - can only be 'updated' or 'error' */
		)
	);

	tgmpa( $plugins, $config );
}