<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class AudioSermons extends Widget_Base{

  public function get_name(){
    return 'audio_sermons';
  }

  public function get_title(){
    return 'Audio Sermons';
  }

  public function get_icon(){
    return 'fa fa-handshake';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	

	$repeater = new \Elementor\Repeater();
	
	/* Quran Audio Section */
	
	$repeater->add_control(
      'track_name',
      [
        'label' => 'Audio File Name To Display',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Surah-Fatiha'
      ]
    );
	
	$repeater->add_control(
      'track_author',
      [
        'label' => 'Audio File Voice/Detail',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '(Abd-ur-Rahman)'
      ]
    );
	
	/* Media File */
	$repeater->add_control(
        'file_link',
        [
            'label' => esc_html__( 'Select Track MP3', 'tabligh' ),
            'type'  => 'file-select',
            'placeholder' => esc_html__( 'URL to File', 'tabligh' ),
            'description' => esc_html__( 'Select MP3 from media library or upload', 'tabligh' ),
        ]
    );
	
	$repeater->add_control(
		'cover_image',[
			'label' => __( 'Cover Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/audio-img2.jpg',
			],
		]
	);
	
	$this->add_control(
		'list',
			[
				'label' => __( 'Repeater List', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[			
						'track_name' => __( 'Al-Baqara', 'tabligh' ),
						'track_author' => __( '(Tilawat)', 'tabligh' ),
						'file_link' => __( '#', 'tabligh' ),
						'cover_image' => __( '', 'tabligh' ),
					],
					[			
						'track_name' => __( 'Surah Fatiha', 'tabligh' ),
						'track_author' => __( '(Tilawat)', 'tabligh' ),
						'file_link' => __( '#', 'tabligh' ),
						'cover_image' => __( '', 'tabligh' ),
					],
					[			
						'track_name' => __( 'Al Quran', 'tabligh' ),
						'track_author' => __( '(Tilawat)', 'tabligh' ),
						'file_link' => __( '#', 'tabligh' ),
						'cover_image' => __( '', 'tabligh' ),
					],
					[			
						'track_name' => __( 'Quran Majeed', 'tabligh' ),
						'track_author' => __( '(Tilawat)', 'tabligh' ),
						'file_link' => __( '#', 'tabligh' ),
						'cover_image' => __( '', 'tabligh' ),
					],
					[			
						'track_name' => __( 'Tafseer', 'tabligh' ),
						'track_author' => __( '(Tilawat)', 'tabligh' ),
						'file_link' => __( '#', 'tabligh' ),
						'cover_image' => __( '', 'tabligh' ),
					],
	
				],
				'title_field' => '{{{ track_name }}}',
			]
		);
		
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Audio Channel'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );


    $this->end_controls_section();
  }
  

	protected function render(){
		
		$settings = $this->get_settings_for_display();
		
		/* button url */
		$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
		$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';
	
		wp_enqueue_script( 'musicplayer-min', get_template_directory_uri() . '/assets/js/musicplayer-min.js', array('jquery'), '1.0.0', true ); ?>
		
		<section>
                <div class="w-100 pt-100 pb-100 position-relative">
                    <img class="sec-botm-rgt-mckp img-fluid position-absolute" src="<?php echo get_template_directory_uri(); ?>assets/images/sec-botm-mckp.png" alt="<?php esc_attr__('Texture','tabligh'); ?>">
                    <div class="container">
                        <div class="plyr-wrp2 d-inline-block w-100">
                            <?php 
							if ( $settings['list'] ) {
							  foreach (  $settings['list'] as $item ) { ?>
								<div class="plyr-box w-100 pat-bg white-layer opc85 back-blend-multiply bg-white" style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/pattern-bg.jpg);">
									<div class="plyr v4 w-100">
										<ul class="playlist mb-0 list-unstyled">
											<li data-cover="<?php echo $item['cover_image']['url'];?>" data-artist="<?php echo $item['track_author'];?>"><a href="<?php echo $item['file_link'];?>" title=""><?php echo $item['track_name'];?></a></li>
										</ul>
									</div>
								</div><!-- Player Wrap -->
							  <?php } 
							} ?>
						</div>
						<?php /* Audio Channel Button */
						if($settings['button_text']){ ?>
							<div class="view-more mt-30 d-inline-block text-center w-100">
								<a class="thm-btn thm-bg" target = "<?php echo $btarget; ?>" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a>
							</div>
						<?php } ?>
                    </div>
                </div>
            </section>
		
	<?php
	}
}