<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class BooksBlock extends Widget_Base{

  public function get_name(){
    return 'books_block';
  }

  public function get_title(){
    return 'Books Block';
  }

  public function get_icon(){
    return 'fa fa-flag';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'tabligh' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
		'bg_image',
			[
				'label' => __( 'Choose Background Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/sec-bg2.jpg',
				],
			]
		);
	
		$this->add_control(
			'heading_icon',
			[
			  'label' => 'Heading Icon',
			  'type' => \Elementor\Controls_Manager::TEXT,
			  'default' => 'flaticon-rub-el-hizb'
			]
		);

		$this->add_control(
		  'content_heading',
		  [
			'label' => 'Element Heading',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Quran in Arabic'
		  ]
		);
		
		$this->add_control(
		  'button_text',
		  [
			'label' => 'Button Text',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'LEARN MORE'
		  ]
		);
		
		$this->add_control(
		  'button_link',
		  [
			'label' => 'Button Link',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '#'
		  ]
		);

		$this->add_control(
		'bg_left_image',
			[
				'label' => __( 'Choose Left Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/learn-img.jpg',
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'book_title', [
				'label' => __( 'Book Title', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Book 1 Name' , 'tabligh' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'book_subtitle', [
				'label' => __( 'Book Sub Title', 'tablighn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'The Opener' , 'tabligh' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'book_image',
				[
					'label' => __( 'Book Image', 'tabligh' ),
					'type' => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => get_template_directory_uri().'/assets/images/audio-img2.jpg',
					],
				]
			);

		$repeater->add_control(
			'download_text', [
				'label' => __( 'Download Text', 'tablighn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Download PDF' , 'tabligh' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'download_link', [
				'label' => __( 'Download Link', 'tablighn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'tabligh' ),
				'show_label' => true,
			]
		);
	
		$this->add_control(
			'list',
			[
				'label' => __( 'Books List', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[			
						'book_title' => __( 'Al-Fatihah', 'tabligh' ),
						'book_subtitle' => __( 'The Opener', 'tabligh' ),
						'book_image' => __( '', 'tabligh' ),
						'download_text' => __( 'Download PDF', 'tabligh' ),
						'download_link' => __( '#', 'tabligh' ),
					],
					[			
						'book_title' => __( 'Al-Mursalat', 'tabligh' ),
						'book_subtitle' => __( 'The Emissaries', 'tabligh' ),
						'book_image' => __( '', 'tabligh' ),
						'download_text' => __( 'Download PDF', 'tabligh' ),
						'download_link' => __( '#', 'tabligh' ),
					],
					[			
						'book_title' => __( 'An-Naba', 'tabligh' ),
						'book_subtitle' => __( 'The Tidings', 'tabligh' ),
						'book_image' => __( '', 'tabligh' ),
						'download_text' => __( 'Download PDF', 'tabligh' ),
						'download_link' => __( '#', 'tabligh' ),
					],
					[			
						'book_title' => __( 'Az-Zumar', 'tabligh' ),
						'book_subtitle' => __( 'The Troops', 'tabligh' ),
						'book_image' => __( '', 'tabligh' ),
						'download_text' => __( 'Download PDF', 'tabligh' ),
						'download_link' => __( '#', 'tabligh' ),
					],
					[			
						'book_title' => __( 'Al-Baqarah', 'tabligh' ),
						'book_subtitle' => __( 'The Cow', 'tabligh' ),
						'book_image' => __( '', 'tabligh' ),
						'download_text' => __( 'Download PDF', 'tabligh' ),
						'download_link' => __( '#', 'tabligh' ),
					],
					[			
						'book_title' => __( 'Ghafir', 'tabligh' ),
						'book_subtitle' => __( 'The Forgiver', 'tabligh' ),
						'book_image' => __( '', 'tabligh' ),
						'download_text' => __( 'Download PDF', 'tabligh' ),
						'download_link' => __( '#', 'tabligh' ),
					],
	
				],
				'title_field' => '{{{ book_title }}}',
			]
		);

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
		$output = '
			<section>
                <div class="w-100 pt-100 black-layer pb-100 opc1 position-relative">
                    <div class="fixed-bg" style="background-image: url('.$settings['bg_image']['url'].');"></div>
                    <div class="hlf-bg thm-layer opc6 pat-bg back-blend-multiply thm-bg position-absolute" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);"></div>
                    <div class="container">
                        <div class="learn-wrap w-100">
                            <div class="row">
                                <div class="col-md-12 col-sm-12 col-lg-5">
                                    <div class="learn-img w-100">
                                        <img class="img-fluid w-100" src="'.esc_url($settings['bg_left_image']['url']).'" alt="'.esc_attr__('Featured Image','tabligh').'">
                                    </div>
                                </div>
                                <div class="col-md-12 col-sm-12 col-lg-7">
                                    <div class="learn-inner w-100">
                                        <div class="learn-top d-flex flex-wrap align-items-center justify-content-between w-100">
                                            <div class="learn-top-inner">
                                                <h3 class="mb-0"><i class="'.$settings['heading_icon'].' thm-clr"></i>'.$settings['content_heading'].'</h3>
                                            </div>
                                            <div class="learn-top-inner">
                                                <a href="'.$settings['button_link'].'" title="">'.$settings['button_text'].'<i class="fas fa-angle-double-right"></i></a>
                                            </div>
                                        </div>
                                        <div class="learn-post-wrap w-100">
                                            <div class="row">';
													
													if ( $settings['list'] ) {

														static $counter = 0;

														foreach (  $settings['list'] as $item ) {
															/* if its 0, 4 , 7 */
															if($counter % 3 == 0){ $output .= '<div class="col-md-6 col-sm-6 col-lg-6">'; }
															
																$output .= '
																	
																	<div class="learn-post d-flex flex-wrap align-items-center">
																		<div class="learn-post-img">
																			<img class="img-fluid w-100" src="'.$item['book_image']['url'].'" alt="'.esc_attr__('Book Cover','tabligh').'">
																		</div>
																		<div class="learn-post-info">
																			<h4 class="mb-0"><a href="'.$item['download_link'].'" title="">'.$item['book_title'].'</a></h4>
																			<span class="d-block">'.$item['book_subtitle'].'</span>
																			<a href="'.$item['download_link'].'" title="">'.$item['download_text'].'<i class="fas fa-angle-double-right"></i></a>
																		</div>
																	</div>';
															/* if its 2, 6 , 10 */	
															if($counter % 3 == 2){ $output .= '</div>'; }
															
															$counter++;
														}
													}
													
                                                  $output .= '
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- Learn Wrap -->
                    </div>
                </div>
            </section>';

			echo $output;
		
	}
}
