<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ContactFormMap extends Widget_Base{

  public function get_name(){
    return 'contact_form_map';
  }

  public function get_title(){
    return 'Contact Form + Map';
  }

  public function get_icon(){
    return 'fa fa-envelope-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'location_lat',
      [
        'label' => 'Enter Map Location Latitude',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '48.85661'
      ]
    );
	
	$this->add_control(
      'location_long',
      [
        'label' => 'Enter Map Location Logitude',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '2.35222'
      ]
    );

    $this->add_control(
      'form_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Dont be a stranger just say hello.'
      ]
    );
	
	$this->add_control(
      'form_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'We will connect back to you in next few moments. Our team of professional alims and scholars are always there to help and guide you.'
      ]
    );
	
	$this->add_control(
      'social_title',
      [
        'label' => 'Social Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Follow Us On Social Media'
      ]
    );
	
	$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'social_title', [
				'label' => __( 'Social Title', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'facebook' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'profile_link', [
				'label' => __( 'Profile Link', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'social_icon_field',
			[
				'label' => __( 'Social Icon', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook-f',
					'library' => 'solid',
				],
			]
		);

		
		$this->add_control(
			'list',
			[
				'label' => __( 'Social Profiles', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'profile_link' => __( '#', 'plugin-domain' ),
						'social_title' => __( 'facebook', 'plugin-domain' ),
						'social_icon_field' => __( 'fab fa-facebook-f', 'plugin-domain' ),
					],
					[		
						'profile_link' => __( '#', 'plugin-domain' ),
						'social_title' => __( 'twitter', 'plugin-domain' ),
						'social_icon_field' => __( 'fab fa-twitter', 'plugin-domain' ),
					],
					[
						'profile_link' => __( '#', 'plugin-domain' ),
						'social_title' => __( 'google', 'plugin-domain' ),
						'social_icon_field' => __( 'fab fa-google-plus-g', 'plugin-domain' ),
					],
					[
						'profile_link' => __( '#', 'plugin-domain' ),
						'social_title' => __( 'linkedin', 'plugin-domain' ),
						'social_icon_field' => __( 'fab fa-linkedin-in', 'plugin-domain' ),
					],
				],
				
				'title_field' => '{{{ social_title }}}',
			]
		);

    $this->add_control(
      'form_shortcode',
      [
        'label' => 'Form Shortcode',
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => 'Add Contact Form 7 Shortcode Here'
      ]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    
	$settings = $this->get_settings_for_display();
	
		$output = '
		
		<section>
			<div class="w-100 pt-100 pb-70 position-relative">';
				
				global $tabligh_options;
				
				$googleKey = $tabligh_options['google_map_apikey'];
					
				if(!empty($googleKey)){ ?>

						<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo esc_attr($googleKey); ?>"></script>
						<script>
							jQuery(document).ready(function ($) {
								'use strict';

								var marker;

								function initMap() {
									var map = new google.maps.Map(document.getElementById('contact-map'), {
										zoom: 13,
										center: {lat: <?php echo $settings['location_lat'];?>, lng: <?php echo $settings['location_long'];?>}
									});

									marker = new google.maps.Marker({
										map: map,
										draggable: true,
										animation: google.maps.Animation.DROP,
										position: {lat: <?php echo $settings['location_lat'];?>, lng: <?php echo $settings['location_long'];?>}
									});
									marker.addListener('click', toggleBounce);
								}

								function toggleBounce() {
									if (marker.getAnimation() !== null) {
										marker.setAnimation(null);
									} else {
										marker.setAnimation(google.maps.Animation.BOUNCE);
									}
								}

								google.maps.event.addDomListener(window, 'load', initMap);

							});
						</script>
						<?php 
				}
				
				
				if($settings['location_lat']){ $output .= '<div id="contact-map" class="contact-map w-100"></div>'; }

				$output .= '
				<div class="container">
					<div class="contact-wrap w-100">
						<div class="row">
							<div class="col-md-6 col-sm-12 col-lg-6">
								<div class="cont-info-desc w-100">';
								if($settings['form_title']){ $output .= '<h3 class="mb-0">'.$settings['form_title'].'</h3>'; }
								if($settings['form_caption']){ $output .= '<p class="mb-0">'.$settings['form_caption'].'</p>'; }
								if($settings['social_title']){ $output .= '<h6 class="mb-0">'.$settings['social_title'].'</h6>'; }
								
								$output .= '
									<div class="social-links2 v2 text-center d-inline-flex">';
										
										if ( $settings['list'] ) {
											foreach (  $settings['list'] as $item ) {
												
												$output .= '<a class="'.$item['social_title'].'" href="'.$item['profile_link'].'" title="'.$item['social_title'].'" target="_blank"><i class="'.$item['social_icon_field']['value'].'"></i></a>';
											}
										}
										
										$output .= '
									</div>
								</div>
							</div>';
							
							if($settings['form_shortcode']){
								
								$output .= '
									<div class="col-md-6 col-sm-12 col-lg-6">
										<div class="cont-form w-100">
											'.do_shortcode($settings['form_shortcode']).'
										</div>
									</div>';
							}
							
							$output .= '
						</div>
					</div><!-- Contact Wrap -->
				</div>
			</div>
		</section>';
		
		echo $output;
  }
}
