<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CoursesGrid extends Widget_Base{

  public function get_name(){
    return 'courses_grid';
  }

  public function get_title(){
    return 'Courses Grid';
  }

  public function get_icon(){
    return 'fa fa-books';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'courses',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'courses-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Islamic Courses'
      ]
    );

    $this->add_control(
		'display_hijri_date',
		[
			'label' => __( 'Display Hijri Date', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );


	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
	);
	
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More Courses'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('courses', 'courses-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  
	if($settings['content_heading'] || $settings['content_caption']){ $padding_class = "w-100 pt-100 pb-100 position-relative"; }else{ $padding_class = "w-100 pt-100 pb-100 position-relative"; } ?>
	
	<section>
		<div class="<?php echo esc_attr($padding_class);?>">
			<div class="container">
				<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
					<div class="sec-title v2 text-center w-100 white-head">
						<div class="sec-title-inner d-inline-block">
						<?php if($settings['heading_icon']){ ?><i class="<?php echo $settings['heading_icon']; ?> thm-clr"></i><?php } ?>
						<?php if($settings['content_heading']){ ?><h1 class="mb-0"><?php echo $settings['content_heading']; ?></h1><?php } ?>
						<?php if(shortcode_exists('tabligh_hijri_date') && $settings['display_hijri_date'] == 'Yes'){ ?>
							<p class="mb-0"> <?php echo do_shortcode('[tabligh_hijri_date]'); ?></p>
						<?php } ?>
						</div>
					</div>
				<?php } ?>
				<div class="course-wrap3 w-100">
					<div class="row mrg">
						<?php
						if ( have_posts() ) {
							
							while ( have_posts() ) { the_post(); global $post;
			
								static $counter = 1; 
								
								     	   
								$course_teacher_name = ''; $course_teacher_expertise = ''; $course_teacher_image = '';
								$course_price_title = ''; $course_price_amount = ''; $course_social_media_tags = ''; $course_meta_details = '';
								
								$course_teacher_name = get_post_meta( get_the_ID(), 'course_teacher_name', true );
								$course_teacher_expertise = get_post_meta( get_the_ID(), 'course_teacher_expertise', true );
								$course_teacher_image = get_post_meta( get_the_ID(), 'course_teacher_image', true );
								$course_price_title = get_post_meta( get_the_ID(), 'course_price_title', true );
								$course_price_amount = get_post_meta( get_the_ID(), 'course_price_amount', true );															
								
								if($counter == 1 || $counter == 2 || $counter == 6 || $counter == 7) { 
									$grid_class = "col-md-12 col-sm-12 col-lg-6"; 
									$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 570, 490, 'bfi_thumb' => true ));
								}
								if($counter == 3 || $counter == 4 || $counter == 5) { 
									$grid_class = "col-md-12 col-sm-12 col-lg-4"; 
									$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 380, 416, 'bfi_thumb' => true ));
								}
								?>
					
								<div class="<?php echo $grid_class ; ?>">
									<div class="course-box3 position-relative overflow-hidden w-100">
										<span class="course-price position-absolute"><i><?php echo $course_price_title; ?></i><?php echo $course_price_amount; ?></span>
										<img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','tabligh'); ?>">
										<div class="course-info3 position-absolute w-100">
											<span class="d-block thm-clr"><?php echo get_the_category_list(', '); ?></span>
											<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
											<div class="d-inline-flex course-scholar">
												<img class="img-fluid rounded-circle" src="<?php echo esc_url($course_teacher_image); ?>">
												<div class="course-scholar-inner">
													<h5 class="mb-0"><?php echo $course_teacher_name; ?></h5>
													<span class="d-block"><?php echo $course_teacher_expertise; ?></span>
												</div>
											</div>
										</div>
									</div>
								</div>
								
								<?php $counter++; ?>
								
							<?php } 
						} ?>
					</div>
				</div><!-- Course Wrap 3 -->
				
				<?php if($settings['button_text']){ ?>
					<div class="view-more mt-20 d-inline-block text-center w-100">
						<a class="thm-btn bg-color1" href="<?php echo $settings['button_text']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a>
					</div><!-- View More -->
				<?php } ?>
				
				<?php if($settings['display_pagination'] == 'Yes'){ ?>
					<div class="pagination-wrap mt-60 d-flex flex-wrap justify-content-center text-center w-100">
						<ul class="pagination mb-0">
							<?php echo tabligh_numeric_posts_nav(); ?>
						</ul>
					</div><!-- Pagination Wrap -->
				<?php } wp_reset_query();  ?>
				
			</div>
		</div>
	</section>

    <?php
  }
}