<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CoursesSlider extends Widget_Base{

  public function get_name(){
    return 'courses_slider';
  }

  public function get_title(){
    return 'Courses Slider';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'courses',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'courses-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Online Summer Classes'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'We have Started Online Courses From Home'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
	  
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('courses', 'courses-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	wp_enqueue_style('slick-slider',get_template_directory_uri().'/assets/css/slick.css');
	wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true ); ?>
	
	<section>
		<div class="w-100 pt-100 pb-110 position-relative">
			<div class="container">
				<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
					<div class="sec-title text-center w-100">
						<div class="sec-title-inner d-inline-block">
						<?php if($settings['heading_icon']){ ?>  
							<i class="thm-clr <?php echo $settings['heading_icon']; ?>"></i>
						<?php } ?>
						<?php if($settings['content_heading']){ ?> 	
							<h2 class="mb-0"><?php echo $settings['content_heading']; ?></h2>
						<?php } ?>
						<?php if($settings['content_caption']){ ?> 	
							<p class="mb-0"><?php echo $settings['content_caption']; ?></p>
						<?php } ?>
						</div>
					</div>
				<?php } ?>
				<div class="course-wrap2 wide-sec">
					<div class="row mrg10 course-caro">
						<?php 
						if ( have_posts() ) {
						
							while ( have_posts() ) { the_post(); global $post;
		
								static $counter = 1; 
							
								$course_course_caption = '';
								$course_course_caption = get_post_meta( get_the_ID(), 'course_caption', true );								
								
								$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 360, 250, 'bfi_thumb' => true )); ?>
								
								<div class="col-md-4 col-sm-6 col-lg-3">
									<div class="course-box2 text-center w-100">
										<div class="course-img2 position-relative overflow-hidden w-100">
											<a href="online-courses-detail.html" title=""><img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','tabligh'); ?>"></a>
										</div>
										<div class="course-info2 pat-bg gray-layer3 opc8 position-relative back-blend-multiply gray-bg3 w-100" style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/pattern-bg.jpg);">
											<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
											<p class="mb-0"><?php echo $course_course_caption; ?></p>
										</div>
									</div>
								</div>
							<?php 
							}
						} wp_reset_query(); ?>
					</div>
				</div><!-- Course Wrap 2 -->
			</div>
		</div>
	</section>
	
    <?php
  }
}