<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CTALive extends Widget_Base{

  public function get_name(){
    return 'cta_live';
  }

  public function get_title(){
    return 'Online Classes CTA';
  }

  public function get_icon(){
    return 'fa fa-exclamation-circle';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Monday - Thursday 12:00 PM to 1:30 PM (CST)'
      ]
    );

    $this->add_control(
      'element_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Course Duration - 3 Months & 2 Weeks'
      ]
    );
	
	$repeater = new \Elementor\Repeater();

	$repeater->add_control(
		'platform_image',
		[
			'label' => __( 'Choose Image', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
			],
		]
	);

	$this->add_control(
		'list',
		[
			'label' => __( 'Platform List', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[
					'platform_image' => __( '', 'plugin-domain' ),
				],
				[
					'platform_image' => __( '', 'plugin-domain' ),
				],
				[
					'platform_image' => __( '', 'plugin-domain' ),
				],
				[
					'platform_image' => __( '', 'plugin-domain' ),
				],
			],
			'title_field' => '{{{ platform_image }}}',
		]
	);


	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'GET STARTED'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  ?>

	<section>
		<div class="w-100 pt-100 gray-layer pb-120 opc85 position-relative">
			<div class="fixed-bg patern-bg back-blend-multiply gray-bg" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg'; ?>);"></div>
			<div class="container">
				<div class="sponsors-wrap text-center w-100">
					<div class="sponsor-inner w-100">
						<?php if($settings['element_title'] || $settings['element_caption']){ ?>
							<div class="sponsor-title text-center w-100">
								<?php if($settings['element_title']){ ?>
									<h2 class="mb-0"><?php echo $settings['element_title']; ?></h2>
								<?php } ?>
								<?php if($settings['element_caption']){ ?>
									<p class="mb-0 thm-clr"><?php echo $settings['element_caption']; ?></p>
								<?php } ?>
							</div>
						<?php } ?>
						<ul class="sponsor-list d-flex flex-wrap align-items-center justify-content-center mb-0 list-unstyled">
							<?php
							if ( $settings['list'] ) {

								static $counter = 1;

								foreach (  $settings['list'] as $item ) {	?>
								
									<li><img class="img-fluid" src="<?php echo $item['platform_image']['url']; ?>" alt="<?php esc_attr__('Platform Image','tabligh'); ?>"></li>
								
								<?php 
								}
							} ?>
						</ul>
						<?php if($settings['button_text']){ ?>
							<a class="thm-btn thm-bg" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a>
						<?php } ?>
					</div>
				</div><!-- Sponsors Wrap -->
			</div>
		</div>
	</section>
	
    <?php
  }
}