<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class DonateCall extends Widget_Base{

  public function get_name(){
    return 'donate_call';
  }

  public function get_title(){
    return 'Donation Call';
  }

  public function get_icon(){
    return 'fa fa-newspaper-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	$this->add_control(
		'bg_image',
		[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax-bg6.jpg',
			],
		]
	);

    $this->add_control(
		'donate_title',
		[
			'label' => __( 'Donate Title', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'default' => __( 'Please Help Keep Families <span class="thm-clr">Healthy and Safe</span> when Lives are at Risk', 'plugin-domain' ),
			'placeholder' => __( 'Please Help Keep Families <span class="thm-clr">Healthy and Safe</span> when Lives are at Risk', 'plugin-domain' ),
		]
	);
	
	$this->add_control(
      'goal_text',
      [
        'label' => 'Goal Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Goal:'
      ]
    );
	
	$this->add_control(
      'goal_amount',
      [
        'label' => 'Goal Amount',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '$30,000'
      ]
    );

	$this->add_control(
      'collected_amount',
      [
        'label' => 'Collected Amount',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '$24,000'
      ]
    );
	
	$this->add_control(
      'collected_text',
      [
        'label' => 'Collected Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'DONATION COLLECTED'
      ]
    );
	
	$this->add_control(
      'donor_count',
      [
        'label' => 'Donor Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '22 DONORS'
      ]
    );
	
	$this->add_control(
      'donated_percentage',
      [
        'label' => 'Donated Percentage',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '85'
      ]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Make Donation'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
    
	$settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  
	
	/* Circle Full JS */
	wp_enqueue_script( 'waypoints-min', get_template_directory_uri() . '/assets/js/waypoints.min.js', array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'circlefull-min', get_template_directory_uri() . '/assets/js/circle-progress.min.js', array('jquery'), '1.0.0', true ); ?>
         
	<section>
		<div class="w-100 pt-100 black-layer pb-100 opc9 position-relative">
			<div class="fixed-bg" style="background-image: url(<?php echo $settings['bg_image']['url'];?>);"></div>
			<div class="container">
				<div class="donate-wrap2 w-100">
					<div class="donate-inner w-100">
						<div class="row align-items-center">
							<div class="col-md-6 col-sm-6 col-lg-6">
								<?php if($settings['donate_title'] || $settings['goal_text'] || $settings['goal_amount']){ ?>
									<div class="donate-title w-100">
										<?php if($settings['donate_title']){ ?>
											<h2 class="mb-0"><?php echo $formatted_text = str_replace(['<p>', '</p>'], '', $settings['donate_title']);?></h2>
										<?php } ?>
										<?php if($settings['goal_text']){ ?>
											<span class="d-block"><i class="thm-clr"><?php echo $settings['goal_text'];?></i> <?php echo $settings['goal_amount'];?></span>
										<?php } ?>
									</div>
								<?php } ?>
							</div>
							<div class="col-md-6 col-sm-6 col-lg-6">
								<div class="donate-box-wrap w-100">
									<div class="donate-box-inner position-relative thm-layer opc6 text-center">
										<div class="fixed-bg gray-layer opc8 patern-bg back-blend-multiply gray-bg" style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/pattern-bg.jpg);"></div>
										<div class="fixed-bg patern-bg back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/pattern-bg.jpg);"></div>
										<div class="donate-box-inner-inner d-inline-block">
											<?php if($settings['collected_amount'] || $settings['collected_text']){ ?>
												<div class="donate-collected w-100">
													<?php if($settings['collected_amount']){ ?>
														<span class="d-block"><?php echo $settings['collected_amount'];?></span>
													<?php } ?>
													<?php if($settings['collected_text']){ ?>
														<h6 class="mb-0"><?php echo $settings['collected_text'];?></h6>
													<?php } ?>
												</div>
											<?php } ?>
											<?php if($settings['donor_count']){ ?>
												<span class="d-block"><i class="fas fa-heart"></i><?php echo $settings['donor_count'];?></span>
											<?php } ?>
											<?php $counter = rand(0, 1000); ?>
											<script>
												jQuery(document).ready(function($){
													'use strict';
													$("#goal-prog<?php echo $counter; ?>").waypoint(function(){
													  $("#goal-prog<?php echo $counter; ?>").circleProgress({
														value: 0.85,
														fill: {color: '#147736'},
														thickness: 5,
														emptyFill: '#fff',
														size: 110
													  }).on('circle-animation-progress', function(event, progress) {
														$(this).find('span').html(Math.round(<?php echo intval($settings['donated_percentage']); ?> * progress) + '<i>%</i>');
													  });
													}, { offset: '70%'})
												});
											</script>
											
											<?php if($settings['donated_percentage']){ ?>
												<div class="urgent-progress" id="goal-prog<?php echo $counter; ?>"><span></span></div>
											<?php } ?>
											
											<?php if($settings['button_text']){ ?>
												<a class="thm-btn bg-color1" href="<?php echo $settings['button_url']['url'];?>" title=""><?php echo $settings['button_text'];?><span></span><span></span><span></span><span></span></a>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div><!-- Donate Wrap 2 -->
			</div>
		</div>
	</section>
	
    <?php
  }
}