<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class EventsSermon extends Widget_Base{

  public function get_name(){
    return 'events_sermon';
  }

  public function get_title(){
    return 'Events + Sermon';
  }

  public function get_icon(){
    return 'fa fa-clock-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$args = array(
			'type'                     => 'sermons',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'sermons-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}
		
		/* Events */
		$eargs = array(
			'type'                     => 'event',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'event-categories',
			'pad_counts'               => false 
		);
		
		$vcategories = get_categories( $eargs ); 				
				
		$vtaxonomies = get_taxonomies();
		
		$categoryArrayevents = array();
		
		if($vcategories){
			$categoryArrayevents[0] = "All";
			foreach($vcategories as $vcategory_list){
				$categoryArrayevents[$vcategory_list->term_id] = $vcategory_list->name;
			}
		} else {
			$categoryArrayevents = array();
		}

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'tabligh' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'show_events',
			[
				'label' => __( 'Show Events Section', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
		  'content_heading',
		  [
			'label' => 'Element Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Whats Happening Now'
		  ]
		); 

		$this->add_control(
		  'content_caption',
		  [
			'label' => 'Element Caption',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Ethical & Moral Beliefs That Guides'
		  ]
		);
		
		$this->add_control(
		  'heading_icon',
		  [
			'label' => 'Heading Icon',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'flaticon-rub-el-hizb'
		  ]
		);

		$this->add_control(
			'eselect_category',
			[
				'label' => __( 'Select Event Category', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'All',
				'options' => $categoryArrayevents,
			]
		);
		
		$this->add_control(
			'sortby',
			[
				'label' => __( 'Sort Events By', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date'  => __( 'Date', 'tabligh' ),
					'title' => __( 'Title', 'tabligh' ),
					'name' => __( 'Name', 'tabligh' ),
					'rand' => __( 'Random', 'tabligh' ),
					'ID' => __( 'ID', 'tabligh' ),
				],
			]
		);
		
		$this->add_control(
			'orderby',
			[
				'label' => __( 'Events Order By', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC'  => __( 'DESCEDNING', 'tabligh' ),
					'ASC' => __( 'ASCENDING', 'tabligh' ),
				],
			]
		);
	
		$this->add_control(
		  'eposts_count',
			[
				'label' => __( 'Events Count', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 30,
				'step' => 1,
				'default' => 3,
			]
		);
		
		$this->add_control(
		  'button_text',
		  [
			'label' => 'Button Text',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'SEE MORE EVENTS'
		  ]
		);
		
		$this->add_control(
		  'button_url',
		  [
			'label' => 'Button Link',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '#'
		  ]
		);
		
		
		$this->add_control(
			'show_sermon',
			[
				'label' => __( 'Show Sermon', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
		  'sermon_heading',
		  [
			'label' => 'Sermon Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Popular Sermon'
		  ]
		); 

		$this->add_control(
		  'sermon_caption',
		  [
			'label' => 'Sermon Caption',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Ethical & Moral Beliefs That Guides'
		  ]
		);
		
		$this->add_control(
		  'sermon_heading_icon',
		  [
			'label' => 'Heading Icon',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'flaticon-rub-el-hizb'
		  ]
		);

		$this->add_control(
			'select_category',
			[
				'label' => __( 'Select Sermon Category', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'All',
				'options' => $categoryArray,
			]
		);


		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display(); 
		
		/* Get Posts */
		$posts = tabligh_get_post_query('sermons', 'sermons-category', $settings['select_category'], 1, $settings['sortby'], $settings['orderby']); 
		
		/* Change Bootstrap Classes */
		if($settings['show_events'] != 'yes' || $settings['show_sermon'] != 'yes'){
			$width_control = 'col-md-12 col-sm-12 col-lg-12'; /* Display It Full */
		}else{
			$width_control = 'col-md-12 col-sm-12 col-lg-6'; /* Display half half */
		}
		?>
		     
		<section>
			<div class="w-100 pb-110 position-relative">
				<div class="container">
					<div class="event-sermon-wrap w-100">
						<div class="row">
							<div class="col-md-12 col-sm-12 col-lg-7">
								<div class="sec-title left-icon w-100">
									<div class="sec-title-inner d-inline-block">
										<i class="<?php echo $settings['heading_icon']; ?> thm-clr"></i>
										<h2 class="mb-0"><?php echo $settings['content_heading']; ?></h2>
										<p class="mb-0 thm-clr"><?php echo $settings['content_caption']; ?></p>
									</div>
								</div><!-- Sec Title -->
								<div class="event-wrap2 w-100">
									<?php echo events_sermon_elementor_block($settings['eselect_category'], $settings['eposts_count']); ?>
									<a href="<?php echo $settings['button_url']; ?>" title=""><?php echo $settings['button_text']; ?><i class="fas fa-angle-double-right"></i></a>
								</div>
							</div>
							
							<!-- Sermons Section -->
							<div class="col-md-12 col-sm-12 col-lg-5">                        			
								<div class="sec-title left-icon w-100">
									<div class="sec-title-inner d-inline-block">
										<i class="<?php echo $settings['sermon_heading_icon']; ?> thm-clr"></i>
										<h2 class="mb-0"><?php echo $settings['sermon_heading']; ?></h2>
										<p class="mb-0 thm-clr"><?php echo $settings['sermon_caption']; ?></p>
									</div>
								</div><!-- Sec Title -->
								<?php
								/* Loop Begins */
								if ( have_posts() ) {
								 
									while ( have_posts() ) { the_post(); global $post; 
									
									$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 470, 326, 'bfi_thumb' => true )); ?>
								
										<div class="sermon-wrap w-100">
											<div class="sermon-box w-100">
												<div class="sermon-info w-100 position-relative pat-bg thm-layer opc65 back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg';?>);">
													<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
													<p class="mb-0"><?php echo wp_trim_words( get_the_excerpt(), 15, '...' ); ?></p>
													<?php $sermon_video_url = ''; $sermon_audio_url = ''; $sermon_pdf_url = ''; $sermon_short_caption = '';
													$sermon_video_url = get_post_meta( get_the_ID(), 'sermon_video_url', true );
													$sermon_audio_url = get_post_meta( get_the_ID(), 'sermon_audio_url', true );
													$sermon_pdf_url = get_post_meta( get_the_ID(), 'sermon_pdf_url', true );
													$sermon_short_caption = get_post_meta( get_the_ID(), 'sermon_short_caption', true ); ?>
																
													<div class="sermon-btns d-inline-flex">
														<a href="<?php echo esc_url($sermon_video_url); ?>" data-fancybox title=""><i class="fas fa-video"></i></a>
														<a href="<?php echo esc_url($sermon_audio_url); ?>" data-fancybox title=""><i class="fas fa-volume-up"></i></a>
														<a href="<?php echo esc_url($sermon_pdf_url); ?>" title="" target="_blank"><i class="far fa-file"></i></a>
													</div>
													<span class="position-absolute bg-color1"><?php echo $sermon_short_caption; ?></span>
												</div>
												<div class="sermon-img overflow-hidden position-relative w-100">
													<a href="<?php echo get_the_permalink(); ?>" title="">
														<img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','tabligh'); ?>">
													</a>
												</div>
											</div>
										</div><!-- Sermons Wrap -->
									
								<?php }
								
								} wp_reset_query(); ?>
							</div>
						</div>
					</div><!-- Event & Sermon Wrap 2 -->
				</div>
			</div>
		</section>
			
		<?php
	}
}