<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class MainSlider extends Widget_Base{

  public function get_name(){
    return 'main_slider';
  }

  public function get_title(){
    return 'Main Slider';
  }

  public function get_icon(){
    return 'fa fa-handshake';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'tabligh' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'style-one'  => esc_html__( 'Style 1', 'tabligh' ),
				'style-two' => esc_html__( 'Style 2', 'tabligh' ),
				'style-three' => esc_html__( 'Style 3', 'tabligh' ),
				'style-four' => esc_html__( 'Style 4', 'tabligh' ),
			],
			'default'   => 'style-one',
		]
	);
	
	$this->add_control(
		'slider_3_image',[
			'label' => __( 'Image For Slider 3 Only', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/sec-bg.jpg',
			],
		]
	);
	
	$repeater = new \Elementor\Repeater();
	
	$repeater->add_control(
		'slide_image',[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
			],
		]
	);
	
	$repeater->add_control(
		'slide_icon', [
			'label' => __( 'Flaticon or FontAwesome Icon Class e.g flaticon-rub-el-hizb  fab fa-facebook-f', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'flaticon-rub-el-hizb' , 'tabligh' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'slide_heading', [
			'label' => __( 'Slide Title', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Nothing Is Impossible With Allah' , 'tabligh' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'slide_caption', [
			'label' => __( 'Slide Caption', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Consectetur adipiscing elit duis volutpat ligula nulla dapibus.' , 'tabligh' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'slide_btn', [
			'label' => __( 'Slide Button', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Take A Tour' , 'tabligh' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'slide_url', [
			'label' => __( 'Slide Link', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( '#' , 'tabligh' ),
			'label_block' => true,
		]
	);


	$this->add_control(
		'list',
		[
			'label' => __( 'Slide List', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[	
					'slide_image' => \Elementor\Utils::get_placeholder_image_src(),
					'slide_icon' => __( 'flaticon-rub-el-hizb', 'tabligh' ),
					'slide_heading' => __( 'Nothing Is Impossible With Allah', 'tabligh' ),
					'slide_caption' => __( 'Consectetur adipiscing elit duis volutpat ligula nulla dapibus.', 'tabligh' ),
					'slide_btn' => __( 'Take A Tour', 'tabligh' ),
					'slide_url' => '#',
				]
			],
			'title_field' => '{{{ slide_heading }}}',
		]
	);
	
	$this->add_control(
		'show_player',
		[
			'label' => __( 'Show Audio Player', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'your-plugin' ),
			'label_off' => __( 'Hide', 'your-plugin' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]
	);
	
	/* Quran Audio Section */
	$this->add_control(
      'audio_player_title',
      [
        'label' => 'Audio Section Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Listen to Quran Audio'
      ]
    );
	
	$this->add_control(
      'track_name',
      [
        'label' => 'Audio File Name To Display',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Surah-Fatiha'
      ]
    );
	
	$this->add_control(
      'track_author',
      [
        'label' => 'Audio File Voice/Detail',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '(Abd-ur-Rahman)'
      ]
    );
	
	/* Media File */
	$this->add_control(
        'file_link',
        [
            'label' => esc_html__( 'Select Track MP3', 'tabligh' ),
            'type'  => 'file-select',
            'placeholder' => esc_html__( 'URL to File', 'tabligh' ),
            'description' => esc_html__( 'Select MP3 from media library or upload', 'tabligh' ),
        ]
    );
	
	$this->add_control(
		'cover_image',[
			'label' => __( 'Cover Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/audio-img2.jpg',
			],
		]
	);
	
	$this->add_control(
      'phone_number',
      [
        'label' => 'Phone Number',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '+96 125 554 24 5'
      ]
    );
	
	$this->add_control(
		'phone_icon',
		[
			'label' => __( 'Phone Icon', 'text-domain' ),
			'type' => \Elementor\Controls_Manager::ICONS,
			'default' => [
				'value' => 'fas fa-phone-alt',
				'library' => 'solid',
			],
		]
	);
	
	$this->add_control(
      'email_id',
      [
        'label' => 'Email Address',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'info@example.com'
      ]
    );
	
	$this->add_control(
		'email_icon',
		[
			'label' => __( 'Email Icon', 'text-domain' ),
			'type' => \Elementor\Controls_Manager::ICONS,
			'default' => [
				'value' => 'far fa-envelope',
				'library' => 'solid',
			],
		]
	);
	
	

    $this->end_controls_section();
  }
  

	protected function render(){
		
		$settings = $this->get_settings_for_display();
	
		wp_enqueue_style('slick-slider',get_template_directory_uri().'/assets/css/slick.css');
		wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true );
		wp_enqueue_script( 'musicplayer-min', get_template_directory_uri() . '/assets/js/musicplayer-min.js', array('jquery'), '1.0.0', true );
		
		
		/* Style One */
		if($settings['chose_style'] == 'style-one'){ ?>
			<section>
				<div class="w-100 position-relative">
					<div class="feat-wrap v1 text-center position-relative w-100">
						<div class="feat-caro">
						<?php /* List all slides */
							if ( $settings['list'] ) {
							  foreach (  $settings['list'] as $item ) { ?>
								<div class="feat-item">
									<div class="feat-img position-absolute" style="background-image: url(<?php echo $item['slide_image']['url']; ?>);"></div>
									<div class="feat-cap-wrap position-absolute d-inline-block">
										<div class="feat-cap d-inline-block">
										<!-- Slide Icon -->
											<?php if($item['slide_icon']){ ?>
												<i class="d-inline-block <?php echo $item['slide_icon']; ?> thm-clr"></i>
											<?php } ?>
										<!-- Slide Heading -->	
											<?php if($item['slide_heading']){ ?>
												<h2 class="mb-0"><?php echo $item['slide_heading']; ?></h2>
											<?php } ?>
										<!-- Slide Caption -->	
											<?php if($item['slide_caption']){ ?>
												<p class="mb-0"><?php echo $item['slide_caption']; ?></p>
											<?php } ?>
										<!-- Slide Button -->		
											<?php if($item['slide_btn']){ ?>
												<a target = "_blank" class="thm-btn thm-bg" href="<?php echo $item['slide_url']; ?>" title=""><?php echo $item['slide_btn']; ?><span></span><span></span><span></span><span></span></a>
											<?php } ?>
										</div>
									</div>
								</div>
							 <?php }
							} ?>
						</div>
					</div><!-- Featured Area Wrap -->
				</div>
			</section>
			
			<?php if($settings['show_player'] == 'yes'){  ?>
			
			<section>
				<div class="w-100 thm-layer opc7 position-relative">
					<?php /* File Link */
						if($settings['file_link']){ ?>
							<div class="fixed-bg patern-bg back-blend-multiply thm-bg" style="<?php echo tabligh_background('pattern-bg.jpg'); ?> "></div>
					<?php } ?>
					<div class="container">
						<div class="plyr-cont-wrap w-100">
							<div class="row">
							<?php /* player section */
							if($settings['file_link']){ ?>
								<div class="col-md-6 col-sm-6 col-lg-4">
									<div class="plyr-wrp overlap155 w-100">
										<h3 class="mb-0 text-center pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>"><?php echo $settings['audio_player_title']; ?></h3>
										<div class="plyr-inner w-100">
											<div class="plyr w-100">
												<ul class="playlist mb-0 list-unstyled">
													<li data-cover="<?php echo $settings['cover_image']['url']; ?>" data-artist="<?php echo $settings['track_author']; ?>"><a href="<?php echo $settings['file_link']; ?>" title=""><?php echo $settings['track_name']; ?></a></li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							<?php }
							/* info section */
							if($settings['phone_number'] || $settings['email_id']){ ?>
								<div class="col-md-6 col-sm-6 col-lg-8">
									<div class="cont-info w-100">
										<ul class="cont-info-list d-flex flex-wrap mb-0 list-unstyled w-100">
											<?php if($settings['phone_number']){ ?><li><span class="thm-bg"><i class="<?php echo $settings['phone_icon']['value']; ?>"></i></span><?php echo $settings['phone_number']; ?></li><?php } ?>
											<?php if($settings['phone_number']){ ?><li><span class="thm-bg"><i class="<?php echo $settings['email_icon']['value']; ?>"></i></span><a href="mailto:<?php echo $settings['email_id']; ?>;" title=""><?php echo $settings['email_id']; ?></a></li><?php } ?>
										</ul>
									</div>
								</div>
							<?php } ?>
							</div>
						</div><!-- Player & Contact Wrap -->
					</div>
				</div>
			</section>
			<?php }
		} /* end of style one */
		
		/* Style Two */
		if($settings['chose_style'] == 'style-two'){ ?>
			
			<section>
                <div class="w-100 position-relative">
                    <div class="feat-wrap v2 position-relative w-100">
                        <div class="feat-caro">
                           <?php /* List all slides */
							if ( $settings['list'] ) {
							  foreach (  $settings['list'] as $item ) { ?>
								   <div class="feat-item v2">
										<div class="feat-img position-absolute" style="background-image: url(<?php echo $item['slide_image']['url']; ?>);"></div>
										<div class="feat-cap-wrap position-absolute d-inline-block">
											<div class="feat-cap left-icon d-inline-block">
											<!-- Slide Icon -->
												<?php if($item['slide_icon']){ ?><i class="d-inline-block <?php echo $item['slide_icon']; ?> thm-clr"></i><?php } ?>
											<!-- Slide Heading -->
												<?php if($item['slide_heading']){ ?><h2 class="mb-0"><?php echo $item['slide_heading']; ?></h2><?php } ?>
											<!-- Slide Caption -->
												<?php if($item['slide_caption']){ ?><p class="mb-0"><?php echo $item['slide_caption']; ?></p><?php } ?>
											<!-- Slide Button -->
												<?php if($item['slide_btn']){ ?><a target = "_blank" class="thm-btn thm-bg" href="<?php echo $item['slide_url']; ?>" title=""><?php echo $item['slide_btn']; ?><span></span><span></span><span></span><span></span></a><?php } ?>
											</div>
										</div>
									</div>
                             <?php }
							} ?>
                        </div>
                    </div><!-- Featured Area Wrap -->
                </div>
            </section>
			<section>
                <div class="w-100 position-relative">
                    <div class="container">
                    	<div class="plyr-wrp v2 overlap45 overlap-45 w-100">
                            <div class="row mrg">
							<?php /* player section */
								if($settings['file_link']){ ?>
									<div class="col-md-12 col-sm-12 col-lg-4">
										<h3 class="mb-0 text-center pat-bg thm-layer opc65 back-blend-multiply thm-bg" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>"><?php echo $settings['audio_player_title']; ?></h3>
									</div>
									<div class="col-md-12 col-sm-12 col-lg-8">
										<div class="plyr-inner position-relative pat-bg white-layer opc9 back-blend-multiply bg-white" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>);">
											<div class="plyr v2 w-100">
												<ul class="playlist mb-0 list-unstyled">
													<li data-cover="<?php echo $settings['cover_image']['url']; ?>" data-artist="<?php echo $settings['track_author']; ?>"><a href="<?php echo $settings['file_link']; ?>" title=""><?php echo $settings['track_name']; ?></a></li>
												</ul>
											</div>
										</div>
									</div>
								<?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
		
			<?php 
		} /* end of style two */
		
		
		/* Style Three */
		if($settings['chose_style'] == 'style-three'){ ?>
			
			<section>
                <div class="w-100 position-relative slider_3">
					<div class="topbar-left position-absolute">
						<ul class="topbar-info-list mb-0 list-unstyled d-inline-flex">
							<li><i class="thm-clr far fa-envelope"></i><a href="mailto:<?php echo $settings['email_id']; ?>;" title=""><?php echo $settings['email_id']; ?></a></li>
							<li><i class="thm-clr fas fa-phone-alt"></i><?php echo $settings['phone_number']; ?></li>
						</ul>
					</div>
                    <div class="feat-wrap v3 pt-165 pb-345 position-relative w-100" style="background-image: url(<?php echo $settings['slider_3_image']['url']; ?>);">
                        <div class="feat-caro2">
                           <?php /* List all slides */
							if ( $settings['list'] ) {
							  foreach (  $settings['list'] as $item ) { ?>  
								<div class="feat-item v3 position-relative d-flex flex-wrap justify-content-end">
									<img class="img-fluid" src="<?php echo $item['slide_image']['url']; ?>" alt="Featured Image 1">
									<div class="feat-cap-wrap position-absolute d-inline-block">
										<div class="feat-cap left-icon d-inline-block">
											<i class="d-inline-block <?php echo $item['slide_icon']; ?> thm-clr"></i>
											<h2 class="mb-0"><?php echo $item['slide_heading']; ?></h2>
											<p class="mb-0"><?php echo $item['slide_caption']; ?></p>
											<a target = "_blank" class="thm-btn thm-bg" href="<?php echo $item['slide_url']; ?>" title=""><?php echo $item['slide_btn']; ?><span></span><span></span><span></span><span></span></a>
										</div>
									</div>
								</div>
                            <?php }
							} ?> 
                        </div>
                    </div><!-- Featured Area Wrap -->
                </div>
            </section>
			
			<?php 
		} /* end of style Three */
		
		/* Style four */
		if($settings['chose_style'] == 'style-four'){ ?>
			<section>
				<div class="w-100 position-relative">
					<div class="feat-wrap v1 v4 text-center position-relative w-100">
						<div class="feat-caro">
						<?php /* List all slides */
							if ( $settings['list'] ) {
							  foreach (  $settings['list'] as $item ) { ?>
								<div class="feat-item">
									<div class="feat-img position-absolute" style="background-image: url(<?php echo $item['slide_image']['url']; ?>);"></div>
									<div class="feat-cap-wrap position-absolute d-inline-block">
										<div class="feat-cap d-inline-block">
										<!-- Slide Icon -->
											<?php if($item['slide_icon']){ ?>
												<i class="d-inline-block <?php echo $item['slide_icon']; ?> thm-clr"></i>
											<?php } ?>
										<!-- Slide Heading -->	
											<?php if($item['slide_heading']){ ?>
												<h2 class="mb-0"><?php echo $item['slide_heading']; ?></h2>
											<?php } ?>
										<!-- Slide Caption -->	
											<?php if($item['slide_caption']){ ?>
												<p class="mb-0"><?php echo $item['slide_caption']; ?></p>
											<?php } ?>
										</div>
									</div>
								</div>
							 <?php }
							} ?>
						</div>
					</div><!-- Featured Area Wrap -->
				</div>
			</section>
			
			<?php if($settings['show_player'] == 'yes'){  ?>
			
			<section>
				<div class="w-100 thm-layer opc7 position-relative">
					<?php /* File Link */
						if($settings['file_link']){ ?>
							<div class="fixed-bg patern-bg back-blend-multiply thm-bg" style="<?php echo tabligh_background('pattern-bg.jpg'); ?> "></div>
					<?php } ?>
					<div class="container">
						<div class="plyr-cont-wrap w-100">
							<div class="row">
							<?php /* player section */
							if($settings['file_link']){ ?>
								<div class="col-md-6 col-sm-6 col-lg-4">
									<div class="plyr-wrp overlap155 w-100">
										<h3 class="mb-0 text-center pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>"><?php echo $settings['audio_player_title']; ?></h3>
										<div class="plyr-inner w-100">
											<div class="plyr w-100">
												<ul class="playlist mb-0 list-unstyled">
													<li data-cover="<?php echo $settings['cover_image']['url']; ?>" data-artist="<?php echo $settings['track_author']; ?>"><a href="<?php echo $settings['file_link']; ?>" title=""><?php echo $settings['track_name']; ?></a></li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							<?php }
							/* info section */
							if($settings['phone_number'] || $settings['email_id']){ ?>
								<div class="col-md-6 col-sm-6 col-lg-8">
									<div class="cont-info w-100">
										<ul class="cont-info-list d-flex flex-wrap mb-0 list-unstyled w-100">
											<?php if($settings['phone_number']){ ?><li><span class="thm-bg"><i class="<?php echo $settings['phone_icon']['value']; ?>"></i></span><?php echo $settings['phone_number']; ?></li><?php } ?>
											<?php if($settings['phone_number']){ ?><li><span class="thm-bg"><i class="<?php echo $settings['email_icon']['value']; ?>"></i></span><a href="mailto:<?php echo $settings['email_id']; ?>;" title=""><?php echo $settings['email_id']; ?></a></li><?php } ?>
										</ul>
									</div>
								</div>
							<?php } ?>
							</div>
						</div><!-- Player & Contact Wrap -->
					</div>
				</div>
			</section>
			<?php }
		} /* end of style one */

	
	}
}