<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class PriceTable extends Widget_Base{

  public function get_name(){
    return 'price_table';
  }

  public function get_title(){
    return 'Price Table';
  }

  public function get_icon(){
    return 'fa fa-table';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Enrollment Is Ongoing'
      ]
    );

    $this->add_control(
      'element_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'CLASS TIMINGS: MONDAY - THURSDAY 12:00 PM TO 1:30 PM'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax-bg3.jpg',
			],
		]
	);
	
	$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Field Title', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'STARTERS' , 'plugin-domain' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_caption', [
				'label' => __( 'Field Info', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'For 9 to 12 Years Childerns' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'price_currency', [
				'label' => __( 'Price Currency', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'price_amount', [
				'label' => __( 'Price - Amount', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '149' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'tenure', [
				'label' => __( 'Tenure - Time Period', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '/ Y' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'makeit_featured',
			[
				'label' => __( 'Make It Featured', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'your-plugin' ),
				'label_off' => __( 'No', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		/* Features List */
		
		$repeater->add_control(
			'feature_1', [
				'label' => __( 'Feature 1', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Taleemul Quran' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		$repeater->add_control(
			'feature_2', [
				'label' => __( 'Feature 2', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Names of Allah' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		$repeater->add_control(
			'feature_3', [
				'label' => __( 'Feature 3', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Excerpts from the syllabus' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		$repeater->add_control(
			'feature_4', [
				'label' => __( 'Feature 4', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Islamic History' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		$repeater->add_control(
			'feature_5', [
				'label' => __( 'Feature 5', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'How to Perform Namaz' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
		  'button_text',
		  [
			'label' => 'Button Text',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'GET STARTED'
		  ]
		);
		
		$repeater->add_control(
			'button_url',
				[
					'label' => __( 'Button URL', 'tabligh' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => __( '#', 'tabligh' ),
					'show_external' => true,
					'default' => [
						'url' => '#',
						'is_external' => false,
						'nofollow' => false,
					],
				]
		);
	
		
		
		$this->add_control(
			'list',
			[
				'label' => __( 'Price Tables', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[		
			
						'list_title' => __( 'STARTERS', 'plugin-domain' ),
						'list_caption' => __( 'For 9 to 12 Years Childerns', 'plugin-domain' ),
						'price_currency' => __( '$', 'plugin-domain' ),
						'price_amount' => __( '149', 'plugin-domain' ),
						'tenure' => __( '/ Y', 'plugin-domain' ),
						'feature_1' => __( 'Taleemul Quran', 'plugin-domain' ),
						'feature_2' => __( 'Names of Allah', 'plugin-domain' ),
						'feature_3' => __( 'Excerpts from the syllabus', 'plugin-domain' ),
						'feature_4' => __( 'Islamic History', 'plugin-domain' ),
						'feature_5' => __( 'How to Perform Namaz', 'plugin-domain' ),
						'button_text' => __( 'GET STARTED', 'plugin-domain' ),
						'button_url' => __( '#', 'plugin-domain' ),
					],
					[		
			
						'list_title' => __( 'ESSENTIALS', 'plugin-domain' ),
						'list_caption' => __( 'For Age Group 13 yrs - 16 yrs', 'plugin-domain' ),
						'price_currency' => __( '$', 'plugin-domain' ),
						'price_amount' => __( '169', 'plugin-domain' ),
						'tenure' => __( '/ Y', 'plugin-domain' ),
						'feature_1' => __( 'Quran Reading with Tajweed', 'plugin-domain' ),
						'feature_2' => __( 'Islamic Books', 'plugin-domain' ),
						'feature_3' => __( 'Islamic Manners', 'plugin-domain' ),
						'feature_4' => __( 'Islamic History', 'plugin-domain' ),
						'feature_5' => __( 'Online Quran', 'plugin-domain' ),
						'button_text' => __( 'GET STARTED', 'plugin-domain' ),
						'button_url' => __( '#', 'plugin-domain' ),
					],
					[		
			
						'list_title' => __( 'BUSINESS', 'plugin-domain' ),
						'list_caption' => __( 'Age Group 17 + yrs', 'plugin-domain' ),
						'price_currency' => __( '$', 'plugin-domain' ),
						'price_amount' => __( '189', 'plugin-domain' ),
						'tenure' => __( '/ Y', 'plugin-domain' ),
						'feature_1' => __( 'Taleemul Quran', 'plugin-domain' ),
						'feature_2' => __( 'Names of Allah', 'plugin-domain' ),
						'feature_3' => __( 'Excerpts from the syllabus', 'plugin-domain' ),
						'feature_4' => __( 'Islamic History', 'plugin-domain' ),
						'feature_5' => __( 'How to Perform Namaz', 'plugin-domain' ),
						'button_text' => __( 'GET STARTED', 'plugin-domain' ),
						'button_url' => __( '#', 'plugin-domain' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	

    $this->add_inline_editing_attributes('label_heading', 'basic');
    $this->add_render_attribute(
      'label_heading',
      [
        'class' => ['advertisement__label-heading'],
      ]
    );
	    
	$output = '
		<section>
			<div class="w-100 pt-100 black-layer opc8 position-relative">';
			if($settings['background-image']['url']){
				$output .= '<div class="fixed-bg" style="background-image: url('.$settings['background-image']['url'].');"></div>';
			}
			$output .= '
				<div class="container">';
				if($settings['element_title'] || $settings['element_caption']){
					$output .= '
						<div class="sec-title text-center w-100">
							<div class="sec-title-inner d-inline-block">
								<i class="thm-clr '.$settings['heading_icon'].'"></i>
								<h2 class="mb-0">'.$settings['element_title'].'</h2>
								<p class="mb-0">'.$settings['element_caption'].'</p>
							</div>
						</div>';
				}
				$output .= '
				<div class="pack-wrap overlap-115 w-100">
						<div class="pack-inner res-row position-relative w-100">
							<div class="row mrg">';
								if ( $settings['list'] ) {
									
									foreach (  $settings['list'] as $item ) {
										
										if($item['makeit_featured'] == 'yes'){ $active = 'active'; }else{ $active = ''; }
								
									$output .= '
										<div class="col-md-6 col-sm-6 col-lg-4">
											<div class="pack-box '.$active.' w-100">
												<div class="pack-head w-100">';
													if($item['list_title']){ 
														$output .= '<h3 class="mb-0">'.$item['list_title'].'</h3>'; 
													}
													if($item['list_caption']){ 
														$output .= '<p class="mb-0">'.$item['list_caption'].'</p>';
													}
													if($item['price_amount']){ 
														$output .= '<span class="thm-clr"><sup>'.$item['price_currency'].'</sup>'.$item['price_amount'].'<small>'.$item['tenure'].'</small></span>';
													}
													$output .= '
												</div>';

												if($item['feature_1']){
													$output .= '
														<div class="pack-body w-100">
															<ul class="mb-0 list-unstyled w-100">';
																if($item['feature_1']){ $output .= '<li>'.$item['feature_1'].'</li>'; }
																if($item['feature_2']){ $output .= '<li>'.$item['feature_2'].'</li>'; }
																if($item['feature_3']){ $output .= '<li>'.$item['feature_3'].'</li>'; }
																if($item['feature_4']){ $output .= '<li>'.$item['feature_4'].'</li>'; }
																if($item['feature_5']){ $output .= '<li>'.$item['feature_5'].'</li>'; }
																$output .= '
															</ul>';
															if($item['button_text']){
																$output .= '
																	<a class="thm-btn thm-bg" href="'.$item['button_url']['url'].'" title="">'.$item['button_text'].'<span></span><span></span><span></span><span></span></a>';		
															}
															$output .= '
														</div>';
												}
												
												
												$output .= '
											</div>
										</div>';
									}
								}
								$output .= '
							</div>
						</div>
					</div><!-- Packages Wrap -->
				</div>
			</div>
		</section>';
				
		echo $output;
  }
}
