<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class SermonsGrid extends Widget_Base{

  public function get_name(){
    return 'sermons_grid';
  }

  public function get_title(){
    return 'Sermons Grid';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'sermons',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'sermons-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Islamic Sermons'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Duis aute irure dolor in reprehenit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );

	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('sermons', 'sermons-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); ?>
	 
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
					<div class="sec-title v2 text-center w-100">
						<div class="sec-title-inner d-inline-block">
						<?php if($settings['heading_icon']){ ?><i class="<?php echo $settings['heading_icon']; ?> thm-clr"></i><?php } ?>
						<?php if($settings['content_heading']){ ?><h1 class="mb-0"><?php echo $settings['content_heading']; ?></h1><?php } ?>
						<?php if($settings['content_caption']){ ?><p class="mb-0"><?php echo $settings['content_caption']; ?></p><?php } ?>
						</div>
					</div>
				<?php } ?>
				<div class="sermon-wrap wide-sec">
					<div class="row">
					<?php
						if ( have_posts() ) {
							
							while ( have_posts() ) { the_post(); global $post;
			
								static $counter = 1; 
								
								$sermon_video_url = ''; $sermon_audio_url = ''; $sermon_pdf_url = ''; $sermon_short_caption = '';
								$sermon_video_url = get_post_meta( get_the_ID(), 'sermon_video_url', true );
								$sermon_audio_url = get_post_meta( get_the_ID(), 'sermon_audio_url', true );
								$sermon_pdf_url = get_post_meta( get_the_ID(), 'sermon_pdf_url', true );
								$sermon_short_caption = get_post_meta( get_the_ID(), 'sermon_short_caption', true );								
								
								$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 470, 326, 'bfi_thumb' => true )); ?>
							
								<div class="col-md-6 col-sm-6 col-lg-4">
									<div class="sermon-box w-100">
										<div class="sermon-info w-100 position-relative pat-bg thm-layer opc65 back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg'; ?>);">
											<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
											<p class="mb-0"><?php echo wp_trim_words( get_the_excerpt(), $settings['words_count'], '...' ); ?></p>
											<div class="sermon-btns d-inline-flex">
												<?php if($sermon_video_url){ ?>
													<a href="<?php echo esc_url($sermon_video_url);?>" data-fancybox title=""><i class="fas fa-video"></i></a>
												<?php } ?>
												<?php if($sermon_audio_url){ ?>
													<a href="<?php echo esc_url($sermon_audio_url);?>" data-fancybox title=""><i class="fas fa-volume-up"></i></a>
												<?php } ?>
												<?php if($sermon_pdf_url){ ?>
													<a href="<?php echo esc_url($sermon_pdf_url);?>" title="" target="_blank"><i class="far fa-file"></i></a>
												<?php } ?>
											</div>
											<?php if($sermon_short_caption){ ?>
												<span class="position-absolute bg-color1"><?php echo $sermon_short_caption;?></span>
											<?php } ?>
										</div>
										<?php if($featured_image_url){ ?>
											<div class="sermon-img overflow-hidden position-relative w-100">
												<a href="<?php echo get_the_permalink(); ?>" title=""><img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','tabligh');?>"></a>
											</div>
										<?php } ?>
									</div>
								</div>
							<?php 
							}
						} ?>
					</div>
				</div><!-- Sermons Wrap -->
				
				<?php if($settings['display_pagination'] == 'Yes'){ ?>
					<div class="pagination-wrap mt-60 d-flex flex-wrap justify-content-center text-center w-100">
						<ul class="pagination mb-0">
							<?php echo tabligh_numeric_posts_nav(); ?>
						</ul>
					</div><!-- Pagination Wrap -->
				<?php } wp_reset_query(); ?>
			</div>
		</div>
	</section>

    <?php
  }
}