<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ServicesGrid extends Widget_Base{

  public function get_name(){
    return 'services_grid';
  }

  public function get_title(){
    return 'Services Grid';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'services',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'services-cat',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Esteem Services'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Duis aute irure dolor in reprehenit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax-bg2.jpg',
			],
		]
	);
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );

	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More Services'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('services', 'services-cat', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  
	
	if($settings['background-image']['url']){ $classes = "pt-100 paralx-52 black-layer pb-100 opc85"; }else{ $classes = "pt-100 pb-100"; } ?>
	 
	
	<section>
		<div class="w-100 <?php echo $classes; ?> position-relative">

			<?php if($settings['background-image']['url']){ ?>
				<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);"></div>
			<?php } ?>

			<?php if($settings['background-image']['url']){ ?><img class="img-fluid sec-btm-mckp sec-btm-140 position-absolute" src="<?php echo get_template_directory_uri(); ?>/assets/images/sec-top-mckp3.png" alt="<?php esc_attr__('Texture Image','tabligh'); ?>"><?php } ?>
			
			
			<div class="container">
				
				<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
					<div class="sec-title v2 text-center w-100">
						<div class="sec-title-inner d-inline-block">
						<?php if($settings['heading_icon']){ ?><i class="<?php echo $settings['heading_icon']; ?> thm-clr"></i><?php } ?>
						<?php if($settings['content_heading']){ ?><h1 class="mb-0"><?php echo $settings['content_heading']; ?></h1><?php } ?>
						<?php if($settings['content_caption']){ ?><p class="mb-0"><?php echo $settings['content_caption']; ?></p><?php } ?>
						</div>
					</div>
				<?php } ?>
				
				<div class="serv-wrap2 res-row w-100">
					<div class="row">
						<?php
						if ( have_posts() ) {
							
							while ( have_posts() ) { the_post(); global $post;
			
								static $counter = 1; 
								
								$service_icon = '';
								$service_icon = get_post_meta( get_the_ID(), 'service_icon', true ); 
								
								$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 370, 282, 'bfi_thumb' => true )); ?>
							
								<div class="col-md-6 col-sm-6 col-lg-4">
									<div class="serv-box2 text-center position-relative w-100">
										<?php if($featured_image_url){ ?>
											<div class="serv-img overflow-hidden position-relative w-100">
												<a href="<?php echo get_the_permalink(); ?>" title="">
													<img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','tabligh'); ?>">
												</a>
											</div>
										<?php } ?>	
										<div class="serv-info w-100">
											<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title();?></a></h3>
											<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $settings['words_count'], '...' ); ?></p>
										</div>
									</div>
								</div>
							<?php 
							}
						} ?>
					</div>
				</div><!-- Services Wrap 2 -->
				<?php if($settings['button_text']){ ?>
					<div class="view-more mt-20 d-inline-block text-center w-100">
						<a class="thm-btn bg-color1" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a>
					</div><!-- View More -->
				<?php } 

				if($settings['display_pagination'] == 'Yes'){ ?>
					<div class="pagination-wrap mt-30 d-flex flex-wrap justify-content-center text-center w-100">
						<ul class="pagination mb-0">
							<?php echo tabligh_numeric_posts_nav(); ?>
						</ul>
					</div>
				<?php } wp_reset_query();  ?>
			</div>
		</div>
	</section>
    <?php
  }
}