<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class SingleDonation extends Widget_Base{

  public function get_name(){
    return 'single_donation';
  }

  public function get_title(){
    return 'Single Donation';
  }

  public function get_icon(){
    return 'fa fa-newspaper-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	$this->add_control(
		'bg_image',
		[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/pattern-bg.jpg',
			],
		]
	);

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Charity Campaigns'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'icon_class',
      [
        'label' => 'Heading Icon Class',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
      'project_title',
      [
        'label' => 'Charity Project Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Poor Children to Shape Their Own Future'
      ]
    );
	
	$this->add_control(
      'project_caption',
      [
        'label' => 'Charity Project Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'PROJECT IN: NIGERIA'
      ]
    );
	
	$this->add_control(
		'project_description',
		[
			'label' => __( 'Charity Project Description', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'rows' => 5,
			'default' => __( 'Dolor sit amet, Lorem ipsum coteudtu adipi sicing elit, sed do eiusmod tempor incididu dntut labore et.', 'tabligh' ),
			'placeholder' => __( 'Dolor sit amet, Lorem ipsum coteudtu adipi sicing elit, sed do eiusmod tempor incididu dntut labore et.', 'tabligh' ),
		]
	);
	
	$this->add_control(
      'project_amount',
      [
        'label' => 'Charity Project Amount',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '$42,610'
      ]
    );
	
	$this->add_control(
      'project_amount_caption',
      [
        'label' => 'Charity Project Amount Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Donation Needed'
      ]
    );
	
	$this->add_control(
		'project_image_url',
		[
			'label' => __( 'Choose Project Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/camp-img1-1.jpg',
			],
		]
	);
	
	$this->add_control(
      'project_video_url',
      [
        'label' => 'Charity Project Video',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'https://www.youtube.com/embed/WxuHBTES2-s'
      ]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Make Donation'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
    
	$settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  ?>

	<section>
		<div class="w-100 pt-110 gray-layer pb-90 opc85 position-relative">
			<?php if($settings['bg_image']['url']){ ?>
				<div class="fixed-bg patern-bg back-blend-multiply gray-bg" style="background-image: url(<?php echo $settings['bg_image']['url']; ?>);"></div>
			<?php } ?>
			<div class="container">
				<div class="sec-title text-center w-100">
					<div class="sec-title-inner d-inline-block">
						<?php if($settings['icon_class']){ ?><i class="<?php echo esc_html($settings['icon_class']); ?> thm-clr"></i><?php } ?>
						<?php if($settings['content_heading']){ ?><h2 class="mb-0"><?php echo esc_html($settings['content_heading']); ?></h2><?php } ?>
						<?php if($settings['content_caption']){ ?><p class="mb-0"><?php echo esc_html($settings['content_caption']); ?></p><?php } ?>
					</div>
				</div><!-- Sec Title -->
				<div class="camp-wrap w-100">
					<div class="camp-box w-100">
						<div class="row mrg align-items-center">
							<div class="col-md-12 col-sm-12 col-lg-7 order-lg-1">
								<?php if($settings['project_image_url']['url']) { ?>
									<div class="camp-img position-relative w-100">
										<img class="img-fluid w-100" src="<?php echo esc_url($settings['project_image_url']['url']); ?>" alt="Campaign Image 1">
										<?php if($settings['project_video_url']){ ?>
											<a class="thm-bg spinner position-absolute" href="<?php echo esc_url($settings['project_video_url']); ?>" data-fancybox title=""><i class="flaticon-play"></i></a>
										<?php } ?>
									</div>
								<?php } ?>
							</div>
							<div class="col-md-12 col-sm-12 col-lg-5">
								<div class="camp-info pat-bg thm-layer opc8 position-relative back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri(). '/assets/images/pattern-bg.jpg'; ?>);">
								<?php if($settings['project_title']){ ?> 
									<h3 class="mb-0"><?php echo esc_html($settings['project_title']); ?></h3>
								<?php } ?>
								<?php if($settings['project_caption']){ ?> 
									<span class="proj-loc d-block"><?php echo esc_html($settings['project_caption']); ?></span>
									<?php } ?>	
								<?php if($settings['project_description']){ ?> 
									<p class="mb-0"><?php echo esc_html($settings['project_description']); ?></p>
								<?php } ?>
								<?php if($settings['project_amount']){ ?> 
									<div class="goal">
										<span class="price d-block"><?php echo esc_html($settings['project_amount']); ?></span>
										<?php if($settings['project_amount_caption']){ ?> <i class="d-block"><?php echo esc_html($settings['project_amount_caption']); ?></i><?php } ?>
									</div>
								<?php } ?>
								<?php if($settings['button_text']){ ?> 
									<a <?php echo $btarget; ?> class="thm-btn bg-black" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a>
								<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div><!-- Campaign Wrap -->
			</div>
		</div>
	</section>
	
    <?php
  }
}