<?php /* Add POST Meta Boxes */
	
	add_action( 'cmb2_admin_init', 'tabligh_post_posttype_metaboxes' );

	function tabligh_post_posttype_metaboxes() {
		
		$cmb = new_cmb2_box( array(
			'id'            => 'post_posttype_metabox',
			'title'         => __( 'More Post Options', 'tabligh' ),
			'object_types'  => array( 'post', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		$cmb->add_field( array(
			'name' => 'More Content For Post',
			'desc' => 'Add More Text/Description For Posts Content',
			'default' => 'Lorem Ipsum',
			'id' => 'post_secondary_text',
			'type' => 'wysiwyg'
		) );
		
		$cmb->add_field( array(
			'name' => __( 'Video URL', 'cmb2' ),
			'id'   => 'post_video_url',
			'type' => 'text_url',
			'default' => '',
			'desc' => 'https://www.youtube.com/embed/WxuHBTES2-s',
			// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
		) );
		
		$cmb->add_field( array(
			'name'    => 'Sidebar Layout',
			'id'      => 'post_sidebar_layout',
			'type'    => 'radio_inline',
			'options' => array(
				'right' => __( 'Right SideBar', 'cmb2' ),
				'left'   => __( 'Left SideBar', 'cmb2' ),
				'no'     => __( 'No SideBar', 'cmb2' ),
			),
			'default' => 'right',
		) );
		
		$cmb->add_field( array(
			'name'             => 'Select SideBar',
			'desc'             => 'Select Your Desired SideBar',
			'id'               => 'post_sidebar_selected',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => '',
			'options_cb' => 'tabligh_cmb2_get_all_sidebars',
		) );
		
		/* Display Post Meta */
		$cmb->add_field( array(
			'name'    => 'Post Meta',
			'id'      => 'post_meta_views',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
		
		/* Display Sharing & Tags */
		$cmb->add_field( array(
			'name'    => 'Tags & Sharing Links',
			'id'      => 'post_tags_sharing',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
		
		/* Display Author Intro */
		$cmb->add_field( array(
			'name'    => 'Author Intro',
			'id'      => 'post_author_intro',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Author Intro Title',
			'desc'    => 'Add Author Box Intro Title Here',
			'default' => 'About Author:',
			'id'      => 'author_intro_title',
			'type'    => 'text',
		) );

	} /* Meta boxes Ends Here */