<?php
/***** Required Functions For Services Post Type *****/
if ( ! function_exists('prefix_post_type_services') ) {

	/* 1. Register CLASSES Post Type */
	function prefix_post_type_services() {

		$labels = array(
			'name'                  => _x( 'Services', 'Post Type General Name', 'tabligh' ),
			'singular_name'         => _x( 'Service', 'Post Type Singular Name', 'tabligh' ),
			'menu_name'             => __( 'Services', 'tabligh' ),
			'name_admin_bar'        => __( 'Services', 'tabligh' ),
			'archives'              => __( 'Service Archives', 'tabligh' ),
			'attributes'            => __( 'Service Attributes', 'tabligh' ),
			'parent_item_colon'     => __( 'Parent Service:', 'tabligh' ),
			'all_items'             => __( 'All Services', 'tabligh' ),
			'add_new_item'          => __( 'Add New Service', 'tabligh' ),
			'add_new'               => __( 'Add New Service', 'tabligh' ),
			'new_item'              => __( 'Add New Service', 'tabligh' ),
			'edit_item'             => __( 'Edit Service', 'tabligh' ),
			'update_item'           => __( 'Update Service', 'tabligh' ),
			'view_item'             => __( 'View Service', 'tabligh' ),
			'view_items'            => __( 'View Services', 'tabligh' ),
			'search_items'          => __( 'Search Service', 'tabligh' ),
			'not_found'             => __( 'Not found', 'tabligh' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'tabligh' ),
			'featured_image'        => __( 'Service Featured Image', 'tabligh' ),
			'set_featured_image'    => __( 'Set featured image', 'tabligh' ),
			'remove_featured_image' => __( 'Remove featured image', 'tabligh' ),
			'use_featured_image'    => __( 'Use as featured image', 'tabligh' ),
			'insert_into_item'      => __( 'Insert into Service', 'tabligh' ),
			'uploaded_to_this_item' => __( 'Uploaded to this Service', 'tabligh' ),
			'items_list'            => __( 'Services list', 'tabligh' ),
			'items_list_navigation' => __( 'Services list navigation', 'tabligh' ),
			'filter_items_list'     => __( 'Filter Services list', 'tabligh' ),
		);
		$args = array(
			'label'                 => __( 'Services', 'tabligh' ),
			'description'           => __( 'Services Posts Generated By Ingeniofy Plugin', 'tabligh' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
			'hierarchical'          => true,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 20,
			'menu_icon'             => 'dashicons-yes',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'services',
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'services', $args );
	
		/* Add new taxonomy, make it hierarchical (like categories) */
		$cat_labels = array(
			'name'              => _x( 'Service Categories', 'taxonomy general name', 'tabligh' ),
			'singular_name'     => _x( 'Service Category', 'taxonomy singular name', 'tabligh' ),
			'search_items'      => __( 'Search Service Category', 'tabligh' ),
			'all_items'         => __( 'All Service Categories', 'tabligh' ),
			'parent_item'       => __( 'Parent Service Category', 'tabligh' ),
			'parent_item_colon' => __( 'Parent Service Category:', 'tabligh' ),
			'edit_item'         => __( 'Edit Service Category', 'tabligh' ),
			'update_item'       => __( 'Update Service Category', 'tabligh' ),
			'add_new_item'      => __( 'Add New Service Category', 'tabligh' ),
			'new_item_name'     => __( 'New Service Category Name', 'tabligh' ),
			'menu_name'         => __( 'Service Categories', 'tabligh' ),
		);

		$cat_args = array(
			'hierarchical'      => true,
			'labels'            => $cat_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'services-category' ),
		);

		register_taxonomy( 'services-cat', array( 'services' ), $cat_args );

	} /* service post type function ends */

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_services', 0 );
	
	
	/* Add Services Meta Boxes */
	add_action( 'cmb2_admin_init', 'tabligh_services_posttype_metaboxes' );

	function tabligh_services_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'services_metabox',
			'title'         => __( 'Services Options', 'tabligh' ),
			'object_types'  => array( 'services', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Icon Class', 'tabligh' ),
			'desc'       => __( 'Add Flaticon or FontAwesome Class Here e.g flaticon-mat or far fa-envelope', 'tabligh' ),
			'id'         => 'service_icon',
			'type'       => 'text',
		) );

		// List Service field
		$cmb->add_field( array(
			'name' => __( 'Service Details List', 'tabligh' ),
			'desc' => __( 'Add Services List Here, Click -Add Row- To Enter More', 'tabligh' ),
			'id'   => 'service_list',
			'type' => 'text',
			'repeatable' => true,
		) );
	} /* Meta boxes Ends Here */

}