<?php
/***** Required Functions For Team Post Type *****/
if ( ! function_exists('prefix_post_type_team') ) {

	/* 1. Register CLASSES Post Type */
	function prefix_post_type_team() {

		$labels = array(
			'name'                  => _x( 'Team', 'Post Type General Name', 'tabligh' ),
			'singular_name'         => _x( 'Team', 'Post Type Singular Name', 'tabligh' ),
			'menu_name'             => __( 'Team', 'tabligh' ),
			'name_admin_bar'        => __( 'Team', 'tabligh' ),
			'archives'              => __( 'Team Archives', 'tabligh' ),
			'attributes'            => __( 'Team Attributes', 'tabligh' ),
			'parent_item_colon'     => __( 'Parent Team:', 'tabligh' ),
			'all_items'             => __( 'All Team', 'tabligh' ),
			'add_new_item'          => __( 'Add New Team', 'tabligh' ),
			'add_new'               => __( 'Add New Team', 'tabligh' ),
			'new_item'              => __( 'Add New Team', 'tabligh' ),
			'edit_item'             => __( 'Edit Team', 'tabligh' ),
			'update_item'           => __( 'Update Team', 'tabligh' ),
			'view_item'             => __( 'View Team', 'tabligh' ),
			'view_items'            => __( 'View Team', 'tabligh' ),
			'search_items'          => __( 'Search Team', 'tabligh' ),
			'not_found'             => __( 'Not found', 'tabligh' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'tabligh' ),
			'featured_image'        => __( 'Team Featured Image', 'tabligh' ),
			'set_featured_image'    => __( 'Set featured image', 'tabligh' ),
			'remove_featured_image' => __( 'Remove featured image', 'tabligh' ),
			'use_featured_image'    => __( 'Use as featured image', 'tabligh' ),
			'insert_into_item'      => __( 'Insert into Team', 'tabligh' ),
			'uploaded_to_this_item' => __( 'Uploaded to this Team', 'tabligh' ),
			'items_list'            => __( 'Team list', 'tabligh' ),
			'items_list_navigation' => __( 'Team list navigation', 'tabligh' ),
			'filter_items_list'     => __( 'Filter Team list', 'tabligh' ),
		);
		$args = array(
			'label'                 => __( 'Team', 'tabligh' ),
			'description'           => __( 'Team Posts Generated By Ingeniofy Plugin', 'tabligh' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
			'hierarchical'          => true,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 20,
			'menu_icon'             => 'dashicons-id-alt',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'team',
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'team', $args );
		
		/* Add new taxonomy, make it hierarchical (like categories) */
		$cat_labels = array(
			'name'              => _x( 'Team Categories', 'taxonomy general name', 'tabligh' ),
			'singular_name'     => _x( 'Team Category', 'taxonomy singular name', 'tabligh' ),
			'search_items'      => __( 'Search Team Category', 'tabligh' ),
			'all_items'         => __( 'All Team Categories', 'tabligh' ),
			'parent_item'       => __( 'Parent Team Category', 'tabligh' ),
			'parent_item_colon' => __( 'Parent Team Category:', 'tabligh' ),
			'edit_item'         => __( 'Edit Team Category', 'tabligh' ),
			'update_item'       => __( 'Update Team Category', 'tabligh' ),
			'add_new_item'      => __( 'Add New Team Category', 'tabligh' ),
			'new_item_name'     => __( 'New Team Category Name', 'tabligh' ),
			'menu_name'         => __( 'Team Categories', 'tabligh' ),
		);

		$cat_args = array(
			'hierarchical'      => true,
			'labels'            => $cat_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'team-category' ),
		);

		register_taxonomy( 'team-category', array( 'team' ), $cat_args );

	}

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_team', 0 );
	
	/* Add Team Post Type Meta Boxes */
	add_action( 'cmb2_admin_init', 'tabligh_team_posttype_metaboxes' );

	function tabligh_team_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'team_posttype_metabox',
			'title'         => __( 'Team Member Options', 'tabligh' ),
			'object_types'  => array( 'team', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Designation', 'tabligh' ),
			'desc'       => __( 'Add Designation Text Here e.g ISLAMIC SCHOLAR', 'tabligh' ),
			'id'         => 'team_designation',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Courses of Expertise Title', 'tabligh' ),
			'desc'       => __( 'Add Courses of Expertise Title e.g Courses of Expertise:', 'tabligh' ),
			'id'         => 'team_course_title',
			'type'       => 'text',
		) );
		
		$cmb->add_field( array(
			'name' => __( 'Contact Me URL', 'cmb2' ),
			'id'   => 'team_contact_me',
			'type' => 'text_url',
		) );
		
		/* SCHOLAR Information */
		$group_field_id = $cmb->add_field( array(
			'id'          => 'wiki_test_repeat_group',
			'type'        => 'group',
			'description' => __( 'Add Enteries For SCHOLAR Details Like Phone, Email etc', 'tabligh' ),
			// 'repeatable'  => false, // use false if you want non-repeatable group
			'options'     => array(
				'group_title'       => __( 'Team Member Details', 'tabligh' ), // since version 1.1.4, {#} gets replaced by row number
				'add_button'        => __( 'Add Another Entry', 'tabligh' ),
				'remove_button'     => __( 'Remove Entry', 'tabligh' ),
				'sortable'          => true,
				'closed'         => true, // true to have the groups closed by default
				// 'remove_confirm' => esc_html__( 'Are you sure you want to remove?', 'cmb2' ), // Performs confirmation before removing group.
			),
		) );

		// Id's for group's fields only need to be unique for the group. Prefix is not needed.
		$cmb->add_group_field( $group_field_id, array(
			'name' => 'Entry Title',
			'id'   => 'team_info_title',
			'type' => 'text',
			// 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
		) );

		$cmb->add_group_field( $group_field_id, array(
			'name' => 'Description',
			'description' => 'Write a short description for this entry',
			'id'   => 'team_info_description',
			'type' => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Facebook', 'tabligh' ),
			'desc'       => __( 'Add Facebook Profile Link Here: https://facebook.com', 'tabligh' ),
			'id'         => 'team_facebook',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'LinkedIn', 'tabligh' ),
			'desc'       => __( 'Add LinkedIn Profile Link Here e.g https://linkedin.com', 'tabligh' ),
			'id'         => 'team_linkedin',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Twitter', 'tabligh' ),
			'desc'       => __( 'Add Twitter Profile Link Here e.g https://twitter.com', 'tabligh' ),
			'id'         => 'team_twitter',
			'type'       => 'text',
		) );
		
		
		/* SCHOLAR EXPERTISE Information */
		$group_field_id_2 = $cmb->add_field( array(
			'id'          => 'team_expertise_group',
			'type'        => 'group',
			'description' => __( 'SCHOLAR Expertise List Goes Here', 'tabligh' ),
			// 'repeatable'  => false, // use false if you want non-repeatable group
			'options'     => array(
				'group_title'       => __( 'Expertise List', 'tabligh' ), // since version 1.1.4, {#} gets replaced by row number
				'add_button'        => __( 'Add Another Entry', 'tabligh' ),
				'remove_button'     => __( 'Remove Entry', 'tabligh' ),
				'sortable'          => true,
				'closed'         => true, // true to have the groups closed by default
				// 'remove_confirm' => esc_html__( 'Are you sure you want to remove?', 'cmb2' ), // Performs confirmation before removing group.
			),
		) );

		// Id's for group's fields only need to be unique for the group. Prefix is not needed.
		$cmb->add_group_field( $group_field_id_2, array(
			'name' => 'Course Title',
			'id'   => 'team_course_title',
			'type' => 'text',
			// 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
		) );

		$cmb->add_group_field( $group_field_id_2, array(
			'name' => 'Course Link',
			'description' => 'Add Link For Course Link',
			'id'   => 'team_course_link',
			'type' => 'text_url',
		) );

	} /* Meta boxes Ends Here */

}