<?php
class about_widget extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'About Us Widget' );
		parent::__construct('about_widget', '*About Info', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
	$title = $instance['title'];
	$tabligh_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
	$tabligh_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : get_template_directory_uri().'/assets/images/logo2.png';	?>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
			<?php esc_html_e('Title:','tabligh');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</label>
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"></label>
		<?php esc_html_e('Add Description:','tabligh');?>  
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo esc_attr($tabligh_desc); ?></textarea>
    </p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('logo')); ?>">
			<?php esc_html_e('Logo URL:','tabligh');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('logo')); ?>" name="<?php echo esc_attr($this->get_field_name('logo')); ?>" type="text" value="<?php echo esc_attr($tabligh_logo); ?>" />
		</label>
	</p>

  
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['desc'] = $new_instance['desc'];
		$instance['logo'] = $new_instance['logo'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$tabligh_title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$tabligh_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
		$tabligh_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : '';
		
		echo html_entity_decode($before_widget); 
		
		echo '
		
		<div class="widget w-100">
			<div class="logo"><h1 class="mb-0"><a href="'.get_home_url('/').'" title="'.esc_attr__('Home','tabligh').'"><img class="img-fluid" src="'.esc_url($tabligh_logo).'" alt="'.esc_attr__('Logo','tabligh').'" srcset="'.esc_url($tabligh_logo).'"></a></h1></div>
			<p class="mb-0">'.$tabligh_desc.'</p>
		</div>';                    

		/* WIDGET display CODE End*/
		echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of about_widget class */
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget("about_widget");') );
}else{
    function about_widget_init (){
        return register_widget('about_widget');
    }
    add_action ('widgets_init', 'about_widget_init');
}	
?>