<?php
class latest_causes_widget extends WP_Widget
{
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Select Category To Show Causes' );
		parent::__construct('latest_causes_widget', '*Show Causes', $widget_ops);
	
	}
	

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';
	$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';
?>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>   
  
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('get_cate_posts')); ?>">
		  <?php esc_html_e('Select Category:','tabligh');?>
		  <select id="<?php echo esc_attr($this->get_field_id('get_cate_posts')); ?>" name="<?php echo esc_attr($this->get_field_name('get_cate_posts')); ?>" class="widefat">
			<?php
					foreach ( tabligh_get_category_list_array('campaign_category') as $category){ ?>
						<option <?php if(esc_attr($get_cate_posts) == $category->slug){echo 'selected';}?> value="<?php echo esc_attr($category->slug);?>" >
							<?php echo substr($category->name, 0, 20);	if ( strlen($category->name) > 20 ) echo "...";?>
						</option>						
				<?php }?>
		  </select>
	  </label>
	 </p> 
	 
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('nop')); ?>">
		 <?php esc_html_e('Number of Posts To Display:','tabligh');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('nop')); ?>" name="<?php echo esc_attr($this->get_field_name('nop')); ?>" type="text" value="<?php echo esc_attr($nop); ?>" />
	  </label>
	</p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['get_cate_posts'] = $new_instance['get_cate_posts'];	
	$instance['nop'] = $new_instance['nop'];
    return $instance;
  }
  
	function widget($args, $instance)
	{  
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';		
		$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';	
	
		if($nop == ""){$nop = '-1';}
		
		wp_enqueue_style('owl-carousel',get_template_directory_uri().'/assets/css/themecss/owl.carousel.min.css');
		wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/themejs/owl.carousel.min.js', array('jquery'), '1.0.0', true );
		
		echo html_entity_decode($before_widget);	
	
			echo html_entity_decode($before_title);
			
			echo esc_attr($title);
			
			echo html_entity_decode($after_title);
			
			global $wpdb;							
			
			echo '<div class="mini-cause-wrap w-100">';

			$category_array = get_term_by('id', esc_attr($get_cate_posts), 'category');
	
			$popularpost = new WP_Query( 
				array( 'ignore_sticky_posts' 	=> false,
						'posts_per_page' 		=> $nop, 
						'post_type'				=> 'campaign', 
						'meta_key' 				=> 'popular_post_views_count', 
						'orderby' 				=> 'popular_post_views_count meta_value_num', 
						'order'					=> 'DESC'  
					) 
			);
				
				while ( $popularpost->have_posts() ) : $popularpost->the_post(); global $post;
				
					/* Get Campaign Object */
					$campaign = charitable_get_current_campaign();
					
					/* Percentage Donated */
					$percentage_donated_raw = intval($campaign->get_percent_donated_raw());
					
					/* Days Left */
					$campaign_days_left = $campaign->get_time_left();
					
					/* Get Donor Count */
					$campaign_donor_count = $campaign->get_donor_count();
					
					/* Get Currency Symbol */
					//$currency_symbol = Charitable_Currency::get_currency_symbol();
					
					/* Initialize Variables */
					$donated_amount = $goal_amount = $needed_amount = '';
					
					/* Campaign Goal */
					$goal_amount = $campaign->sanitize_campaign_goal( $campaign->get( 'goal' ) );
					
					/* Donated Amount */
					$donated_amount = intval($campaign->get_donated_amount());
					
					/* Amount Left */
					$needed_amount = $goal_amount - $donated_amount;
					
				
					if(strlen(get_the_title()) > 35){
						$title = esc_attr(mb_substr(get_the_title(), 0 , 35)).'...';
					}else{
						$title = get_the_title();
					}
					
					$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 270, 190, 'bfi_thumb' => true )); 
					
					echo '
					
					<div class="mini-cause-box position-relative w-100">
						<img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Image','tabligh').'">
						<div class="mini-cause-info position-absolute">
							<h4 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h4>
							<span class="d-block thm-clr"><i>'.$percentage_donated_raw.'% '.esc_html__('of','tabligh').'</i> '.charitable_format_money($goal_amount).' '.esc_html__('Goal','tabligh').'</span>
						</div>
					</div>';
					
					endwhile; wp_reset_postdata();
				
			echo '</div>';

				

			echo html_entity_decode($after_widget);	
	}
}

if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget("latest_causes_widget");') );
}else{
    function latest_causes_widget_init (){
        return register_widget('latest_causes_widget');
    }
    add_action ('widgets_init', 'latest_causes_widget_init');
}
?>