<?php
    /**
     * ReduxFramework Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    /* This is your option name where all the Redux data is stored. */
    $opt_name = "tabligh_options";

    /* This line is only for altering the demo. Can be easily removed. */
    $opt_name = apply_filters( 'tabligh_options/opt_name', $opt_name );


    $theme = wp_get_theme(); /* For use with some settings. Not necessary. */

    $args = array(
        /* TYPICAL -> Change these values as you need/desire */
        'opt_name'             => $opt_name,
        /* This is where your data is stored in the database and also becomes your global variable name. */
        'display_name'         => $theme->get( 'Name' ),
        /* Name that appears at the top of your panel */
        'display_version'      => $theme->get( 'Version' ),
        /* Version that appears at the top of your panel */
        'menu_type'            => 'menu',
        /* Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only) */
        'allow_sub_menu'       => true,
       /* Show the sections below the admin menu item or not */
        'menu_title'           => esc_html__( 'Theme Options', 'tabligh' ),
        'page_title'           => esc_html__( 'Theme Options', 'tabligh' ),
        'google_api_key'       => '',
        /* Set it you want google fonts to update weekly. A google_api_key value is required. */
        'google_update_weekly' => false,
        /* Must be defined to add google fonts to the typography module */
        'async_typography'     => false,
        /* Use a asynchronous font on the front end or font string */
        'admin_bar'            => true,
        /* Show the panel pages on the admin bar */
        'admin_bar_icon'       => 'dashicons-portfolio',
        /* Choose an icon for the admin bar menu */
        'admin_bar_priority'   => 50,
        /* Choose an priority for the admin bar menu */
        'global_variable'      => '',
        /* Set a different name for your global variable other than the opt_name */
        'dev_mode'             => false,
        /* Show the time the page took to load, etc */
        'update_notice'        => false,
        /* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo */
        'customizer'           => true,
        /* OPTIONAL -> Give you extra features */
        'page_priority'        => null,
        /* Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning. */
        'page_parent'          => 'themes.php',
        /* For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters */
        'page_permissions'     => 'manage_options',
        /* Permissions needed to access the options panel. */
        'menu_icon'            => '',
        /* Specify a custom URL to an icon */
        'last_tab'             => '',
        /* Force your panel to always open to a specific tab (by id) */
        'page_icon'            => 'icon-themes',
        /* Icon displayed in the admin panel next to your menu_title */
        'page_slug'            => '',
        /* Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided */
        'save_defaults'        => true,
        /* On load save the defaults to DB before user clicks save or not */
        'default_show'         => false,
        /* If true, shows the default value next to each field that is not the default value. */
        'default_mark'         => '',
        /* What to print by the field's title if the value shown is default. Suggested: */
        'show_import_export'   => true,
        /* Shows the Import/Export panel when not used as a field. */

        /* CAREFUL -> These options are for advanced use only */
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        /* Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output */
        'output_tag'           => true,
        /* Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head */
        /* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk. */
        'database'             => '',
        /* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning! */
        'use_cdn'              => true,
        /* If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code. */

        /* HINTS */
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    ); 

    /* ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items. */
    $args['admin_bar_links'][] = array(
        'id'    => 'demo',
        'href'  => '',
        'title' => esc_html__( 'demo', 'tabligh' ),
    );

    /* SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons. */
   
    $args['share_icons'][] = array(
        'url'   => esc_url('https://www.facebook.com/company.themes/'),
        'title' => esc_html__('Like us on Facebook', 'tabligh'),
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => esc_url('http://twitter.com/company'),
        'title' => esc_html__('Follow us on Twitter', 'tabligh'),
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => esc_url('http://www.linkedin.com/company/company-dot-com'),
        'title' => esc_html__('Find us on LinkedIn', 'tabligh'),
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( esc_html__( 'Welcome To WordPress Theme Options Panel', 'tabligh' ), $v );
    } else {
        $args['intro_text'] = esc_html__( 'Welcome To WordPress Theme Options Panel', 'tabligh' );
    }

    // Add content after the form.
    $args['footer_text'] = esc_html__( ' ', 'tabligh' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'tabligh' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'tabligh' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'tabligh' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'tabligh' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'tabligh' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*
    As of Redux 3.6+, there is an extensive API. This API can be used in a mix/match mode allowing for
    */
	// -> START General Settings 
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'General Settings', 'tabligh' ),
        'id'               => 'basic-general',
		'icon'             => 'el el-cog',       
        'customizer_width' => '450px',
        'desc'=> esc_html__('Theme General Settings', 'tabligh'),
        'fields'           => array(
            array(
				'id'=>'logo_image',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo', 'tabligh'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your logo Recommended image size:185x58', 'tabligh'),
				'subtitle' => esc_html__('Upload your logo', 'tabligh'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_image_light',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo Light', 'tabligh'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your light colored logo Recommended image size:185x58', 'tabligh'),
				'subtitle' => esc_html__('Upload your light colored logo', 'tabligh'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_image_dark',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Mobile Logo', 'tabligh'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your logo Recommended image size:185x58', 'tabligh'),
				'subtitle' => esc_html__('Upload your Mobile Device Logo', 'tabligh'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_image_sticky',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Sticy Menu Logo', 'tabligh'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your logo Recommended image size:185x58', 'tabligh'),
				'subtitle' => esc_html__('Upload your Sticky Mobile Logo', 'tabligh'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_width',
				'type' => 'text',
				'title' => esc_html__('Logo Width (In Pixels)', 'tabligh'),
				'subtitle' => esc_html__('Add Logo Width In Pixels', 'tabligh'),
				'desc' => esc_html__('Add Logo Width In Pixels Here, i.e 185', 'tabligh'),
				'default' => ''
			),
			
			array(
				'id'=>'logo_height',
				'type' => 'text',
				'title' => esc_html__('Logo Height (In Pixels)', 'tabligh'),
				'subtitle' => esc_html__('Add Logo Height In Pixels', 'tabligh'),
				'desc' => esc_html__('Add Logo Height In Pixels Here, i.e 58', 'tabligh'),
				'default' => ''
			),

        )
    ) );
    
	// -> START Header Settings 
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Settings', 'tabligh' ),
        'id'               => 'homepagesections',
        'desc'             => esc_html__( 'Manage Header Sections!', 'tabligh' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-dashboard'
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Main Settings', 'tabligh' ),
        'id'         => 'StaticBannersettings',
		'icon'             => 'el el-screen',
        'subsection' => true,
        'desc' => esc_html__('Main Settings of Header Section', 'tabligh'), 
        'fields'     => array(
		
			/* Select Header Style */
			array(
				'id'       => 'select-header-layout',
				'type'     => 'image_select',
				'title'    => __('Header Style', 'tabligh'), 
				'subtitle' => __('Select Header for search, blog posts, archive and post detail pages. (For pages, use header option inside pages)', 'tabligh'),
				'options'  => array(
					
					'header1'      => array(
						'alt'   => esc_attr__('Header 1', 'tabligh'),
						'img'   => get_template_directory_uri().'/assets/images/headers/header1.png'
					),
					'header2'      => array(
						'alt'   => esc_attr__('Header 2', 'tabligh'),
						'img'   => get_template_directory_uri().'/assets/images/headers/header2.png'
					),
					'header3'      => array(
						'alt'   => esc_attr__('Header 3', 'tabligh'),
						'img'   => get_template_directory_uri().'/assets/images/headers/header3.png'
					)
				),
				'default' => 'header1'
			),
			
			/*Turn On/Off Sticky Header */		
			array(
				'id' => 'header_stickyhead_switch',
				'type' => 'switch',
				'title' => esc_html__('Sticky Header', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off Sticky Header', 'tabligh'),
				'default' => 0,
            ),

			
			/* Top Bar Switch Fields */		
			array(
				'id' => 'header_topbar_switch',
				'type' => 'switch',
				'title' => esc_html__('Header TopBar', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off Top Bar From Here', 'tabligh'),
				'default' => 0,
            ),
			
			/* Display Namaz Timings */
			array(
				'id' => 'header_namaztime_switch',
				'type' => 'switch',
				'title' => esc_html__('Sunrise & Sunset Timings', 'tabligh'),
				'subtitle' => esc_html__('Sunrise & Sunset Top Bar (Change Country Location from Settings > Salat Times)', 'tabligh'),
				'default' => 0,
            ),
			
			
			/* Jummah Settings */
			array(
				'id'=>'jummah_title',
				'type' => 'text',
				'title' => esc_html__('Friday Prayer Title', 'tabligh'),
				'subtitle' => esc_html__('Add Friday Prayer Title', 'tabligh'),
				'desc' => esc_html__('Add Friday Prayer Title, e.g Jummah', 'tabligh'),
				'default' => esc_html__('Jumah', 'tabligh')
			),
			
			array(
				'id'=>'jummah_start',
				'type' => 'text',
				'title' => esc_html__('Friday Prayer Start', 'tabligh'),
				'subtitle' => esc_html__('Add Friday Prayer Start Time', 'tabligh'),
				'desc' => esc_html__('Add Friday Prayer Start Time, e.g 1:30 PM', 'tabligh'),
				'default' => esc_html__('1:30 PM', 'tabligh')
			),
			
			array(
				'id'=>'jummah_iqamah',
				'type' => 'text',
				'title' => esc_html__('Friday Prayer Iqamah', 'tabligh'),
				'subtitle' => esc_html__('Add Friday Prayer Iqamah Time', 'tabligh'),
				'desc' => esc_html__('Add Friday Prayer Iqamah Time, e.g 2:00 PM', 'tabligh'),
				'default' => esc_html__('2:00 PM', 'tabligh')
			),
			
			array(
				'id'=>'signup_text',
				'type' => 'text',
				'title' => esc_html__('Header Button', 'tabligh'),
				'subtitle' => esc_html__('Add Header Button Text', 'tabligh'),
				'desc' => esc_html__('Add Header Button Text Here, e.g Wants To Visit ?', 'tabligh'),
				'default' => esc_html__('Wants To Visit ?', 'tabligh')
			),
			
			array(
				'id'=>'signup_url',
				'type' => 'text',
				'title' => esc_html__('Header Page URL', 'tabligh'),
				'subtitle' => esc_html__('Add Header Page URL.', 'tabligh'),
				'desc' => esc_html__('Add Header Page Address Here', 'tabligh'),
				'default' => ''
			),
			
			array(
				'id' => 'header_social_switch',
				'type' => 'switch',
				'title' => esc_html__('Social Icons', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off Top Bar Social Icons From Here (For Header 1 & 3)', 'tabligh'),
				'default' => 0,
            ),
			
			
			array(
				'id'=>'phone_number',
				'type' => 'text',
				'title' => esc_html__('Contact Number', 'tabligh'),
				'subtitle' => esc_html__('Add Contact Number Here (Header 2 Only)', 'tabligh'),
				'desc' => esc_html__('Add Contact Number Here, e.g +(00) 123-345-11', 'tabligh'),
				'default' => esc_html__('+(00) 123-345-11', 'tabligh')
			),
			
			array(
				'id'=>'email_id',
				'type' => 'text',
				'title' => esc_html__('Email ID', 'tabligh'),
				'subtitle' => esc_html__('Add Email ID For Contact (Header 2 Only)', 'tabligh'),
				'desc' => esc_html__('Add Email Address Here', 'tabligh'),
				'default' => esc_html__('info@example.com', 'tabligh')
			),

		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Header Background', 'tabligh' ),
        'id'         => 'call-to-section',
		'icon'             => 'el el-picture',
        'subsection' => true,
        'desc' => esc_html__('Upload Inner Header/Breadcrumb Background Image Here', 'tabligh'), 
        'fields'     => array(	
		
			array(
				'id'=>'inner_header_bg',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Header Background', 'tabligh'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> esc_html__('Upload Inner Header Background Image', 'tabligh'),
				'subtitle' => esc_html__('Upload Inner Header Background Image Here', 'tabligh'),
				'default'=>array('url'=>''),
			),
			
			/* breadcrumbs */
			array(
				'id' => 'breadcrumbs',
				'type' => 'switch',
				'title' => esc_html__('Breadcrumbs', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off Breadcrumbs From Here', 'tabligh'),
				'default' => 1,
            ),
			
		
		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Ramadan Timings', 'tabligh' ),
        'id'         => 'ramadan-times',
		'icon'       => 'el el-time',
        'subsection' => false,
        'desc' => esc_html__('Please add ramadan times in described format only, In case of problem please contact author support', 'tabligh'), 
        'fields'     => array(	
			
			array(
				'id'=>'ramadan-sehr-iftar',
				'type' => 'textarea',
				'title' => __('Sehr Iftar Times', 'tabligh'), 
				'subtitle' => __('Please add sehr iftar times here', 'tabligh'),
				'desc' => __('Day 00--sehr AM--iftar PM i.e Apr 25--03:02 AM--08:41 PM', 'tabligh'),
				'validate' => 'no_html',
				'default' => '',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array()
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
				)
			),
			
		
		)
    ) );
	
	// -> START Color Selection
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Color Selection', 'tabligh' ),
        'id'    => 'color',
        'desc'  => esc_html__( 'Color Selection', 'tabligh' ),
        'icon'  => 'el el-brush',
		'fields' => array(
			
			array(
				'id'       => 'color-primary',
				'type'     => 'color',
				'title'    => esc_html__('Primary Color', 'tabligh'), 
				'subtitle' => esc_html__('Pick a Primary Color default: #0a993c', 'tabligh'),
				'default'  => '#0a993c',
				'validate' => 'color',
				'transparent' => false,
			),
			
			array(
				'id'       => 'color-secondary',
				'type'     => 'color',
				'title'    => esc_html__('Secondary Color', 'tabligh'), 
				'subtitle' => esc_html__('Pick a Secondary Color default: #212121', 'tabligh'),
				'default'  => '#212121',
				'validate' => 'color',
				'transparent' => false,
			),
			
			array(
				'id'       => 'select-bodybg-type',
				'type'     => 'select',
				'title'    => esc_html__('Select Background Type', 'tabligh'), 
				'subtitle' => esc_html__('Background Type For Whole Site', 'tabligh'),
				'desc'     => esc_html__('Please select background pattern or background color..', 'tabligh'),
				// Must provide key => value pairs for select options
				'options'  => array(
					'color'		 => esc_html__('Color', 'tabligh'),
					'pattren' 	 => esc_html__('Pattren', 'tabligh'),
					'image' 	 => esc_html__('Image', 'tabligh')
				),
				'default'  => 'color',
			),
			
			array(
				'id'       => 'body_color',
				'type'     => 'color',
				'title'    => esc_html__('Body Background', 'tabligh'), 
				'subtitle' => esc_html__('Only Applicable If you selected Color from Background Type.', 'tabligh'),
				'default'  => '#ffffff',
				'validate' => 'color',
				'transparent' => false,
			),
			
			array(
				'id'       => 'body_patterns',
				'type'     => 'image_select',
				'title'    => esc_html__('Body Pattern', 'tabligh'), 
				'subtitle' => esc_html__('Only Applicable if you selected Pattern From Background Type.', 'tabligh'),
				'options'  => array(
					'1'      => array(
						'alt'   => esc_attr__('Pattern 1','tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-1.png'
					),
					'2'      => array(
						'alt'   => esc_attr__('Pattern 2','tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-2.png'
					),
					'3'      => array(
						'alt'   => esc_attr__('Pattern 3','tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-3.png'
					),
					'4'      => array(
						'alt'   => esc_attr__('Pattern 4','tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-4.png'
					),
					'5'      => array(
						'alt'   => esc_attr__('Pattern 5','tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-5.png'
					),
					'6'      => array(
						'alt'   => esc_attr__('Pattern 6','tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-6.png'
					)
				),
				'default' => '2'
			),
			
			array(
				'id'=>'background_image',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Background Image', 'tabligh'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> esc_html__('Upload Background Image For Body Background', 'tabligh'),
				'subtitle' => esc_html__('Only Applicable if you selected Background Image From Background Type.', 'tabligh'),
				'default'=>array('url'=>''),
			),
			
		)
    ) );
	

	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer Settings', 'tabligh' ),
        'id'               => 'footer-settings',
        'customizer_width' => '500px',
        'icon'             => 'el el-pencil',
		'desc'  => esc_html__( 'You can find all your Footer Settings here.', 'tabligh' ),
		'fields'     => array(
			array(
				'id'=>'footer_copy_right',
				'type' => 'textarea',
				'title' => esc_html__('CopyRight Text - HTML Validated', 'tabligh'), 
				'subtitle' => esc_html__('Custom HTML Allowed (wp_kses)', 'tabligh'),
				'desc' => esc_html__('You can have html in it as well. Allowed Tags Includes a, br, em, strong.', 'tabligh'),
				'validate' => 'html_custom',
				'default' => esc_html__('Copyright 2020, ','tabligh').' <a class="theme-clr" href="#" target="_blank">'.esc_html__('All Rights Reserved','tabligh').'</a>',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'target' => array()
					),
					'br' => array(),
					'p' => array(),
					'em' => array(),
					'strong' => array()
				)
			),
			
			/* Select Footer Style */
			array(
				'id'       => 'select-footer-layout',
				'type'     => 'image_select',
				'title'    => __('Footer Style', 'tabligh'), 
				'subtitle' => __('Select Footer for search, blog posts, archive and post detail pages. (For pages, use Footer option inside pages)', 'tabligh'),
				'options'  => array(
					
					'footer1'      => array(
						'alt'   => esc_attr__('Footer 1', 'tabligh'), 
						'img'   => get_template_directory_uri().'/assets/images/footers/footer1.png'
					),
					'footer2'      => array(
						'alt'   => esc_attr__('Footer 2', 'tabligh'),
						'img'   => get_template_directory_uri().'/assets/images/footers/footer2.png'
					),
					'footer3'      => array(
						'alt'   => esc_attr__('Footer 3', 'tabligh'),
						'img'   => get_template_directory_uri().'/assets/images/footers/footer3.png'
					)
				),
				'default' => 'footer1'
			),
			
			/* Display Namaz Timings */
			array(
				'id' => 'footer_silhoute',
				'type' => 'switch',
				'title' => esc_html__('Remove Footer Top Image', 'tabligh'),
				'subtitle' => esc_html__('Remove Image on The Footer Top', 'tabligh'),
				'default' => 0,
            ),
			
			array(
				'id'=>'footer_3_title',
				'type' => 'text',
				'title' => esc_html__('Footer 3 Newsletter Title', 'tabligh'),
				'subtitle' => esc_html__('Add Footer 3 Newsletter Title Here', 'tabligh'),
				'desc' => esc_html__('Add Footer 3 Newsletter Title Here', 'tabligh'),
				'default' => esc_html__('Sign Up For Our News', 'tabligh')
			),

		)
    ) );
	
	 // -> START Design Fields
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Sidebars', 'tabligh' ),
        'id'    => 'unlimited-sidebars',
        'desc'  => esc_html__( 'You Can Add Unlimited Sidebars From Here.', 'tabligh' ),
        'icon'  => 'el el-th-list',
		'fields' => array(
			array(
				'id'=>'multi-text',
				'type' => 'multi_text',
				'title' => esc_html__('Unlimited Sidebars', 'tabligh'),
				'subtitle' => esc_html__('Add Sidebar Name Here, It will be added.', 'tabligh'),
				'desc' => esc_html__('New Sidebar Will Appear In Appearence > Widgets Panel.', 'tabligh'),
				'default' => array(),
			),
			
			$fields = array(
				'id'       => 'sidebar-layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Default Page Layout', 'tabligh'), 
				'subtitle' => esc_html__('Index, Search, Archive Layout. Default Sidebar Will Be Used', 'tabligh'),
				'options'  => array(
					'left'      => array(
						'alt'   => esc_attr__('Left Sidebar', 'tabligh'), 
						'img'   => esc_url(get_template_directory_uri().'/assets/images/sidebars/left-sidebar.jpg')
					),
					'wide'      => array(
						'alt'   => esc_attr__('No Sidebar', 'tabligh'), 
						'img'   => esc_url(get_template_directory_uri().'/assets/images/sidebars/no-sidebar.jpg')
					),
					'right'      => array(
						'alt'   => esc_attr__('Right Sidebar', 'tabligh'), 
						'img'  => esc_url(get_template_directory_uri().'/assets/images/sidebars/right-sidebar.jpg')
					),
				),
				'default' => 'right'
			),
		)	
    ) );
    
    // -> START Design Fields
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Social Links', 'tabligh' ),
        'id'    => 'social-links',
        'desc'  => esc_html__( 'Put Social Profile Links Here', 'tabligh' ),
        'icon'  => 'el el-glasses',
		'fields' => array(

		array(
			'id'=>'twitter-link',
			'type' => 'text',
			'title' => esc_html__('Twitter Page URL', 'tabligh'),
			'subtitle' => esc_html__('This must be a URL.', 'tabligh'),
			'desc' => esc_html__('Twitter Profile Page URL', 'tabligh'),
			'validate' => 'url',
			'default' => esc_url('http://twitter.com')
			),
			
		array(
			'id'=>'facebook-link',
			'type' => 'text',
			'title' => esc_html__('Facebook Page URL', 'tabligh'),
			'subtitle' => esc_html__('This must be a URL.', 'tabligh'),
			'desc' => esc_html__('Facebook Profile Page URL', 'tabligh'),
			'validate' => 'url',
			'default' => esc_url('http://facebook.com')
			),
			
		array(
			'id'=>'instagram-link',
			'type' => 'text',
			'title' => esc_html__('Instagram Page URL', 'tabligh'),
			'subtitle' => esc_html__('This must be a URL.', 'tabligh'),
			'desc' => esc_html__('Instagram Profile Page URL', 'tabligh'),
			'validate' => 'url',
			'default' => esc_url('https://Instagram.com/')
			),

		array(
			'id'=>'linkedin-link',
			'type' => 'text',
			'title' => esc_html__('LinkedIn Page URL', 'tabligh'),
			'subtitle' => esc_html__('This must be a URL.', 'tabligh'),
			'desc' => esc_html__('LinkedIn Profile Page URL', 'tabligh'),
			'validate' => 'url',
			'default' => esc_url('http://www.linkedin.com/')
			),
		
		array(
			'id'=>'youtube-link',
			'type' => 'text',
			'title' => esc_html__('Youtube Page URL', 'tabligh'),
			'subtitle' => esc_html__('This must be a URL.', 'tabligh'),
			'desc' => esc_html__('Youtube Profile Page URL', 'tabligh'),
			'validate' => 'url',
			'default' => esc_url('http://www.youtube.com/')
			),
		)
    ) );

    // -> START Fonts
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Fonts', 'tabligh' ),
        'id'     => 'Fonts',
        'desc' => esc_html__('Select Fonts for your Website', 'tabligh'),
        'icon'   => 'el el-font',
        'fields' => array(           
            array(
            'id' => 'heading1-font',
            'type' => 'typography',
            'title' => esc_html__('H1 Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
			'units'       =>'px',
            'output' => array('body h1'),
            'default' => array(
                'color' => '#222',
                'font-size' => '60px',
                'font-family' => 'Philosopher',
                'font-weight' => '700',
                ),
         	),

		array(
            'id' => 'heading2-font',
            'type' => 'typography',
            'title' => esc_html__('H2 Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h2'),
            'default' => array(
                'color' => '#222',
                'font-size' => '36px',
                'font-family' => 'Philosopher',
                'font-weight' => '700',
                ),
         	),

		array(
            'id' => 'heading3-font',
            'type' => 'typography',
            'title' => esc_html__('H3 Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
			'all_styles' => true, /* enqueue all fonts */
            'output' => array('body h3'),
            'default' => array(
				'color' => '#222',
                'font-size' => '28px',
                'font-family' => 'Philosopher',
                'font-weight' => '700',
                ),
         	),

		array(
            'id' => 'heading4-font',
            'type' => 'typography',
            'title' => esc_html__('H4 Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h4'),
            'default' => array(
				'color' => '#222',
                'font-size' => '22px',
                'font-family' => 'Philosopher',
                'font-weight' => '700',
                ),
         	),

		array(
            'id' => 'heading5-font',
            'type' => 'typography',
            'title' => esc_html__('H5 Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h5 '),
            'default' => array(
				'color' => '#222',
                'font-size' => '20px',
                'font-family' => 'Philosopher',
                'font-weight' => '700',
                ),
         	),

		array(
            'id' => 'heading6-font',
            'type' => 'typography',
            'title' => esc_html__('H6 Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h6 '),
            'default' => array(
				'color' => '#222',
                'font-size' => '18px',
                'font-family' => 'Philosopher',
                'font-weight' => '700',
                ),
         	),

		array(
            'id' => 'body-font',
            'type' => 'typography',
            'title' => esc_html__('Body Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the body font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
			'all_styles' => true,
            'output' => array('body .elementor-text-editor :not(p), .inf-lst li, .hdr-srch > form input, .pst-mta li, .post-inf > a, .post-bx .post-inf > p, .widget form input, .widget form textarea, .cpy-rgt > p'),
            'default' => array(
                'color' => '#666',
                'font-size' => '16px',
                'font-family' => 'Montserrat',
                'font-weight' => '400',
                ),
         	),
			
			array(
            'id' => 'nav-font',
            'type' => 'typography',
            'title' => esc_html__('Nav Menu Font', 'tabligh'),
            'subtitle' => esc_html__('Specify the Navigantion Menu font properties.', 'tabligh'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('#nav-id li a, .menu-sec nav > div > ul > li, nav > div > ul > li'),
            'default' => array(
                'color' => '#333',
                'font-size' => '18px',
                'font-family' => 'Philosopher',
                'font-weight' => '400',
                ),
         	),
        )
    ) );  
	
		
	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Misc Settings', 'tabligh' ),
        'id'               => 'misc-settings',
        'customizer_width' => '500px',
        'icon'             => 'el el-pencil',
		'desc'  => esc_html__( 'You can find all your Miscellenous Settings here.', 'tabligh' ),
		'fields'     => array(
			array(
				'id' => 'rtl_switch',
				'type' => 'switch',
				'title' => esc_html__('RTL Layout', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off RTL Display of Theme.', 'tabligh'),
				'default' => 0,
            ),
			
			array(
				'id' => 'anime_switch',
				'type' => 'switch',
				'title' => esc_html__('Animation Effects', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off Animation Effects On Blocks.', 'tabligh'),
				'default' => 0,
            ),
			
			array(
				'id'=>'google_map_apikey',
				'type' => 'text',
				'title' => esc_html__('Google Map API Key', 'tabligh'),
				'subtitle' => esc_html__('Add Google Map API Key Here.', 'tabligh'),
				'desc' => esc_html__('You can get API Key From https://developers.google.com/maps/documentation/javascript/get-api-key.', 'tabligh'),
				'default' => ''
			),
			
			array(
				'id' => 'preloader_switch',
				'type' => 'switch',
				'title' => esc_html__('Enable/Disable Preloader', 'tabligh'),
				'subtitle' => esc_html__('Turn on/off Preloader of Theme.', 'tabligh'),
				'default' => 0,
            ),

		)
    ) );

    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/forum-press', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>'.esc_html__('The compiler hook has run!', 'tabligh').'</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = esc_html__('your custom error message', 'tabligh');
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = esc_html__('your custom warning message', 'tabligh');
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'tabligh' ),
                'desc'   => esc_html__( 'This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.', 'tabligh' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = esc_html__('Testing filter hook!', 'tabligh');

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            
        }
    }