<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit38c1852057a6e3ae12ab11237bcb980b
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        require __DIR__ . '/platform_check.php';

        spl_autoload_register(array('ComposerAutoloaderInit38c1852057a6e3ae12ab11237bcb980b', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(__DIR__));
        spl_autoload_unregister(array('ComposerAutoloaderInit38c1852057a6e3ae12ab11237bcb980b', 'loadClassLoader'));

        // Add a custom filter to prevent loading Square classes on incompatible PHP versions
        if (defined('CHARITABLE_SQUARE_AVAILABLE') && !CHARITABLE_SQUARE_AVAILABLE) {
            // Register a function that will prevent loading Square classes
            spl_autoload_register(function($class) {
                // Skip loading classes in the Square namespace
                if (strpos($class, 'Square\\') === 0) {
                    // Return true to indicate the class was "loaded" (prevents other autoloaders from trying)
                    return true;
                }
                // Let other autoloaders handle non-Square classes
                return false;
            }, true, true); // prepend=true to ensure this runs before Composer's autoloader
        }

        require __DIR__ . '/autoload_static.php';
        call_user_func(\Composer\Autoload\ComposerStaticInit38c1852057a6e3ae12ab11237bcb980b::getInitializer($loader));

        $loader->register(true);

        $filesToLoad = \Composer\Autoload\ComposerStaticInit38c1852057a6e3ae12ab11237bcb980b::$files;
        $requireFile = \Closure::bind(static function ($fileIdentifier, $file) {
            if (empty($GLOBALS['__composer_autoload_files'][$fileIdentifier])) {
                $GLOBALS['__composer_autoload_files'][$fileIdentifier] = true;

                require $file;
            }
        }, null, null);
        foreach ($filesToLoad as $fileIdentifier => $file) {
            $requireFile($fileIdentifier, $file);
        }

        return $loader;
    }
}
