<?php

namespace Square\Team\Requests;

use Square\Core\Json\JsonSerializableType;

class ListJobsRequest extends JsonSerializableType
{
    /**
     * The pagination cursor returned by the previous call to this endpoint. Provide this
     * cursor to retrieve the next page of results for your original request. For more information,
     * see [Pagination](https://developer.squareup.com/docs/build-basics/common-api-patterns/pagination).
     *
     * @var ?string $cursor
     */
    private ?string $cursor;

    /**
     * @param array{
     *   cursor?: ?string,
     * } $values
     */
    public function __construct(
        array $values = [],
    ) {
        $this->cursor = $values['cursor'] ?? null;
    }

    /**
     * @return ?string
     */
    public function getCursor(): ?string
    {
        return $this->cursor;
    }

    /**
     * @param ?string $value
     */
    public function setCursor(?string $value = null): self
    {
        $this->cursor = $value;
        return $this;
    }
}
