<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class AboutUsIntro extends Widget_Base{

  public function get_name(){
    return 'about_us_intro';
  }

  public function get_title(){
    return 'About Us Intro';
  }

  public function get_icon(){
    return 'fa fa-file-text';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'ETHICAL & MORAL BELIEFS THAT GUIDES'
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'KNOW THE REAL HISTORY OF ISLAM'
      ]
    );
	
	
	$this->add_control(
		'main_image',
		[
			'label' => __( 'Choose Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/about-img.jpg',
			],
		]
	);
	
	$this->add_control(
		'item_description',
		[
			'label' => __( 'Description', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'rows' => 10,
			'default' => __( 'The is not just a mosque for prayers rather it is a community center for all. The Center is committed to preserving an Islamic identity, building and supporting a viable Muslim community, promoting a comprehensive Islamic way of life based on the Holy Quran and the Sunnah of Prophet Muhammad.', 'tabligh' ),
			'placeholder' => __( 'The is not just a mosque for prayers rather it is a community center for all. The Center is committed to preserving an Islamic identity, building and supporting a viable Muslim community, promoting a comprehensive Islamic way of life based on the Holy Quran and the Sunnah of Prophet Muhammad.', 'tabligh' ),
		]
	);
	
	$this->add_control(
      'btn_url',
      [
        'label' => 'Button URL',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#'
      ]
    );
	
	$this->add_control(
      'btn_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn More'
      ]
    );


	$this->add_control(
      'video_url',
      [
        'label' => 'Video URL',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'https://www.youtube.com/embed/WxuHBTES2-s'
      ]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
	  
    $settings = $this->get_settings_for_display(); ?>
		   
	<section class = "abt-us-home">
		<div class="w-100 pt-100 pb-100 position-relative">
			<img class="img-fluid sec-top-mckp position-absolute" src="<?php echo get_template_directory_uri().'/assets/images/sec-top2-mckp.png'; ?>" alt="<?php esc_attr__('Background','tabligh'); ?>">
			<div class="container">
				<div class="about-wrap4 w-100">
					<div class="row align-items-center">
						<div class="col-md-12 col-sm-12 col-lg-7 order-lg-1">
							<div class="about-video position-relative w-100">
								<img class="img-fluid w-100" src="<?php echo $settings['main_image']['url'];?>" alt="<?php esc_attr__('About Image','tabligh');?>">
								<a class="position-absolute spinner bg-color1" href="<?php echo esc_url($settings['video_url']);?>" data-fancybox title=""><i class="fas fa-play"></i></a>
							</div>
						</div>
						<div class="col-md-12 col-sm-12 col-lg-5">
							<div class="about-inner4 w-100">
								<span class="d-block thm-clr"><?php echo $settings['content_caption'];?></span>
								<h2 class="mb-0"><?php echo $settings['content_heading'];?></h2>
								<?php echo wpautop($settings['item_description']); ?>
								<a class="thm-btn thm-bg mt-30" href="<?php echo esc_url($settings['btn_url']);?>" title=""><?php echo esc_html($settings['btn_text']);?><span></span><span></span><span></span><span></span></a>
							</div>
						</div>
					</div>
				</div><!-- About Wrap 4 -->
			</div>
		</div>
	</section>
	
    <?php
  }
}