<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class AudioWelcomeMessage extends Widget_Base{

  public function get_name(){
    return 'audio_welcome_message';
  }

  public function get_title(){
    return 'Audio Welcome Message';
  }

  public function get_icon(){
    return 'fa fa-file-text';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	$this->add_control(
		'main_image',
		[
			'label' => __( 'Choose Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/bism-img1.png',
			],
		]
	);
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'ETHICAL & MORAL BELIEFS THAT GUIDES'
      ]
    );

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Welcome To Maktab'
      ]
    );
	
	$this->add_control(
		'item_description',
		[
			'label' => __( 'Description', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'default' => __( 'Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nulla vitae elit libero, a pharetra augue.Integer posue re erat a ante venenatis dapibus posuere velit aliquet. Nullam id dolor id nibh ultricies vehicula ut id elit. Sed posuere consectet ur est at lobortis. Donec sed odio dui. Curabitur blandit tempus.', 'plugin-domain' ),
			'placeholder' => __( 'Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Nulla vitae elit libero, a pharetra augue.Integer posue re erat a ante venenatis dapibus posuere velit aliquet. Nullam id dolor id nibh ultricies vehicula ut id elit. Sed posuere consectet ur est at lobortis. Donec sed odio dui. Curabitur blandit tempus.', 'plugin-domain' ),
		]
	);
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn More'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	
	/* Quran Audio Section */
	$this->add_control(
      'audio_player_title',
      [
        'label' => 'Audio Section Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Listen to Quran Audio'
      ]
    );
	
	$this->add_control(
      'track_name',
      [
        'label' => 'Audio File Name To Display',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Surah-Fatiha'
      ]
    );
	
	$this->add_control(
      'track_author',
      [
        'label' => 'Audio File Voice/Detail',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '(Abd-ur-Rahman)'
      ]
    );
	
	/* Media File */
	$this->add_control(
        'file_link',
        [
            'label' => esc_html__( 'Select Track MP3', 'tabligh' ),
            'type'  => 'file-select',
            'placeholder' => esc_html__( 'URL to File', 'tabligh' ),
            'description' => esc_html__( 'Select MP3 from media library or upload', 'tabligh' ),
        ]
    );

	$this->add_control(
		'cover_image',[
			'label' => __( 'Cover Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/audio-img2.jpg',
			],
		]
	);


    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : ''; ?>
	      	    
	<section>
		<div class="w-100 pt-150 pb-100 position-relative">
			<?php if($settings['main_image']['url']){ ?>
				<img class="img-fluid sec-top-mckp position-absolute" src="<?php echo esc_url($settings['main_image']['url']); ?>" alt="<?php esc_attr__('Texture Image','tabligh');?>">
			<?php } ?>
			<div class="container">
				<div class="about-wrap3 w-100">
					<div class="row">
						<div class="col-md-12 col-sm-12 col-lg-5 order-lg-1">
							<div class="plyr-wrp v3 w-100">
								<?php if($settings['audio_player_title']){ ?>
									<h3 class="mb-0 text-center pat-bg dark-layer2 opc5 back-blend-multiply bg-color1" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg';?>);"><?php echo $settings['audio_player_title'];?></h3>
								<?php } ?>
								<?php if($settings['file_link']){ ?>
									<div class="plyr-inner w-100 pat-bg thm-layer opc65 back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg';?>);">
										<div class="plyr v3 w-100">
											<ul class="playlist mb-0 list-unstyled">
												<li data-cover="<?php echo esc_url($settings['cover_image']['url']);?>" data-artist="<?php echo $settings['track_author'];?>"><a href="<?php echo esc_url($settings['file_link']);?>" title=""><?php echo $settings['track_name']; ?></a></li>
											</ul>
										</div>
									</div>
								<?php } ?>
							</div>
						</div>
						<div class="col-md-12 col-sm-12 col-lg-7">
							<div class="about-inner3 w-100">
								<?php if($settings['content_caption']){ ?>
									<span class="d-block thm-clr"><?php echo $settings['content_caption'];?></span>
								<?php } ?>
								<?php if($settings['content_heading']){ ?>
									<h2 class="mb-0"><?php echo $settings['content_heading'];?></h2>
								<?php } ?>
								<?php if($settings['item_description']){ ?>
									<?php echo wpautop($settings['item_description']);?>
								<?php } ?>
								<?php if($settings['button_text']){ ?>
									<a class="thm-btn bg-color1" href="<?php echo $settings['button_url']['url'];?>" title=""><?php echo $settings['button_text'];?><span></span><span></span><span></span><span></span></a>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	
    <?php
  }
}