<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class BlogGrid extends Widget_Base{

  public function get_name(){
    return 'blog_grid';
  }

  public function get_title(){
    return 'Blog Grid';
  }

  public function get_icon(){
    return 'fa fa-th-large';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'post',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'tabligh' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'style1'  => esc_html__( 'Style 1', 'tabligh' ),
				'style2' => esc_html__( 'Style 2', 'tabligh' ),
			],
			'default'   => 'style1',
		]
	);

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Recent News & Updates'
      ]
    ); 

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 1,
			'default' => 3,
		]
    );

	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More News & Updates'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );

	
	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('post', 'category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);

	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';
	
	if($settings['chose_style'] == 'style1'){ 
	
   $output = '
	
	<section>
		<div class="w-100 pt-100 pb-50 position-relative">
			<div class="container">';
			if(!empty($settings['content_caption']) || !empty($settings['content_heading'])){ 
				
				$output .= '
					<div class="sec-title text-center w-100">
						<div class="sec-title-inner d-inline-block">';
							if($settings['heading_icon']){ $output .= '<i class="'.$settings['heading_icon'].' thm-clr"></i>'; }
							if($settings['content_heading']){ $output .= '<h2 class="mb-0">'.$settings['content_heading'].'</h2>'; }
							if($settings['content_caption']){ $output .= '<p class="mb-0">'.$settings['content_caption'].'</p>'; }
							$output .= '
						</div>
					</div>';
			}
			
			$output .= '
				<div class="blog-wrap res-row w-100">
					<div class="row">';
						/* Loop Begins */
						if ( have_posts() ) {
						 
							while ( have_posts() ) { the_post(); global $post;
							
							/* Get Comment Count */
							$comment_count = wp_count_comments( $post->ID );
							
							$comment_count = $comment_count->total_comments;
							
							$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 350, 260, 'bfi_thumb' => true ));
							
							$output .= '
								
								<div class="col-md-6 col-sm-6 col-lg-4">
									<div class="post-box w-100">';
									if($featured_image_url){
										$output .= '
										<div class="post-img overflow-hidden position-relative w-100">
											<a href="'.get_the_permalink().'" title="">
												<img class="img-fluid w-100" src="'.$featured_image_url.'" alt="'.esc_attr__('Featured Image','tabligh').'">
											</a>
										</div>';
									}
										
									$output .= '
										<div class="post-info position-relative w-100">
											<a class="thm-bg" href="'.get_the_permalink().'" title=""><i class="fas fa-link"></i></a>
											<span class="post-date thm-clr">'.get_the_date().'</span>
											<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
											<ul class="post-meta d-flex flex-wrap mb-0 list-unstyled">
												<li><i class="fas fa-user-alt"></i>'.esc_html__('By:','tabligh').' <a href="'.get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ).'" title="">'.get_the_author_meta( 'display_name' , $post->post_author ).'</a></li>
												<li><i class="fas fa-comment-alt"></i>'.$comment_count.' '.esc_html__('Comments','tabligh').'</li>
											</ul>
										</div>
									</div>
								</div>';
							}
						}
						
						$output .= '
					</div>
				</div>';
				
				if($settings['button_text']){
					$output .= '
						<div class="view-more d-inline-block text-center w-100">
							<a '.$btarget.' class="thm-btn mini-btn thm-bg" href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<span></span><span></span><span></span><span></span></a>
						</div>';
				}
				
				/* 1 2 3 Pagination */
				if($settings['display_pagination'] == 'Yes' && function_exists('tabligh_numeric_posts_nav')){
				
					$output .= '
							<div class="pagination-wrap mt-0 d-flex flex-wrap justify-content-center text-center w-100">
								<ul class="pagination mb-0">
									'.tabligh_numeric_posts_nav().'
								</ul>
							</div>';
				}else{
					
					/* Yet To Be Implemented */
				
				} wp_reset_query(); 
					
				$output .= '
			</div>
		</div>
	</section>';

	echo $output;
	
	}
	
	if($settings['chose_style'] == 'style2'){ 
	
   $output = '
   
   <section>
		<div class="w-100 pt-100 pb-120 position-relative">
			<div class="container">';
				if(!empty($settings['content_caption']) || !empty($settings['content_heading'])){ 
				
					$output .= '
						<div class="sec-title text-center w-100">
							<div class="sec-title-inner d-inline-block">';
								if($settings['heading_icon']){ $output .= '<i class="'.$settings['heading_icon'].' thm-clr"></i>'; }
								if($settings['content_heading']){ $output .= '<h2 class="mb-0">'.$settings['content_heading'].'</h2>'; }
								if($settings['content_caption']){ $output .= '<p class="mb-0">'.$settings['content_caption'].'</p>'; }
								$output .= '
							</div>
						</div>';
				}
			
			$output .= '
				<div class="blog-wrap3 res-row w-100">
					<div class="row">';
					/* Loop Begins */
						if ( have_posts() ) {
						 
							while ( have_posts() ) { the_post(); global $post;
							
							/* Get Comment Count */
							$comment_count = wp_count_comments( $post->ID );
							
							$comment_count = $comment_count->total_comments;
							
							$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 350, 260, 'bfi_thumb' => true ));
							
							$video_url = get_post_meta( get_the_ID(), 'post_video_url', false );
							
							$output .= '
						
							<div class="col-md-6 col-sm-6 col-lg-4">
								<div class="post-box3 text-center blog-video position-relative w-100">
									<div class="post-img3 overflow-hidden position-relative w-100">';
									
									if($video_url){
									
									$output .= '
										<a class="position-absolute play-btn" data-fancybox href="'.$video_url[0].'" title="Video">
											<svg version="1.1" class="play" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="10rem" width="10rem" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
												<path class="stroke-dotted" fill="none" stroke="#fff" d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7 C97.3,23.7,75.7,2.3,49.9,2.5"></path> 
												<path class="icon" fill="#fff" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"></path>
											</svg>
										</a>';
									}
									
										$output .= '
										<img class="img-fluid w-100" src="'.$featured_image_url.'" alt="'.esc_attr__('Featured Image','tabligh').'">
									</div>
									<div class="post-info3 w-100">
										<ul class="post-meta3 d-inline-flex flex-wrap justify-content-center align-items-center mb-0 list-unstyled">';
											$category = get_the_category();
											$output .= '
											<li class="thm-clr"><a href = "'.get_category_link($category[0]->cat_ID).'">'.$category[0]->cat_name.'</a></li>
											<li>'.get_the_date('M d, Y').'</li>
										</ul>
										<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
									</div>
								</div>
							</div>';
								
							}
						}
							
							$output .= '
					</div>
				</div>';
				
				if($settings['button_text']){
					$output .= '
						<div class="view-more d-inline-block text-center w-100">
							<a class="thm-btn mini-btn thm-bg" target = "'.$btarget.'" href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<span></span><span></span><span></span><span></span></a>
						</div>';
				}
				
				/* 1 2 3 Pagination */
				if($settings['display_pagination'] == 'Yes' && function_exists('tabligh_numeric_posts_nav')){
				
					$output .= '
							<div class="pagination-wrap text-center">
								<ul class="pagination">
									'.tabligh_numeric_posts_nav().'
								</ul>
							</div>';
				}else{
					
					/* Yet To Be Implemented */
				
				} wp_reset_query(); 
					
				$output .= '
			</div>
		</div>
	</section>';
					

	echo $output;
	
	}
  }
}