<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class BlogList extends Widget_Base{

  public function get_name(){
    return 'blog_list';
  }

  public function get_title(){
    return 'Blog List';
  }

  public function get_icon(){
    return 'fa fa-th-list';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'post',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Latest News & Updates'
      ]
    ); 

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 1,
			'default' => 3,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '20'
      ]
    );

	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More News & Updates'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );

	
	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('post', 'category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);

	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';

	wp_enqueue_style('simple-like-btn',get_template_directory_uri().'/assets/css/simple-like.css');
	wp_enqueue_script( 'simple-like-btn', get_template_directory_uri() . '/assets/js/simple-like.js', array('jquery'), '1.0.0', true );
	
   $output = '
   
   <section>
		<div class="w-100 pt-100 pb-100 position-relative">';
		if($settings['posts_count'] == 1){ 
			$output .= '
			<img class="img-fluid sec-top-mckp position-absolute" src="'.get_template_directory_uri().'/assets/images/sec-top-mckp2.png" alt="'.esc_attr__('Section Image','tabligh').'">';
		}
		$output .= '
			<div class="container">';

			if($settings['content_heading'] || $settings['content_caption']){
				$output .= '
				<div class="sec-title text-center w-100">
					<div class="sec-title-inner d-inline-block">
						<i class="'.$settings['heading_icon'].' thm-clr"></i>
						<h2 class="mb-0">'.$settings['content_heading'].'</h2>
						<p class="mb-0">'.$settings['content_caption'].'</p>
					</div>
				</div>';
			}
			
			$output .= '
				<div class="blog-wrap2 d-inline-block w-100">';
				
				if ( have_posts() ) {
						 
					while ( have_posts() ) { the_post(); global $post;
					
					/* Get Comment Count */
					$comment_count = wp_count_comments( $post->ID );
					
					$comment_count = $comment_count->total_comments;
					
					$user = wp_get_current_user($post->ID);
					$avatar_url = get_avatar_url($user->ID, array("size"=>32));
					
					$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 627, 460, 'bfi_thumb' => true ));
					
					/* it sets the post view */
					tabligh_set_post_view();
				
					$output .= '
						<div class="post-box2 position-relative d-flex flex-wrap align-items-center w-100">';
						
						if($featured_image_url){
							$output .= '
								<div class="post-img2 overflow-hidden position-absolute">
									<a href="'.get_the_permalink().'" title=""><img class="img-fluid w-100" src="'.$featured_image_url.'" alt="'.esc_attr__('Featured Image','tabligh').'"></a>
								</div>';
						}
						
						$output .= '
							<div class="post-info2">
								<div class="post-info2-inner text-center">
									<div class="post-date2">
										<span class="d-block">'.get_the_date('d').'</span>
										<i class="d-block thm-bg">'.get_the_date('M Y').'</i>
									</div>
									<div class="post-meta4 w-100">
										<span class="d-block"><i class="far fa-eye"></i>'.tabligh_get_post_view().'</span>
										<span class="d-block">'.get_simple_likes_button( get_the_ID() ).'</span>
										<span class="d-block"><i class="far fa-comment"></i>'.$comment_count.'</span>
									</div>
								</div>
								<ul class="post-meta2 d-inline-flex flex-wrap align-items-center mb-0 list-unstyled">';
									$category = get_the_category();

									if ( $category[0] ) {
										$output .= '<li class="thm-clr"><i class="far fa-folder-open"></i><a href="' . get_category_link( $category[0]->term_id ) . '">' . $category[0]->cat_name . '</a></li>';
									}
									
									If($avatar_url){
										$output .= '
										<li class="thm-clr"><i class="far fa-edit"></i>'.esc_html__('By:','tabligh').' <a href="'.get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ).'" title="">'.get_the_author_meta( 'display_name' , $post->post_author ).'</a></li>';
									}
									$output .= '
								</ul>
								<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
								<p class="mb-0">'.wp_trim_words( get_the_content(), $settings['words_count'], '...' ).'</p>
								<a class="thm-btn thm-bg" href="'.get_the_permalink().'" title="">'.esc_html__('Continue Reading','tabligh').'<span></span><span></span><span></span><span></span></a>
								<div class="post-share position-relative">
									<i class="fas fa-share"></i>
									<span class="post-share-social position-absolute">
										<a href="http://twitter.com/share?url='.get_the_permalink().'&text='.get_the_title().'" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a>
										<a href="https://www.facebook.com/sharer?u='.get_the_permalink().get_the_title().'" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>
										<a href="https://www.linkedin.com/cws/share?url="'.get_the_permalink().'" title="Linkedin" target="_blank"><i class="fab fa-linkedin-in"></i></a>
									</span>
								</div>
							</div>
						</div>';
						
						}
					}
					$output .= '
	
			</div>';

							
					
					
					/* 1 2 3 Pagination */
					if($settings['display_pagination'] == 'Yes' && function_exists('tabligh_numeric_posts_nav')){
					
						$output .= '
								<div class="pagination-wrap mt-30 d-flex flex-wrap justify-content-center text-center w-100">
									<ul class="pagination mb-0">
										'.tabligh_numeric_posts_nav().'
									</ul>
								</div>';
					}else{
						
						/* Yet To Be Implemented */
					
					} wp_reset_query(); 
					
					if($settings['button_text']){
					
						$output .= '
							<div class="view-more mt-50 d-inline-block text-center w-100">
								<a class="thm-btn bg-color1" href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<span></span><span></span><span></span><span></span></a>
							</div>';
					}
				$output .= '

		</div>
	</section>';

	echo $output;
  }
}