<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CampaignsGrid extends Widget_Base{

  public function get_name(){
    return 'campaign_grid';
  }

  public function get_title(){
    return 'Campaign Grid';
  }

  public function get_icon(){
    return 'fa fa-yelp';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'campaign',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'campaign_category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Maktab Urgent Donations'
      ]
    );

    $this->add_control(
      'element_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );

	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Campaign Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 2,
			'default' => 2,
		]
    );

	$this->add_control(
		  'button_text',
		  [
			'label' => 'Button Text',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'GET STARTED'
		  ]
		);
		
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
	);
	
	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('campaign', 'campaign_category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);
	
	/* Circle Full JS */
	wp_enqueue_script( 'waypoints-min', get_template_directory_uri() . '/assets/js/waypoints.min.js', array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'circlefull-min', get_template_directory_uri() . '/assets/js/circle-progress.min.js', array('jquery'), '1.0.0', true );
	
	if($settings['element_title'] || $settings['element_caption']){ $top_margins = "pt-210 pb-70"; }else{ $top_margins = "pt-100 pb-100";}
	
    if ( class_exists( 'Charitable' ) ) { /* If Charitable Activated */ 		
				
		$output = '
		
		<section>
			<div class="w-100  '.$top_margins.' position-relative">
				<div class="container">';
				if($settings['element_title'] || $settings['element_caption']){
					
				$output .= '
					<div class="sec-title text-center w-100">
						<div class="sec-title-inner d-inline-block">';
							if($settings['heading_icon']){ $output .= '<i class="thm-clr '.$settings['heading_icon'].'"></i>'; }
							if($settings['element_title']){ $output .= '<h2 class="mb-0">'.$settings['element_title'].'</h2>'; }
							if($settings['element_caption']){ $output .= '<p class="mb-0">'.$settings['element_caption'].'</p>'; }
							$output .= '
						</div>
					</div>';
				}
				

				$output .= '

					<div class="donat-wrap w-100">
						<div class="row">';
							
						if ( have_posts() ) {
								 
							while ( have_posts() ) { the_post(); global $post;

								/* Get Campaign Object */
								$campaign = charitable_get_current_campaign();
								
								/* Percentage Donated */
								$percentage_donated_raw = intval($campaign->get_percent_donated_raw());
								
								/* Days Left */
								$campaign_days_left = $campaign->get_time_left();
								
								/* Get Donor Count */
								$campaign_donor_count = $campaign->get_donor_count();
								
								/* Get Currency Symbol */
								//$currency_symbol = Charitable_Currency::get_currency_symbol();
								
								/* Initialize Variables */
								$donated_amount = $goal_amount = $needed_amount = '';
								
								/* Campaign Goal */
								$goal_amount = $campaign->sanitize_campaign_goal( $campaign->get( 'goal' ) );
								
								/* Donated Amount */
								$donated_amount = intval($campaign->get_donated_amount());
								
								/* Amount Left */
								$needed_amount = $goal_amount - $donated_amount;
								
								static $counter = 1;
								
								$campaign_location = get_post_meta( get_the_ID(), 'campaign_location', true );
								
								$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 570, 310, 'bfi_thumb' => true ));
							
								$output .= '
									<div class="col-md-12 col-sm-12 col-lg-6">
										<div class="urgent-donat-box w-100">';
										if($featured_image_url){
											
											$output .= '
												<div class="urgent-donat-img overflow-hidden position-relative w-100">
													<img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Donation Campaign','tabligh').'">
													<a class="thm-btn thm-bg position-absolute" href="'.esc_url(get_the_permalink()).'/donate" title="">'.esc_html__('Donate Now','tabligh').'<span></span><span></span><span></span><span></span></a>
												</div>';
										}

										$output .= '	
											<div class="urgent-donat-info pat-bg gray-layer opc9 position-relative back-blend-multiply gray-bg w-100" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">
												<span class="donate-goal d-block thm-clr">'.esc_html__('Goal','tabligh').': '.charitable_format_money($goal_amount).'</span>
												<h3 class="mb-0"><a href="'.esc_url(get_the_permalink()).'" title="">'.get_the_title().'</a></h3>
												<ul class="urgent-donat-meta d-inline-flex flex-wrap mb-0 list-unstyled">';
													if($campaign_location){
														$output .= '<li class="thm-clr">'.$campaign_location.'</li>';
													}
													$output .= '<li><i class="fas fa-heart thm-clr"></i>'.$campaign_donor_count.' '.esc_html__('Donors','tabligh').'</li>
												</ul>';
												?>
												<script>
													jQuery(document).ready(function($){
														'use strict';
														$("#goal-prog<?php echo $counter; ?>").waypoint(function(){
														  $("#goal-prog<?php echo $counter; ?>").circleProgress({
															value: 0.<?php echo $percentage_donated_raw; ?>,
															fill: {color: '#147736'},
															thickness: 5,
															emptyFill: '#fff',
															size: 100
														  }).on('circle-animation-progress', function(event, progress) {
															$(this).find('span').html(Math.round(<?php echo $percentage_donated_raw; ?> * progress) + '<i>%</i>');
														  });
														}, { offset: '70%'})
													});
												</script>
												
												<?php
												$output .= '
												<div class="urgent-donat-info-raised pat-bg thm-layer opc7 position-absolute back-blend-multiply thm-bg w-100" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">
													<div class="urgent-progress" id="goal-prog'.$counter.'"><span></span></div>
													<span class="d-block">'.charitable_format_money($donated_amount).'</span>
													<i class="d-block">'.esc_html__('Raised','tabligh').'</i>
												</div>
											</div>
										</div>
									</div>';
									
									$counter++;
							}
						}
						
						
							
							$output .= '
						</div>
					</div>';
					
					/* 1 2 3 Pagination */
						if($settings['display_pagination'] == 'Yes' && function_exists('tabligh_numeric_posts_nav')){
						
							$output .= '
									<div class="pagination-wrap mt-30 d-flex flex-wrap justify-content-center text-center w-100">
										<ul class="pagination mb-0">
											'.tabligh_numeric_posts_nav().'
										</ul>
									</div>';
						}else{
							
							/* Yet To Be Implemented */
						
						} wp_reset_query(); 
						
						if($settings['button_text']){ 
					
							$output .= '
								<div class="view-more mt-30 d-inline-block text-center w-100">
									<a class="thm-btn bg-color1" href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<span></span><span></span><span></span><span></span></a>
								</div>';
						}	
					
					$output .= '
				</div>
			</div>
		</section>';
			
						
		echo $output;	
		
		}else{ 
		
			$output = '
				<section>
					<div class="w-100 pt-210 pb-120 position-relative">
						<div class="container">
								<div class="row"><strong>'.esc_html_e('Please Make Sure That You Have Installed Chariable Plugin','tabligh').'</strong></div>
							</div>
						</div>
					</div>
				</section>';
				
				echo $output;
							
		} /* endif class exists */
  }
}
