<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CTA extends Widget_Base{

  public function get_name(){
    return 'cta';
  }

  public function get_title(){
    return 'Call To Action';
  }

  public function get_icon(){
    return 'fa fa-exclamation-circle';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'To Donate month-to-month , please use the monthly donation form'
      ]
    );

    $this->add_control(
      'element_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Consectetur adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax-bg4.jpg',
			],
		]
	);

	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Donate'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  ?>

	<section>
		<div class="w-100 pt-110 black-layer pb-110 opc85 position-relative">
			<?php if($settings['background-image']['url']){ ?>
        <div class="fixed-bg" style="background-image: url(<?php echo $settings['background-image']['url']; ?>);"></div>
      <?php } ?>
			<div class="container">
				<div class="month-donat-wrap text-center w-100">
					<div class="month-donat-inner d-inline-block">
					<?php if($settings['heading_icon']){ ?>	<i class="thm-clr <?php echo $settings['heading_icon']; ?>"></i><?php } ?>
					<?php if($settings['element_title']){ ?><h2 class="mb-0"><?php echo $settings['element_title']; ?></h2><?php } ?>
          <?php if($settings['element_caption']){ ?><p class="mb-0"><?php echo $settings['element_caption']; ?></p><?php } ?>
          <?php if($settings['button_text']){ ?><a class="thm-btn thm-bg" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a><?php } ?>
					</div>
				</div><!-- Monthly Donate Wrap -->
			</div>
		</div>
	</section>
    <?php
  }
}
