<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class EventsGrid extends Widget_Base{

  public function get_name(){
    return 'events_grid';
  }

  public function get_title(){
    return 'Events Grid';
  }

  public function get_icon(){
    return 'fa fa-calendar';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'event',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'event-categories',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Up-Coming Events'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'icon_class',
      [
        'label' => 'Heading Icon Class',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );

	$this->add_control(
		'top_image',
			[
				'label' => __( 'Section Top Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/sec-top-mckp2.png',
				],
			]
	);
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Event Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Event Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 1,
			'default' => 3,
		]
    );
	
	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();

	echo tabligh_events_grid_elementor_block($settings['content_heading'], $settings['content_caption'], $settings['icon_class'], $settings['top_image']['url'], $settings['select_category'], $settings['posts_count'], $settings['display_pagination']);
  }
}
