<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class FactCounts extends Widget_Base{

  public function get_name(){
    return 'fact_counts';
  }

  public function get_title(){
    return 'Fact Counts';
  }

  public function get_icon(){
    return 'fa fa-pie-chart';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'tabligh' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'dark'  => esc_html__( 'Dark', 'tabligh' ),
				'light' => esc_html__( 'Light', 'tabligh' ),
			],
			'default'   => 'dark',
		]
	);

	$repeater = new \Elementor\Repeater();
	
    $repeater->add_control(
      'fact_count',
      [
        'label' => 'Fact Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '74,300'
      ]
    );

	$repeater->add_control(
      'fact_text',
      [
        'label' => 'Fact Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Community Members'
      ]
    );
	
	$repeater->add_control(
      'icon_class',
      [
        'label' => 'Custom Icon Class',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-mosque-3'
      ]
    );

	$repeater->add_control(
		'icon',
		[
			'label' => __( 'Fact Icon', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::ICON,
			'default' => 'fa fa-facebook',
		]
	);
		   
	$this->add_control(
		'list',
			[
			'label' => __( 'Fact Counts', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[		
					'fact_count' => __( '74,300', 'plugin-domain' ),
					'fact_text' => __( 'Community Members', 'plugin-domain' ),
					'icon_class' => __( 'flaticon-mosque-3', 'plugin-domain' ),
					'icon' => __( '', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '410', 'plugin-domain' ),
					'fact_text' => __( 'Inspirational Sermons', 'plugin-domain' ),
					'icon_class' => __( 'flaticon-mat-1', 'plugin-domain' ),
					'icon' => __( '', 'plugin-domain' ),
				],
				[	
					'fact_count' => __( '8,100', 'plugin-domain' ),
					'fact_text' => __( 'Islamic Years Together', 'plugin-domain' ),
					'icon_class' => __( 'flaticon-beads', 'plugin-domain' ),
					'icon' => __( '', 'plugin-domain' ),
				],
			],
			'title_field' => '{{{ fact_text }}}',
			]
		);
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display(); 
	
	wp_enqueue_script( 'counterup.min', get_template_directory_uri() . '/assets/js/counterup.min.js', array('jquery'), '1.0.0', true ); ?>

	<?php if($settings['chose_style'] == 'dark'){ ?>
	<section>
		<div class="w-100 pt-80 thm-layer pb-50 opc7 position-relative">
			<div class="fixed-bg patern-bg back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/images/pattern-bg.jpg);"></div>
			<div class="container">
				<div class="facts-wrap w-100">
					<div class="row">
					<?php 
						if ( $settings['list'] ) {
										
							foreach (  $settings['list'] as $item ) { ?>
							
							<div class="col-md-4 col-sm-6 col-lg-4">
								<div class="fact-box d-flex flex-wrap align-items-center w-100">
									<span class="rounded-circle"><i class="<?php echo $item['icon_class']; ?> <?php echo $item['icon']; ?>"></i></span>
									<div class="fact-inner">
										<h3 class="mb-0 counter"><?php echo $item['fact_count']; ?></h3>
										<h5 class="mb-0"><?php echo $item['fact_text']; ?></h5>
									</div>
								</div>
							</div>
							
							<?php 
							}
						}
					?>
					</div>
				</div><!-- Facts Wrap -->
			</div>
		</div>
	</section>
	
	<?php } ?>
	
	<?php if($settings['chose_style'] == 'light'){ ?>
	
	<section>
		<div class="w-100 pt-80 white-layer pb-50 opc9 position-relative">
			<div class="fixed-bg patern-bg back-blend-multiply white-bg" style="background-image: url(<?php echo get_template_directory_uri();?>/assets/images/pattern-bg.jpg);"></div>
			<div class="container">
				<div class="facts-wrap w-100">
					<div class="row">
					<?php 
						if ( $settings['list'] ) {
										
							foreach (  $settings['list'] as $item ) { ?>
							
							<div class="col-md-4 col-sm-6 col-lg-4">
								<div class="fact-box d-flex flex-wrap align-items-center w-100">
									<span class="rounded-circle"><i class="<?php echo $item['icon_class']; ?> <?php echo $item['icon']; ?>"></i></span>
									<div class="fact-inner">
										<h3 class="mb-0 counter"><?php echo $item['fact_count']; ?></h3>
										<h5 class="mb-0"><?php echo $item['fact_text']; ?></h5>
									</div>
								</div>
							</div>
							
							<?php 
							}
						}
					?>
					</div>
				</div><!-- Facts Wrap -->
			</div>
		</div>
	</section>
	
	<?php } /* End of style light */

  }
}
