<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class FeaturedScholars extends Widget_Base{

  public function get_name(){
    return 'featured-scholar';
  }

  public function get_title(){
    return 'Featured + Scholars';
  }

  public function get_icon(){
    return 'fa fa-user';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'team',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'team-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}
		
		if($categories){
			$featuredcategoryArray[0] = "All";
			foreach($categories as $category_list){
				$featuredcategoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$featuredcategoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Our Board Member'
      ]
    ); 

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Duis aute irure dolor in reprehenit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/sec-bg2.jpg',
			],
		]
	);
	
	$this->add_control(
		'featured_select_category',
		[
			'label' => __( 'Featured Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $featuredcategoryArray,
		]
	);
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Team Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 32,
			'step' => 1,
			'default' => 4,
		]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('team', 'team-category', $settings['featured_select_category'], 1, $settings['sortby'], $settings['orderby']);
	
	$output = '
	
	<section>
		<div class="w-100 black-layer opc1 position-relative">
			<div class="fixed-bg" style="background-image: url('.$settings['background-image']['url'].');"></div>
			<div class="team-wrap2 w-100">
				<div class="row align-items-center mrg">
					<div class="col-md-12 col-sm-12 col-lg-5">';
					if ( have_posts() ) {
									
						static $counter = 1;
						
						while ( have_posts() ) { the_post(); global $post;
						
							$team_designation = ''; $team_facebook = ''; $team_linkedin = ''; $team_twitter = '';
							$team_designation = get_post_meta( get_the_ID(), 'team_designation', true );
							$team_facebook = get_post_meta( get_the_ID(), 'team_facebook', true );
							$team_linkedin = get_post_meta( get_the_ID(), 'team_linkedin', true );
							$team_twitter = get_post_meta( get_the_ID(), 'team_twitter', true );
							
							$featured_image_url_large = get_the_post_thumbnail_url($post->ID, array( 575, 732, 'bfi_thumb' => true ));
							
							$output .= '
							
								<div class="team-box2 position-relative overflow-hidden w-100">
									<img class="img-fluid w-100" src="'.esc_url($featured_image_url_large).'" alt="'.esc_attr__('Featured Author','tabligh').'">
									<div class="team-info2 position-absolute w-100">
										<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
										<span class="d-block">'.$team_designation.'</span>
										<div class="social-links2 text-center d-inline-flex">
											<a class="facebook" href="'.esc_url($team_facebook).'" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>
											<a class="twitter" href="'.esc_url($team_twitter).'" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a>
											<a class="youtube" href="'.esc_url($team_linkedin).'" title="Linkedin" target="_blank"><i class="fab fa-linkedin-in"></i></a>
										</div>
									</div>
								</div>';
						}
					} wp_reset_query();
					
					/* Get Posts */
					$posts = tabligh_get_post_query('team', 'team-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);
						
					$output .= '	
					</div>
					<div class="col-md-12 col-sm-12 col-lg-7">
						<div class="team-wrap2-inner d-flex flex-wrap justify-content-center w-100">
							<div class="team-inner2-wrap">';
							if(!empty($settings['content_caption']) || !empty($settings['content_heading'])){ 
								$output .= '
									<div class="sec-title v2 left-icon w-100">
										<div class="sec-title-inner d-inline-block">';
											if($settings['heading_icon']){ $output .= '<i class="thm-clr '.$settings['heading_icon'].'"></i>'; }
											if($settings['content_heading']){ $output .= '<h2 class="mb-0">'.$settings['content_heading'].'</h2>'; }
											if($settings['content_caption']){ $output .= '<p class="mb-0">'.$settings['content_caption'].'</p>'; }
											$output .= '
										</div>
									</div>';
							}
							$output .= '
								<div class="team-inner2 res-row w-100">
									<div class="row">';
									if ( have_posts() ) {
									
										static $counter = 1;
										
										while ( have_posts() ) { the_post(); global $post;
										
											$team_designation = ''; $team_facebook = ''; $team_linkedin = ''; $team_twitter = '';
											$team_designation = get_post_meta( get_the_ID(), 'team_designation', true );
											$team_facebook = get_post_meta( get_the_ID(), 'team_facebook', true );
											$team_linkedin = get_post_meta( get_the_ID(), 'team_linkedin', true );
											$team_twitter = get_post_meta( get_the_ID(), 'team_twitter', true );
											
											$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 242, 250, 'bfi_thumb' => true ));
											
											$output .= '
											<div class="col-md-6 col-sm-6 col-lg-4">
												<div class="team-box v2 text-center w-100">
													<div class="team-img overflow-hidden position-relative w-100">
														<img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Images','tabligh').'">
														<div class="social-links2 text-center d-inline-flex position-absolute">
															<a class="facebook" href="'.esc_url($team_facebook).'" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>
															<a class="twitter" href="'.esc_url($team_twitter).'" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a>
															<a class="youtube" href="'.esc_url($team_linkedin).'" title="Linkedin" target="_blank"><i class="fab fa-linkedin-in"></i></a>
														</div>
													</div>
													<div class="team-info">
														<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
													</div>
												</div>
											</div>';
										}
									} wp_reset_query();
									
									$output .= '			
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div><!-- Team Wrap 2 -->
		</div>
	</section>';
			
	echo $output;
  }
}