<?php
function tabligh_get_post_query( $post_type, $post_category, $category_name, $num_posts, $sortby, $orderby) {

	global $wpdb,$post;

	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

	if($category_name != 'All' && !empty($category_name)){
		
		$term = '';
		
		$term = get_term_by('name', $category_name, $post_category);
		
		if(is_object($term)){
		
			$category_id = $term->term_id;
			
			$stack_cat_all = array('tax_query' => array(
					array(
						'taxonomy' => $post_category,
						'terms' => $category_id,
						'field' => 'term_id',
					)
				),
			);
			
			$args = array( 
				'post_type' => $post_type,
				'posts_per_page' => $num_posts,
				'ignore_sticky_posts' => 1,
				'paged' 			=> $paged,
				'tax_query' => array(
					array(
						'taxonomy' => $post_category,
						'terms' => $category_id,
						'field' => 'term_id',
					)
				), 
				'post_status'       => 'publish',
				'orderby' 			=> $sortby,
				'order' 			=> $orderby
			);
			
		}else{
		
			$args = array( 
				'post_type' 		=> $post_type,
				'ignore_sticky_posts' => 1,
				'post_status'       => 'publish',
				'paged' 			=> $paged,
				'posts_per_page' 	=> $num_posts,
				'orderby'		 	=> $sortby,
				'order' 			=> $orderby
			);
		
		}
	
	}else{
	
		
		$args = array( 
			'post_type' 		=> $post_type,
			'post_status'       => 'publish',
			'ignore_sticky_posts' => 1,
			'paged' 			=> $paged,
			'posts_per_page' 	=> $num_posts,
			'orderby'		 	=> $sortby,
			'order' 			=> $orderby
		);
	
	}
	
	return query_posts($args);
}


function tabligh_elementor_custom_categories( $elements_manager ) {

    $elements_manager->add_category(
        'nauthemes',
        [
         'title' => __( 'Nauthemes Widgets', 'tabligh' ),
         'icon' => 'fa fa-plug',
        ]
    );
}
add_action( 'elementor/elements/categories_registered', 'tabligh_elementor_custom_categories' );
?>