<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class InfoBoxes extends Widget_Base{

  public function get_name(){
    return 'infoboxes';
  }

  public function get_title(){
    return 'Info Boxes';
  }

  public function get_icon(){
    return 'fa fa-envelope-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	
	$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Field Title', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Phone Number' , 'plugin-domain' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_caption', [
				'label' => __( 'Field Info', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '+01 (222) 123 4567' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'list_caption2', [
				'label' => __( 'Field Info', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '+01 (222) 123 4585' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'list_icon',
			[
				'label' => __( 'Default Icons', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'flaticon-call',
				'options' => [
					'flaticon-mail' => __( 'Email', 'plugin-domain' ),
					'flaticon-call' => __( 'Phone', 'plugin-domain' ),
					'fas fa-map-marker-alt'  => __( 'Address', 'plugin-domain' ),
				],
			]
		);
		
		$repeater->add_control(
			'list_fontAwesome', [
				'label' => __( 'FontAwesome Icon Class', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'fa fa-camera' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'Info Boxes', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Phone Number', 'plugin-domain' ),
						'list_caption' => __( '+01 2565 2565 25', 'plugin-domain' ),
						'list_caption2' => __( '+01 2565 2565 26', 'plugin-domain' ),
						'list_icon' => __( 'flaticon-call', 'plugin-domain' ),
						'list_fontAwesome' => __( '', 'plugin-domain' ),
					],
					[		
			
						'list_title' => __( 'Email Address', 'plugin-domain' ),
						'list_caption' => __( 'help@tabligh.com', 'plugin-domain' ),
						'list_caption2' => __( 'support@tabligh.com', 'plugin-domain' ),
						'list_icon' => __( 'flaticon-mail', 'plugin-domain' ),
						'list_fontAwesome' => __( '', 'plugin-domain' ),
					],
					[
						'list_title' => __( 'Address', 'plugin-domain' ),
						'list_caption' => __( 'New Street Town No 20x lake New,', 'plugin-domain' ),
						'list_caption2' => __( 'York City, NY-101 US', 'plugin-domain' ),
						'list_icon' => __( 'fas fa-map-marker-alt', 'plugin-domain' ),
						'list_fontAwesome' => __( '', 'plugin-domain' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
	

    $this->end_controls_section();
  }
  

  protected function render(){
    
	$settings = $this->get_settings_for_display();
	
	$output = '
	
	<section>
		<div class="w-100 pt-70 opc6 position-relative">
			<div class="container">
				<div class="cont-info-wrap w-100">
					<div class="row">';
					
					if ( $settings['list'] ) {
						
						foreach (  $settings['list'] as $item ) {
					
							$output .= '
								
								<div class="col-md-4 col-sm-6 col-lg-4">
									<div class="cont-info-box-wrap w-100">
										<div class="cont-info-box text-center position-relative w-100 pat-bg white-layer opc95 back-blend-multiply bg-white" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">
											<span class="bg-color1">
												<i class="'.$item['list_icon'].' '.$item['list_fontAwesome'].'"></i>
											</span>
											<h4 class="mb-0">'.$item['list_title'].'</h4>';
											if(!empty($item['list_caption'])){
												$output .= '<p class="mb-0">'.$item['list_caption'].'</p>';
											}
											if(!empty($item['list_caption2'])){
												$output .= '<p class="mb-0">'.$item['list_caption2'].'</p>';
											}
											$output .= '
										</div>
									</div>
								</div>';
						}
					}
					$output .= '	
					
					</div>
				</div>
			</div>
		</div>
	</section>';
			
	echo $output;
  }
}
