<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class NamazClassTime extends Widget_Base{

  public function get_name(){
    return 'namaz-class-time';
  }

  public function get_title(){
    return 'Namaz & Class Time';
  }

  public function get_icon(){
    return 'fa fa-clock-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'tabligh' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'show_namaztime',
			[
				'label' => __( 'Show Namaz Time Section', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
		'namaz_bg_image',
			[
				'label' => __( 'Namaz Time Background Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/time-bg.jpg'
				],
			]
		);
		
		$this->add_control(
		  'namaz_heading',
		  [
			'label' => 'Element Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Go to Allah Before its to Late'
		  ]
		); 
		
		$this->add_control(
			'show_classtime',
			[
				'label' => __( 'Show Class Time Section', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
		'class_bg_image',
			[
				'label' => __( 'Class Background Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/course-bg.jpg'
				],
			]
		);
		 
		$this->add_control(
		  'class_heading',
		  [
			'label' => 'Class Section Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Islamic Classes & Courses'
		  ]
		); 
		
		$this->add_control(
		  'class_subheading',
		  [
			'label' => 'Class Section Sub Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Weekly Programs'
		  ]
		); 

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'class_title', [
				'label' => __( 'Class Title', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Tafseel ul Quran' , 'plugin-domain' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'class_caption', [
				'label' => __( 'Class Description', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Every Tuesday & Wednesday 8:00 am to 12:00 pm' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'class_link', [
				'label' => __( 'Class Link', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'class_icon', [
				'label' => __( 'Icon Class', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'flaticon-rub-el-hizb' , 'plugin-domain' ),
				'show_label' => true,
			]
		);
		

		$this->add_control(
			'list',
			[
				'label' => __( 'Class List', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'class_title' => __( 'Tafseel ul Quran', 'plugin-domain' ),
						'class_caption' => __( 'Every Tuesday & Wednesday 8:00 am to 12:00 pm', 'plugin-domain' ),
						'class_link' => __( '#', 'plugin-domain' ),
						'class_icon' => __( 'flaticon-rub-el-hizb', 'plugin-domain' ),
					],
					[
						'class_title' => __( 'Children Islamic Classes', 'plugin-domain' ),
						'class_caption' => __( 'Daily from 8:00 am to 1:00 pm', 'plugin-domain' ),
						'class_link' => __( '#', 'plugin-domain' ),
						'class_icon' => __( 'flaticon-rub-el-hizb', 'plugin-domain' ),
					],
					[
						'class_title' => __( 'Quran Recitation Class', 'plugin-domain' ),
						'class_caption' => __( 'Every Monday & Thursday 9:00 am to 11:30 pm', 'plugin-domain' ),
						'class_link' => __( '#', 'plugin-domain' ),
						'class_icon' => __( 'flaticon-rub-el-hizb', 'plugin-domain' ),
					],
	
				],
				'title_field' => '{{{ class_title }}}',
			]
		);
		
		

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display(); 
		
		/* Change Bootstrap Classes */
		if($settings['show_classtime'] != 'yes' || $settings['show_namaztime'] != 'yes'){
			$width_control = 'col-md-12 col-sm-12 col-lg-12'; /* Display It Full */
		}else{
			$width_control = 'col-md-12 col-sm-12 col-lg-6'; /* Display half half */
		}
		?>
		
		<section>
			<div class="w-100 position-relative">
				<div class="time-course-wrap w-100">
					<div class="row mrg">
					<?php if($settings['show_namaztime'] == 'yes'){ ?>
						<div class="<?php echo esc_html($width_control); ?>">
							<div class="time-wrap d-flex flex-wrap align-items-center justify-content-end thm-layer opc95 position-relative w-100">
								<?php if($settings['namaz_bg_image']['url']){ ?>
									<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['namaz_bg_image']['url']); ?>);"></div>
								<?php } ?>
								<div class="time-inner w-100">
									<div class="sec-title w-100">
										<div class="sec-title-inner d-inline-block">
											<?php if($settings['namaz_heading']){ ?>
												<h2 class="mb-0"><?php echo $settings['namaz_heading']; ?></h2>
											<?php } ?>
											
											<?php if(shortcode_exists('tabligh_hijri_date')){ ?>
												<p class="mb-0"> <?php echo do_shortcode('[tabligh_hijri_date]'); ?></p>
											<?php } ?>
										</div>
									</div><!-- Sec Title -->
									<div class="time-list-wrap d-flex flex-wrap w-100">
										<?php echo do_shortcode('[tabligh_salat_times_elementor]'); ?>
									</div>
								</div>
							</div><!-- Time Wrap -->
						</div>
					<?php } ?>  
					<?php if($settings['show_classtime'] == 'yes'){ ?>
						<div class="<?php echo esc_html($width_control); ?>">
							<div class="course-wrap d-flex flex-wrap align-items-center black-layer opc8 position-relative w-100">
								<?php if($settings['class_bg_image']['url']){ ?>
									<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['class_bg_image']['url']); ?>);"></div>
								<?php } ?>					
								<div class="course-inner w-100">
								<?php if($settings['class_heading'] || $settings['class_subheading']){ ?>
									<div class="sec-title w-100">
										<div class="sec-title-inner d-inline-block">
											<?php if($settings['class_heading']){ ?><h2 class="mb-0"><?php echo esc_html($settings['class_heading']); ?></h2><?php } ?>
											<?php if($settings['class_subheading']){ ?><p class="mb-0"><?php echo esc_html($settings['class_subheading']); ?></p><?php } ?>
										</div>
									</div>
								<?php } ?>
									
								<div class="course-list-wrap w-100">
									<?php if($settings['class_subheading']){ ?><h3 class="mb-0 thm-clr"><?php echo esc_html($settings['class_subheading']); ?></h3><?php } ?>
										<ul class="course-list mb-0 list-unstyled w-100">
										<?php
											if ( $settings['list'] ) {
										
												static $counter = 1;

												foreach (  $settings['list'] as $item ) { ?>
												   
													<li>
														<div class="course-box d-flex flex-wrap w-100">
															<i class="<?php echo $item['class_icon']; ?> thm-clr"></i>
															<div class="course-inner">
																<h4 class="mb-0"><a href="<?php echo $item['class_link']; ?>" title=""><?php echo $item['class_title']; ?></a></h4>
																<p class="mb-0"><?php echo $item['class_caption']; ?></p>
															</div>
														</div>
													</li>
													
													<?php
													
													$counter++;
												}
											}
										?>
										</ul>
									</div>
								</div>
							</div><!-- Courses Wrap -->
						</div>
					<?php } ?>
					</div>
				</div><!-- Time & Course Wrap -->
			</div>
		</section>
			
		<?php
	}
}