<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class NamazTimeGrid extends Widget_Base{

  public function get_name(){
    return 'namaz-time-grid';
  }

  public function get_title(){
    return 'Namaz Time Grid';
  }

  public function get_icon(){
    return 'fa fa-clock-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
		'content_section',
		[
			'label' => __( 'Content', 'tabligh' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
		);
		
		$this->add_control(
		  'namaz_heading',
		  [
			'label' => 'Element Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Go to Allah Before its to Late'
		  ]
		); 
		
		$this->add_control(
			'hijri_date',
			[
				'label' => __( 'Show Hijri Date', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
	
		
		$this->add_control(
			'dark_color',
			[
				'label' => __( 'Dark Color', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .time-list2 > li' => 'background-color: {{VALUE}}',
				],
				'default' => '#ededed',
			]
		);
		
		$this->add_control(
			'light_color',
			[
				'label' => __( 'Light Color', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .time-list2  li:nth-child(2n)' => 'background-color: {{VALUE}}',
				],
				'default' => '#f2f2f2',
			]
		);
		

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display(); ?>
		
		<style>
			.time-list2 > li {background-color:<?php echo $settings['light_color']; ?>}
			.time-list2 > li:nth-child(2n) {background-color:<?php echo $settings['dark_color']; ?>}
		</style>
		
		<section>
			<div class="w-100 position-relative">
				<div class="time-wrap2 w-100">
					<div class="row align-items-center">
						<div class="col-md-12 col-sm-12 col-lg-4">
							<div class="time-title w-100">
								<?php if($settings['namaz_heading']){ ?>
									<h4 class="mb-0"><?php echo $settings['namaz_heading']; ?></h4>
								<?php } 
								
								if($settings['hijri_date'] == 'yes' || $settings['hijri_date'] != 'yes'){
									if(shortcode_exists('tabligh_hijri_date')){ ?>
										<p class="mb-0 thm-clr"><?php echo do_shortcode('[tabligh_hijri_date]'); ?> </p>
									<?php 
									} 
								}?>
							</div>
						</div>
						<div class="col-md-12 col-sm-12 col-lg-8">
							<?php echo do_shortcode('[tabligh_salat_headers]'); ?>
						</div>
					</div>
				</div><!-- Time Wrap -->
			</div>
		</section>
			
		<?php
	}
}