<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class NamazTimeSimple extends Widget_Base{

  public function get_name(){
    return 'namaz-time-simple';
  }

  public function get_title(){
    return 'Namaz Time Simple';
  }

  public function get_icon(){
    return 'fa fa-clock-o';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
		'content_section',
		[
			'label' => __( 'Content', 'tabligh' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
		);
		
		$this->add_control(
		  'namaz_heading',
		  [
			'label' => 'Element Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Todays Prayer Times'
		  ]
		); 
		
		$this->add_control(
			'hijri_date',
			[
				'label' => __( 'Show Hijri Date', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
	
		
		$this->add_control(
			'dark_color',
			[
				'label' => __( 'Dark Color', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .time-list3 > li' => 'background-color: {{VALUE}}',
				],
				'default' => '#0a993c',
			]
		);
		
		$this->add_control(
			'light_color',
			[
				'label' => __( 'Light Color', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .time-list3  li:nth-child(2n)' => 'background-color: {{VALUE}}',
				],
				'default' => '#147736',
			]
		);
		

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display(); ?>
		
		<style>
			.time-list3 > li {background-color:<?php echo $settings['light_color']; ?>}
			.time-list3 > li:nth-child(2n) {background-color:<?php echo $settings['dark_color']; ?>}
		</style>
		
		<section>
			<div class="w-100 position-relative">
				<div class="container">
					<div class="time-wrap3 overlap245 overlap-60 position-relativ w-100">
						<?php if($settings['namaz_heading']){ ?>
						<div class="sec-title text-center w-100">
							<div class="sec-title-inner d-inline-block">
							<?php if($settings['namaz_heading']){ ?>
								<h2 class="mb-0 text-white"><?php echo $settings['namaz_heading']; ?></h2>
							<?php } 
							if($settings['hijri_date'] == 'yes' || $settings['hijri_date'] != 'yes'){ 
								if(shortcode_exists('tabligh_hijri_date')){ ?>
									<p class="mb-0 thm-clr"><?php echo do_shortcode('[tabligh_hijri_date]'); ?></p>
								<?php 
								} 
							}?>
							</div>
						</div><!-- Sec Title -->
						<?php } ?>
						<?php echo do_shortcode('[tabligh_salat_times]'); ?>
					</div><!-- Time Wrap -->
				</div>
			</div>
		</section>
		
		<?php
	}
}