<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Pillars extends Widget_Base{

  public function get_name(){
    return 'pillars';
  }

  public function get_title(){
    return 'Pillars';
  }

  public function get_icon(){
    return 'fa fa-flag';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'tabligh' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
		  'label_heading',
		  [
			'label' => 'Element Caption',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'The Pillars of Islam'
		  ]
		);

		$this->add_control(
		  'content_heading',
		  [
			'label' => 'Element Heading',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Duis aute irure dolor in reprehenit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
		  ]
		);

		$this->add_control(
			'heading_icon',
			[
			  'label' => 'Heading Icon',
			  'type' => \Elementor\Controls_Manager::TEXT,
			  'default' => 'flaticon-rub-el-hizb'
			]
		);

		$this->add_control(
		'bg_image',
			[
				'label' => __( 'Choose Background Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/parallax-bg1.jpg',
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Pillar Title', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Shahadah' , 'tabligh' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_caption', [
				'label' => __( 'Pillar Caption', 'tablighn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'FAITH' , 'tabligh' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'list_icon',
			[
				'label' => __( 'Pillar Icon', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'flaticon-quran-1',
				'options' => [
					'flaticon-quran-1' => __( 'Shahadah', 'tabligh' ),
					'flaticon-mosque-1' => __( 'Salah', 'tabligh' ),
					'flaticon-star'  => __( 'Sawm', 'tabligh' ),
					'flaticon-gift-box' => __( 'Zakat', 'tabligh' ),
					'flaticon-kaaba' => __( 'Hajj', 'tabligh' ),
				],
			]
		);
		
		$repeater->add_control(
			'list_custom_icon',
			[
				'label' => __( 'Other Icon', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'far fa-envelope',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[			
						'list_title' => __( 'Shahadah', 'tabligh' ),
						'list_caption' => __( 'FAITH', 'tabligh' ),
						'list_icon' => __( 'flaticon-quran-1', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Salah', 'tabligh' ),
						'list_caption' => __( 'PRAYER', 'tabligh' ),
						'list_icon' => __( 'flaticon-mosque-1', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Sawm', 'tabligh' ),
						'list_caption' => __( 'FASTING', 'tabligh' ),
						'list_icon' => __( 'flaticon-star', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Zakat', 'tabligh' ),
						'list_caption' => __( 'ALMSGIVING', 'tabligh' ),
						'list_icon' => __( 'flaticon-gift-box', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Hajj', 'tabligh' ),
						'list_caption' => __( 'PILGRIMAGE', 'tabligh' ),
						'list_icon' => __( 'flaticon-kaaba', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
	
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

	}
  

	protected function render() {
		$settings = $this->get_settings_for_display();
		
			$output = '
			<section>
                <div class="w-100 pt-110 black-layer pb-70 opc8 position-relative">';
                    if(!empty($settings['bg_image']['url'])){ $output .= '<div class="fixed-bg" style="background-image: url('.esc_url($settings['bg_image']['url']).');"></div>'; }
                    $output .= '
					<div class="container">';
					if(!empty($settings['label_heading']) || !empty($settings['content_heading'])){
						$output .= '
							<div class="sec-title v2 text-center w-100">
								<div class="sec-title-inner d-inline-block">';
								if($settings['heading_icon']){ $output .= '<i class="'.$settings['heading_icon'].' thm-clr"></i>'; }
								if($settings['label_heading']){ $output .= '<h1 class="mb-0">'.$settings['label_heading'].'</h1>'; }
								if($settings['content_heading']){ $output .= '<p class="mb-0">'.$settings['content_heading'].'</p>'; }
								$output .= '
								</div>
							</div>';
					}
					$output .= '
                        <div class="pillars-wrap w-100">
                            <ul class="pillars-list text-center d-flex flex-wrap justify-content-center align-items-center mb-0 list-unstyled">';
							if ( $settings['list'] ) {

								static $counter = 1;

								foreach (  $settings['list'] as $item ) {
								
								$output .= '
									
                                <li>
                                    <div class="pillar-box position-relative w-100">
                                        <span class="d-inline-block thm-clr position-relative">
											<span class="pat-bg gray-layer opc85 position-absolute back-blend-multiply gray-bg" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">
											</span>';
											if(!empty($item['list_icon'])){
												$icon_html = '<i class="'.$item['list_icon'].'"></i>';
											}else{
												if(empty($item['list_icon'])){
													$icon_html = '<i class="'.$item['list_custom_icon'].'"></i>';
												}else{
													$icon_html = '';
												}
											}
											$output .= $icon_html;
											$output .= '
										</span>';
                                        if(!empty($item['list_title'])){ $output .= '<h3 class="mb-0">'.$item['list_title'].'</h3>'; }
                                        if(!empty($item['list_caption'])){ $output .= '<i class="d-block thm-clr">'.$item['list_caption'].'</i>'; }
										$output .= '
                                    </div>
                                </li>';
								}
							}
                            $output .= '
                            </ul>
                        </div><!-- Pillars Wrap -->
                    </div>
                </div>
            </section>';

			echo $output;
		
	}
}
