<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class PillarsQuote extends Widget_Base{

  public function get_name(){
    return 'pillars_quote';
  }

  public function get_title(){
    return 'Pillars + Quote';
  }

  public function get_icon(){
    return 'fa fa-flag';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'tabligh' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
		  'label_heading',
		  [
			'label' => 'Element Caption',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'The Pillars of Islam'
		  ]
		);

		$this->add_control(
		  'content_heading',
		  [
			'label' => 'Element Heading',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Duis aute irure dolor in reprehenit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
		  ]
		);

		$this->add_control(
			'heading_icon',
			[
			  'label' => 'Heading Icon',
			  'type' => \Elementor\Controls_Manager::TEXT,
			  'default' => 'flaticon-rub-el-hizb'
			]
		);

		$this->add_control(
		'bg_image',
			[
				'label' => __( 'Choose Background Image', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/sec-bg2.jpg',
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Pillar Title', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Shahadah' , 'tabligh' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_caption', [
				'label' => __( 'Pillar Caption', 'tablighn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'FAITH' , 'tabligh' ),
				'show_label' => true,
			]
		);
		
		$repeater->add_control(
			'list_icon',
			[
				'label' => __( 'Pillar Icon', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'flaticon-quran-1',
				'options' => [
					'flaticon-quran-1' => __( 'Shahadah', 'tabligh' ),
					'flaticon-mosque-1' => __( 'Salah', 'tabligh' ),
					'flaticon-star'  => __( 'Sawm', 'tabligh' ),
					'flaticon-gift-box' => __( 'Zakat', 'tabligh' ),
					'flaticon-kaaba' => __( 'Hajj', 'tabligh' ),
				],
			]
		);
		
		$repeater->add_control(
			'list_custom_icon',
			[
				'label' => __( 'Other Icon', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'far fa-envelope',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[			
						'list_title' => __( 'Shahadah', 'tabligh' ),
						'list_caption' => __( 'FAITH', 'tabligh' ),
						'list_icon' => __( 'flaticon-quran-1', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Salah', 'tabligh' ),
						'list_caption' => __( 'PRAYER', 'tabligh' ),
						'list_icon' => __( 'flaticon-mosque-1', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Sawm', 'tabligh' ),
						'list_caption' => __( 'FASTING', 'tabligh' ),
						'list_icon' => __( 'flaticon-star', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Zakat', 'tabligh' ),
						'list_caption' => __( 'ALMSGIVING', 'tabligh' ),
						'list_icon' => __( 'flaticon-gift-box', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
					[
						'list_title' => __( 'Hajj', 'tabligh' ),
						'list_caption' => __( 'PILGRIMAGE', 'tabligh' ),
						'list_icon' => __( 'flaticon-kaaba', 'tabligh' ),
						'list_custom_icon' => __( '', 'tabligh' ),
					],
	
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn More'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	
	
	$this->add_control(
		'msg_quote',
		[
			'label' => __( 'Welcome Quote', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'rows' => 5,
			'default' => __( 'The saying fruitful were let for him all fruitful morning. Second may waters set was were there upon his he winged won’t itself there very first under seasons.', 'tabligh' ),
			'placeholder' => __( 'The saying fruitful were let for him all fruitful morning. Second may waters set was were there upon his he winged won’t itself there very first under seasons.', 'tabligh' ),
		]
	);
	
	$this->add_control(
      'quote_author',
      [
        'label' => 'Quote Author',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Muhammad Al-Bukhari'
      ]
    );
	
	$this->add_control(
      'quote_referrence',
      [
        'label' => 'Quote Referrence',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '(d. 256 AH/870 AD)'
      ]
    );
	
	$this->add_control(
		'cover_image',[
			'label' => __( 'Quote Background Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/quote-sec-bg.jpg',
			],
		]
	);


		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
		$output = '
		
			<section>
				<div class="w-100 black-layer opc1 position-relative">';
					if($settings['bg_image']['url']){ 
						$output .= '<div class="fixed-bg" style="background-image: url('.esc_url($settings['bg_image']['url']).');"></div>';
					}
					$output .= '
					<div class="quote-pillars-wrap w-100">
						<div class="row mrg">
							<div class="col-md-12 col-sm-12 col-lg-5">
								<div class="quote-wrap d-flex align-items-end justify-content-end position-relative w-100">';
									if($settings['cover_image']['url']){ 
										$output .= '<div class="fixed-bg" style="background-image: url('.$settings['cover_image']['url'].');"></div>'; 
									}
									if($settings['msg_quote'] || $settings['quote_author'] || $settings['quote_referrence']){
										$output .= '
											<div class="quote-box position-relative thm-layer opc5 w-100">
												<div class="fixed-bg patern-bg back-blend-multiply thm-bg" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);"></div>';
												
												if($settings['msg_quote']){
													$output .= '<p class="mb-0">'.$settings['msg_quote'].'</p>'; 
												}
												if($settings['quote_author']){ 
													$output .= '<h4 class="mb-0">'.$settings['quote_author'].'</h4>'; 
												}
												if($settings['quote_referrence']){ 
													$output .= '<span class="d-block">'.$settings['quote_referrence'].'</span>'; 
												}
												$output .= '
											</div>';
									}
									$output .= '
								</div>
							</div>
							<div class="col-md-12 col-sm-12 col-lg-7">
								<div class="pillars-wrap2 w-100">';
								if($settings['heading_icon'] || $settings['label_heading'] || $settings['content_heading']){ 
									$output .= '	
										<div class="sec-title v2 left-icon w-100">
											<div class="sec-title-inner d-inline-block">';
											if($settings['heading_icon']){
												$output .= '<i class="'.$settings['heading_icon'].' thm-clr"></i>';
											}
											if($settings['label_heading']){
												$output .= '<h2 class="mb-0">'.$settings['label_heading'].'</h2>';
											}
											if($settings['content_heading']){
												$output .= '<p class="mb-0">'.$settings['content_heading'].'</p>';
											}
											$output .= '
											</div>
										</div>';
								}
								$output .= '
									<ul class="pillars-list2 d-flex flex-wrap mb-0 list-unstyled">';
										
										if ( $settings['list'] ) {

											static $counter = 1;

											foreach (  $settings['list'] as $item ) {
											
											$output .= '
										
											<li>
												<div class="pillar-box2 position-relative w-100">
													<span class="d-inline-block thm-clr">';
													if(!empty($item['list_icon'])){
														$icon_html = '<i class="'.$item['list_icon'].'"></i>';
													}else{
														if(empty($item['list_icon'])){
															$icon_html = '<i class="'.$item['list_custom_icon'].'"></i>';
														}else{
															$icon_html = '';
														}
													}
													$output .= $icon_html.'
													</span>
													<h3 class="mb-0">'.$item['list_title'].'</h3>
													<i class="d-block thm-clr">'.$item['list_caption'].'</i>
												</div>
											</li>';
											}
										}

										if($settings['button_text']){ 
											$output .= '
												<li>
													<div class="pillar-btn">
														<a class="thm-btn thm-bg" href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<span></span><span></span><span></span><span></span></a>
													</div>
												</li>';
										}
										$output .= '
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>';
		
			echo $output;
		
	}
}
