<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ProductsSlider extends Widget_Base{

  public function get_name(){
    return 'products_Slider';
  }

  public function get_title(){
    return 'Products Slider';
  }

  public function get_icon(){
    return 'fa fa-shopping-cart';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'product',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'product_cat',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Dont Miss Special Packages'
      ]
    ); 

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'order_now_btn',
      [
        'label' => 'Add Link for Order Now',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#'
      ]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('product', 'product_cat', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);
	
	wp_enqueue_style('slick-slider',get_template_directory_uri().'/assets/css/slick.css');
	wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'touchspin-woo', get_template_directory_uri() . '/assets/js/jquery-touchspin.min.js', array('jquery'), '1.0.0', true );
	
	$output = '
	
	<section>
		<div class="w-100 pt-90 gray-layer opc85 position-relative">
			<div class="fixed-bg patern-bg back-blend-multiply gray-bg" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);"></div>
			<div class="container">';
				if(!empty($settings['content_caption']) || !empty($settings['content_heading'])){ 
				
				$output .= '
					<div class="sec-title text-center w-100">
						<div class="sec-title-inner d-inline-block">';
							if($settings['heading_icon']){ $output .= '<i class="'.$settings['heading_icon'].' thm-clr"></i>'; }
							if($settings['content_heading']){ $output .= '<h2 class="mb-0">'.$settings['content_heading'].'</h2>'; }
							if($settings['content_caption']){ $output .= '<p class="mb-0">'.$settings['content_caption'].'</p>'; }
							$output .= '
						</div>
					</div>';
				}
				$output .= '
				<div class="prod-wrap overlap-150 prod-caro w-100">';
						
						if(have_posts()){
						
							while( have_posts() ){ the_post(); global $post;

								global $post,$product,$product_url,$woocommerce;
								
									$regular_price = get_post_meta($post->ID, '_regular_price', true);
									if($regular_price == ''){
										$regular_price = get_post_meta($post->ID, '_max_variation_regular_price', true);
									}
									$sale_price = get_post_meta($post->ID, '_sale_price', true);
									$sku_num = get_post_meta($post->ID, '_sku', true);
										
									if($sale_price == ''){
										$sale_price = get_post_meta($post->ID, '_min_variation_sale_price', true);
									}
									$currency = get_woocommerce_currency_symbol();
									
									$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 585, 590, 'bfi_thumb' => true ));
									
									$product = wc_get_product( $post->ID );
									
									$company = get_post_meta( get_the_ID(), 'product_company_name', true );
									
									$output .= '
									<div class="prod-box d-block w-100 woocommerce">
										<div class="row mrg">
											<div class="col-md-12 col-sm-12 col-lg-6">
												<div class="prod-img overflow-hidden position-relative w-100">
													<a target = "_blank" href="'.$settings['order_now_btn'].'" title=""><img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Image','tabligh').'"></a>
												</div>
											</div>
											<div class="col-md-12 col-sm-12 col-lg-6">
												<div class="prod-info w-100">';
												
													if($regular_price > 0){ 
														$output .= '<span class="price pat-bg thm-layer opc7 back-blend-multiply thm-bg position-absolute" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">'.$currency.''.$regular_price.'</span>';
													}
													$output .= '
													<span class="prod-publish d-block">'.$company.' <span class="thm-clr">('.$sku_num.')</span></span>
													<h3 class="mb-0"><a target = "_blank" href="'.$settings['order_now_btn'].'" title="">'.get_the_title().'</a></h3>
													<div class="rate-wrap d-block">'.add_stars_to_review_tab(get_the_title()).'<i>'.$product->get_rating_count().' '.esc_html__('Ratings','tabligh').'</i></div>
													<p class="mb-0">'.wp_trim_words( get_the_content(), 25, '...' ).'</p>
													<div class="qty-wrap">
														<input class="qty" type="text" value="50">
													</div>
													<a target = "_blank" href="'.$settings['order_now_btn'].'" title="">'.esc_html__('Order Now','tabligh').'</a>
												</div>
											</div>
										</div>
									</div>';
								}
							}
						$output .= '
				</div><!-- Products Wrap -->
			</div>
		</div>
	</section>';
	
	echo $output;
  }
}
