<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Scholars extends Widget_Base{

  public function get_name(){
    return 'scholars';
  }

  public function get_title(){
    return 'Scholars';
  }

  public function get_icon(){
    return 'fa fa-user-';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'team',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'team-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'display_pattern',
		[
			'label' => __( 'Display Pattern Background', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'your-plugin' ),
			'label_off' => __( 'Hide', 'your-plugin' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]
	);
	
	$this->add_control(
		'display_designation',
		[
			'label' => __( 'Display Designation', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'your-plugin' ),
			'label_off' => __( 'Hide', 'your-plugin' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]
	);

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Islamic Scholars'
      ]
    ); 

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Team Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 32,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More Scholars'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );

	
	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('team', 'team-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';
	
	if($settings['display_pattern'] == 'yes'){ $color_class = "gray-layer"; }else{  $color_class = ""; }
	if(!empty($settings['content_caption']) || !empty($settings['content_heading'])){ $padding_class = 'w-100 pt-100'; }else { $padding_class = 'w-100 pt-100 pb-100 position-relative'; }
	
	$output = '
	
	<section>
		<div class="'.$padding_class.'  '.$color_class.' pb-60 opc85 position-relative">';
		if($settings['display_pattern'] == 'yes'){ 
			$output .= '<div class="fixed-bg patern-bg back-blend-multiply gray-bg" style="'.tabligh_background('pattern-bg.jpg').'"></div>';
		}
		$output .= '
			<div class="container">';
			if(!empty($settings['content_caption']) || !empty($settings['content_heading'])){ 
				$output .= '
					<div class="sec-title text-center w-100">
						<div class="sec-title-inner d-inline-block">';
							if($settings['heading_icon']){ $output .= '<i class="thm-clr '.$settings['heading_icon'].'"></i>'; }
							if($settings['content_heading']){ $output .= '<h2 class="mb-0">'.$settings['content_heading'].'</h2>'; }
							if($settings['content_caption']){ $output .= '<p class="mb-0">'.$settings['content_caption'].'</p>'; }
							$output .= '
						</div>
					</div>';
			}
			$output .= '
				<div class="team-wrap res-row wide-sec2">
					<div class="row">';
					if ( have_posts() ) {
									
						static $counter = 1;
						
						while ( have_posts() ) { the_post(); global $post;
						
							$team_designation = ''; $team_facebook = ''; $team_linkedin = ''; $team_twitter = '';
							$team_designation = get_post_meta( get_the_ID(), 'team_designation', true );
							$team_facebook = get_post_meta( get_the_ID(), 'team_facebook', true );
							$team_linkedin = get_post_meta( get_the_ID(), 'team_linkedin', true );
							$team_twitter = get_post_meta( get_the_ID(), 'team_twitter', true );
							
							$output .= '
								<div class="col-md-6 col-sm-6 col-lg-3">
									<div class="team-box text-center w-100">
										<div class="team-img overflow-hidden position-relative w-100">
											<a href="'.get_the_permalink().'">'.get_the_post_thumbnail($post->ID, array( 310, 310, 'bfi_thumb' => true )).'</a>';
											if($team_facebook || $team_twitter || $team_linkedin){
												$output .= '
													<div class="social-links2 text-center d-inline-flex position-absolute">';
														if($team_facebook){ $output .= '<a class="facebook" href="'.$team_facebook.'" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>'; }
														if($team_twitter){ $output .= '<a class="twitter" href="'.$team_twitter.'" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a>'; }
														if($team_linkedin){ $output .= '<a class="youtube" href="'.$team_linkedin.'" title="Youtube" target="_blank"><i class="fab fa-linkedin-in"></i></a>'; }
														$output .= '
													</div>';
											}
											$output .= '
										</div>
										<div class="team-info">
											<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>';
											if($team_designation && $settings['display_designation'] == 'yes'){ 
												$output .= '<span class="d-block thm-clr">'.$team_designation.'</span>'; 
											}
											$output .= '
										</div>
									</div>
								</div>';
							
							$counter++;
										
						}
					} 
								
					$output .= '
		
					</div>
				</div>';
				
				if($settings['button_text']){
				
					$output .= '
						<div class="view-more mt-05 d-inline-block text-center w-100">
							<a class="thm-btn thm-bg" '.$btarget.' href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<span></span><span></span><span></span><span></span></a>
						</div>';
				}
				
				/* 1 2 3 Pagination */
				if($settings['display_pagination'] == 'Yes' && function_exists('tabligh_numeric_posts_nav')){
				
					$output .= '
							<div class="pagination-wrap d-flex flex-wrap justify-content-center text-center w-100">
								<ul class="pagination mb-0">
									'.tabligh_numeric_posts_nav().'
								</ul>
							</div>';
				}else{
					
					/* Yet To Be Implemented */
				
				} wp_reset_query();
				
				$output .= '
			</div>
		</div>
	</section>';
						
	
	echo $output;
  }
}