<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ServicesBlocks extends Widget_Base{

  public function get_name(){
    return 'services_blocks';
  }

  public function get_title(){
    return 'Services Blocks';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'services',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'services-cat',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'tabligh' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Services We Offer'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'tabligh' ),
				'title' => __( 'Title', 'tabligh' ),
				'name' => __( 'Name', 'tabligh' ),
				'rand' => __( 'Random', 'tabligh' ),
				'ID' => __( 'ID', 'tabligh' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'tabligh' ),
				'ASC' => __( 'ASCENDING', 'tabligh' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );

	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'tabligh' ),
				'Yes' => __( 'Yes', 'tabligh' ),
			],
		]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = tabligh_get_post_query('services', 'services-cat', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);  
	
	if($settings['content_heading'] || $settings['content_caption']){ $space_class = "pb-80"; }else{ $space_class = "pt-100 pb-100"; }
	
	?>
	  
	<section>
		<div class="w-100 <?php echo $space_class; ?> position-relative">
			<div class="container">
				<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
					<div class="sec-title text-center w-100">
						<div class="sec-title-inner d-inline-block">
						<?php if($settings['heading_icon']){ ?>  
							<i class="thm-clr <?php echo $settings['heading_icon']; ?>"></i>
						<?php } ?>
						<?php if($settings['content_heading']){ ?> 	
							<h2 class="mb-0"><?php echo $settings['content_heading']; ?></h2>
						<?php } ?>
						<?php if($settings['content_caption']){ ?> 	
							<p class="mb-0"><?php echo $settings['content_caption']; ?></p>
						<?php } ?>
						</div>
					</div>
				<?php } ?>

				<div class="serv-wrap wide-sec">
					<div class="row mrg10">
					<?php
					if ( have_posts() ) {
						
						while ( have_posts() ) { the_post(); global $post;
		
							static $counter = 1; 
							
							$service_icon = '';
							$service_icon = get_post_meta( get_the_ID(), 'service_icon', true ); ?>
							
							<div class="col-md-6 col-sm-6 col-lg-3">
								<div class="serv-box text-center pat-bg gray-layer opc85 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
									<?php if($service_icon){ ?> <i class="<?php echo esc_html($service_icon); ?> thm-clr"></i> <?php } ?>
									<h3 class="mb-0"><?php echo get_the_title();?></h3>
									<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $settings['words_count'], '...' ); ?></p>
									<a href="<?php echo get_the_permalink(); ?>" title=""><?php esc_html_e('Read More','tabligh');?></a>
								</div>
							</div>
						<?php $counter++;
						}
					} ?>
					</div>
				</div><!-- Services Wrap -->
				<?php if($settings['display_pagination'] == 'Yes'){ ?>
					<div class="pagination-wrap mt-50 d-flex flex-wrap justify-content-center text-center w-100">
						<ul class="pagination mb-0">
							<?php echo tabligh_numeric_posts_nav(); ?>
						</ul>
					</div>
				<?php }
				wp_reset_query(); ?>
			</div>
		</div>
	</section>
    <?php
  }
}