<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class SignUpForm extends Widget_Base{

  public function get_name(){
    return 'signupform';
  }

  public function get_title(){
    return 'Sign Up Form';
  }

  public function get_icon(){
    return 'fa fa-exclamation-circle';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn Quran With Us'
      ]
    );

    $this->add_control(
		'item_description',
		[
			'label' => __( 'Description', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'default' => __( 'Default description', 'plugin-domain' ),
			'placeholder' => __( 'Type your description here', 'plugin-domain' ),
		]
	);
	
	$this->add_control(
      'form_shortcode',
      [
        'label' => 'Contact Form 7 Shortcode',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => ''
      ]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    
	$settings = $this->get_settings_for_display(); ?>

	<section>
		<div class="w-100 pt-90 thm-layer pb-100 opc65 position-relative">
			<div class="fixed-bg patern-bg back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg';?>);"></div>
			<div class="container">
				<div class="get-started-wrap text-center w-100">
					<div class="get-started-inner d-inline-block">
						<div class="get-started-title w-100">
              <?php if($settings['element_title']){ ?><h2 class="mb-0"><?php echo $settings['element_title'];?></h2><?php } ?>
							<?php if($settings['item_description']){ echo wpautop($settings['item_description']); } ?>
						</div>
						<div class="w-100">
							<div class="row mrg10">
                <?php if($settings['form_shortcode']){ echo do_shortcode($settings['form_shortcode']); } ?>
							</div>
						</div>
					</div>
				</div><!-- Get Started Wrap -->
			</div>
		</div>
	</section>
    <?php
  }
}
