<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class VideoWelcomeMessage extends Widget_Base{

  public function get_name(){
    return 'video_welcome_message';
  }

  public function get_title(){
    return 'Video Welcome Message';
  }

  public function get_icon(){
    return 'fa fa-file-text';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'KNOW THE REAL HISTORY OF ISLAM'
      ]
    );
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'ETHICAL & MORAL BELIEFS THAT GUIDES'
      ]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn More'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );

    $this->add_control(
		'main_image',
		[
			'label' => __( 'Choose Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/bism-img1.png',
			],
		]
	);
	
	$this->add_control(
		'item_description',
		[
			'label' => __( 'Description', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'rows' => 10,
			'default' => __( 'The is not just a mosque for prayers rather it is a community center for all. The Center is committed to preserving an Islamic identity, building and supporting a viable Muslim community, promoting a comprehensive Islamic way of life based on the Holy Quran and the Sunnah of Prophet Muhammad.', 'tabligh' ),
			'placeholder' => __( 'The is not just a mosque for prayers rather it is a community center for all. The Center is committed to preserving an Islamic identity, building and supporting a viable Muslim community, promoting a comprehensive Islamic way of life based on the Holy Quran and the Sunnah of Prophet Muhammad.', 'tabligh' ),
		]
	);
	
	$this->add_control(
		'show_video_section',
		[
			'label' => __( 'Show Video Section', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'your-plugin' ),
			'label_off' => __( 'Hide', 'your-plugin' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]
	);
	
	
	$this->add_control(
		'video_bg',
		[
			'label' => __( 'Choose Video Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/video-img.jpg',
			],
		]
	);
	
	$this->add_control(
      'video_url',
      [
        'label' => 'Video URL',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'https://www.youtube.com/embed/WxuHBTES2-s'
      ]
    );
	
	$this->add_control(
		'welcome_quote',
		[
			'label' => __( 'Welcome Quote', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'rows' => 5,
			'default' => __( 'The saying fruitful were let for him all fruitful morning. Second may waters set was were there upon his he winged won’t itself there very first under seasons.', 'tabligh' ),
			'placeholder' => __( 'The saying fruitful were let for him all fruitful morning. Second may waters set was were there upon his he winged won’t itself there very first under seasons.', 'tabligh' ),
		]
	);
	
	$this->add_control(
      'quote_author',
      [
        'label' => 'Quote Author',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Muhammad Al-Bukhari'
      ]
    );
	
	$this->add_control(
      'quote_referrence',
      [
        'label' => 'Quote Referrence',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '(d. 256 AH/870 AD)'
      ]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();

	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : ''; ?>
	
	<section>
		<div class="w-100 pt-155 pb-90 position-relative">
			<img class="img-fluid sec-top-mckp position-absolute" src="<?php echo get_template_directory_uri().'/assets/images/sec-top-mckp.png'; ?>" alt="<?php esc_attr__('Background','tabligh'); ?>">
			<div class="container">
				<div class="about-wrap2 w-100">
					<div class="row">
						<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
							<div class="col-md-6 col-sm-12 col-lg-5">
								<div class="about-title w-100">
									<?php if($settings['content_heading']){ ?>
										<h2 class="mb-0"><?php echo $settings['content_heading']; ?></h2>
									<?php } ?>
									<?php if($settings['content_caption']){ ?>
										<p class="mb-0 thm-clr"><?php echo $settings['content_caption']; ?></p>
									<?php } ?>
									<?php if($settings['button_text']){ ?>
										<a class="thm-btn bg-color1" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a>
									<?php } ?>
								</div>
							</div>
						<?php
						} ?>
						
						<div class="col-md-6 col-sm-12 col-lg-7">
							<div class="about-inner2 w-100">
								<?php if($settings['main_image']['url']){ ?> 
									<img class="img-fluid" src="<?php echo $settings['main_image']['url']; ?>" alt="<?php esc_attr__('Background','tabligh'); ?>">
								<?php }
								if($settings['item_description']){ ?> 
									<?php echo wpautop($settings['item_description']); 
								} ?>
							</div>
						</div>

					</div>
				</div><!-- About Wrap 2 -->
				<?php if($settings['show_video_section'] == 'yes'){ ?>
					<div class="video-quote-wrap mt-100 w-100 position-relative">
						<div class="video-box w-100 position-relative">
							<?php if($settings['video_bg']['url']){ ?>
								<img class="img-fluid w-100" src="<?php echo esc_url($settings['video_bg']['url']); ?>" alt="<?php esc_attr__('Video Image','tabligh'); ?>">
							<?php } ?>
							<?php if($settings['video_url']){ ?>
								<a class="position-absolute spinner bg-color1" href="<?php echo $settings['video_url']; ?>" data-fancybox title=""><i class="fas fa-play"></i></a>
							<?php } ?>
						</div>
						<div class="quote-box position-absolute pat-bg thm-layer opc65 back-blend-multiply thm-bg" style="background-image: url(<?php echo get_template_directory_uri().'/assets/images/pattern-bg.jpg'; ?>);">
							<?php if($settings['welcome_quote']){ echo wpautop($settings['welcome_quote']);  } ?>
							<?php if($settings['quote_author']){?> <h4 class="mb-0"><?php echo $settings['quote_author']; ?></h4><?php } ?>
							<?php if($settings['quote_referrence']){ ?> <span class="d-block"><?php echo $settings['quote_referrence']; ?></span><?php } ?>
						</div>
					</div><!-- Video Quote Wrap -->
				<?php } ?>
			</div>
		</div>
	</section>
	
    <?php
  }
}