<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class WelcomeMessage extends Widget_Base{

  public function get_name(){
    return 'welcome_message';
  }

  public function get_title(){
    return 'Welcome Message';
  }

  public function get_icon(){
    return 'fa fa-file-text';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	$this->add_control(
		'main_image',
		[
			'label' => __( 'Choose Image', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/bism-img1.png',
			],
		]
	);

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Welcome To The Islam Home'
      ]
    );
	
	$this->add_control(
		'item_description',
		[
			'label' => __( 'Description', 'tabligh' ),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'rows' => 10,
			'default' => __( 'The is not just a mosque for prayers rather it is a community center for all. The Center is committed to preserving an Islamic identity, building and supporting a viable Muslim community, promoting a comprehensive Islamic way of life based on the Holy Quran and the Sunnah of Prophet Muhammad.', 'tabligh' ),
			'placeholder' => __( 'The is not just a mosque for prayers rather it is a community center for all. The Center is committed to preserving an Islamic identity, building and supporting a viable Muslim community, promoting a comprehensive Islamic way of life based on the Holy Quran and the Sunnah of Prophet Muhammad.', 'tabligh' ),
		]
	);
	
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn More'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'tabligh' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'tabligh' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : ''; ?>

	<section>
		<div class="w-100 pt-220 pb-80 position-relative">
			<img class="img-fluid sec-top-mckp position-absolute" src="<?php echo get_template_directory_uri().'/assets/images/sec-top-mckp.png'; ?>" alt="<?php esc_attr__('Background','tabligh'); ?>">
			<div class="container">
				<div class="about-wrap text-center position-relative w-100">
					<div class="about-inner d-inline-block">
						<?php if($settings['main_image']['url']){ ?><img class="img-fluid" src="<?php echo $settings['main_image']['url'];?>" alt="<?php esc_attr__('Background','tabligh'); ?>"><?php } ?>
						<?php if($settings['content_heading']){ ?><h2 class="mb-0"><?php echo $settings['content_heading']; ?></h2><?php } ?>
						<?php if($settings['item_description']){ ?><p class="mb-0"><?php echo $settings['item_description']; ?></p><?php } ?>
						<?php if($settings['button_text']){ ?><a <?php echo $btarget; ?> class="thm-btn thm-bg" href="<?php echo $settings['button_url']['url']; ?>" title=""><?php echo $settings['button_text']; ?><span></span><span></span><span></span><span></span></a><?php } ?>
					</div>
				</div><!-- About Wrap -->
			</div>
		</div>
	</section>
	
    <?php
  }
}