<?php /* Page Meta */

/* Add Page Meta Boxes */
	add_action( 'cmb2_admin_init', 'tabligh_page_posttype_metaboxes' );

	function tabligh_page_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'page_metabox',
			'title'         => __( 'Page Options', 'tabligh' ),
			'object_types'  => array( 'page', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		/* Secondary Header */
		$cmb->add_field( array(
			'name'    => 'Secondary Header',
			'id'      => 'secondary_header',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
		
		/* Main Header Style */
		$cmb->add_field( array(
			'name'             => 'Header Style',
			'desc'             => 'Select Page Header Style',
			'id'               => 'page_header_style',
			'type'             => 'select',
			'show_option_none' => false,
			'default'          => 'header1',
			'options'          => array(
				'header1' => __( 'Header 1', 'tabligh' ),
				'header2'   => __( 'Header 2', 'tabligh' ),
				'header3'     => __( 'Header 3', 'tabligh' ),
			),
		) );
		
		/* Main Footer Style */
		$cmb->add_field( array(
			'name'             => 'Footer Style',
			'desc'             => 'Select Page Footer Style',
			'id'               => 'page_footer_style',
			'type'             => 'select',
			'show_option_none' => false,
			'default'          => 'footer1',
			'options'          => array(
				'footer1' => __( 'Footer 1', 'tabligh' ),
				'footer2'   => __( 'Footer 2', 'tabligh' ),
				'footer3'     => __( 'Footer 3', 'tabligh' ),
			),
		) );

		$cmb->add_field( array(
			'name'    => 'Change THIS Page Color',
			'id'      => 'page_color_seperate',
			'type'    => 'colorpicker',
			'default' => '#0A993C',
			 'options' => array(
			 	'alpha' => true, // Make this a rgba color picker.
			 ),
		) );
	} /* Meta boxes Ends Here */