<?php
/***** Required Functions For Courses Post Type *****/
if ( ! function_exists('prefix_post_type_courses') ) {

	/* 1. Register CLASSES Post Type */
	function prefix_post_type_courses() {

		$labels = array(
			'name'                  => _x( 'Courses', 'Post Type General Name', 'tabligh' ),
			'singular_name'         => _x( 'Course', 'Post Type Singular Name', 'tabligh' ),
			'menu_name'             => __( 'Courses', 'tabligh' ),
			'name_admin_bar'        => __( 'Courses', 'tabligh' ),
			'archives'              => __( 'Course Archives', 'tabligh' ),
			'attributes'            => __( 'Course Attributes', 'tabligh' ),
			'parent_item_colon'     => __( 'Parent Team:', 'tabligh' ),
			'all_items'             => __( 'All Team', 'tabligh' ),
			'add_new_item'          => __( 'Add New Course', 'tabligh' ),
			'add_new'               => __( 'Add New Course', 'tabligh' ),
			'new_item'              => __( 'Add New Course', 'tabligh' ),
			'edit_item'             => __( 'Edit Course', 'tabligh' ),
			'update_item'           => __( 'Update Course', 'tabligh' ),
			'view_item'             => __( 'View Course', 'tabligh' ),
			'view_items'            => __( 'View Course', 'tabligh' ),
			'search_items'          => __( 'Search Course', 'tabligh' ),
			'not_found'             => __( 'Not found', 'tabligh' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'tabligh' ),
			'featured_image'        => __( 'Team Featured Image', 'tabligh' ),
			'set_featured_image'    => __( 'Set featured image', 'tabligh' ),
			'remove_featured_image' => __( 'Remove featured image', 'tabligh' ),
			'use_featured_image'    => __( 'Use as featured image', 'tabligh' ),
			'insert_into_item'      => __( 'Insert into Course', 'tabligh' ),
			'uploaded_to_this_item' => __( 'Uploaded to this Course', 'tabligh' ),
			'items_list'            => __( 'Courses list', 'tabligh' ),
			'items_list_navigation' => __( 'Courses list navigation', 'tabligh' ),
			'filter_items_list'     => __( 'Filter Course list', 'tabligh' ),
		);
		$args = array(
			'label'                 => __( 'Courses', 'tabligh' ),
			'description'           => __( 'Courses Post Type Generated By Ingeniofy Plugin', 'tabligh' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'comments'),
			'hierarchical'          => true,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 20,
			'menu_icon'             => 'dashicons-id-alt',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'course',
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'courses', $args );
		
		/* Add new taxonomy, make it hierarchical (like categories) */
		$cat_labels = array(
			'name'              => _x( 'Course Categories', 'taxonomy general name', 'tabligh' ),
			'singular_name'     => _x( 'Course Category', 'taxonomy singular name', 'tabligh' ),
			'search_items'      => __( 'Search Course Category', 'tabligh' ),
			'all_items'         => __( 'All Course Categories', 'tabligh' ),
			'parent_item'       => __( 'Parent Course Category', 'tabligh' ),
			'parent_item_colon' => __( 'Parent Course Category:', 'tabligh' ),
			'edit_item'         => __( 'Edit Course Category', 'tabligh' ),
			'update_item'       => __( 'Update Course Category', 'tabligh' ),
			'add_new_item'      => __( 'Add New Course Category', 'tabligh' ),
			'new_item_name'     => __( 'New Course Category Name', 'tabligh' ),
			'menu_name'         => __( 'Course Categories', 'tabligh' ),
		);

		$cat_args = array(
			'hierarchical'      => true,
			'labels'            => $cat_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'courses-category' ),
		);

		register_taxonomy( 'courses-category', array( 'courses' ), $cat_args );
		
		register_taxonomy('courses-tag','courses',array(
			'hierarchical' => false,
			'labels' => $labels,
			'show_ui' => true,
			'update_count_callback' => '_update_post_term_count',
			'query_var' => true,
			'rewrite' => array( 'slug' => 'courses-tag' ),
		));

	}

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_courses', 0 );
	
	/* Add Courses Post Type Meta Boxes */
	add_action( 'cmb2_admin_init', 'tabligh_courses_posttype_metaboxes' );

	function tabligh_courses_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'courses_posttype_metabox',
			'title'         => __( 'Courses Options', 'tabligh' ),
			'object_types'  => array( 'courses', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		$cmb->add_field( array(
			'name' => 'Teacher Name',
			'desc' => 'Add Teacher Name Here',
			'type' => 'text',
			'default' => 'Ali Hamdaam',
			'id'   => 'course_teacher_name'
		) );
		
		$cmb->add_field( array(
			'name'    => 'Teacher Expertise',
			'desc'    => 'Teacher Expertise Goes Here.',
			'default' => 'Islamic Scholar',
			'id'      => 'course_teacher_expertise',
			'type'    => 'text',
		) );

		$cmb->add_field( array(
			'name'    => 'Teacher Image',
			'desc'    => 'Upload Teacher Image Here',
			'id'      => 'course_teacher_image',
			'type'    => 'file',
			// Optional:
			'options' => array(
				'url' => true, // Hide the text input for the url
			),
			'text'    => array(
				'add_upload_file_text' => 'Add Image Here' // Change upload button text. Default: "Add or Upload File"
			),
			// query_args are passed to wp.media's library query.
			'query_args' => array(
				'type' => 'image/jpeg', // Make library only display PDFs.
				// Or only allow gif, jpg, or png images
				// 'type' => array(
				// 	'image/gif',
				// 	'image/jpeg',
				// 	'image/png',
				// ),
			),
			'preview_size' => 'small', // Image size to use when previewing in the admin.
		) );
		
		
		$cmb->add_field( array(
			'name' => 'Button URL',
			'desc' => 'Add Button URL Here',
			'type' => 'text',
			'default' => '#',
			'id'   => 'course_button_url'
		) );
		
		$cmb->add_field( array(
			'name'    => 'Button Text',
			'desc'    => 'Button Text Goes Here.',
			'default' => 'GET STARTED',
			'id'      => 'course_button_text',
			'type'    => 'text',
		) );

		$cmb->add_field( array(
			'name' => 'Price Text',
			'desc' => 'Add Price Text Here',
			'type' => 'text',
			'default' => 'Price:',
			'id'   => 'course_price_title'
		) );
		
		$cmb->add_field( array(
			'name'    => 'Price - Amonut',
			'desc'    => 'Price - Amount Goes Here',
			'default' => '49.00',
			'id'      => 'course_price_amount',
			'type'    => 'text',
		) );
		
		$cmb->add_field( array(
			'name' => 'Course Caption',
			'desc' => 'Add Course Caption Here',
			'type' => 'text',
			'default' => 'Learn Quran from Expert Islamic Teachers.',
			'id'   => 'course_caption'
		) );
		
		/* Social Media & Tags */
		$cmb->add_field( array(
			'name'    => 'Social Media & Tags',
			'id'      => 'course_social_media_tags',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
	
		/* Show Info & Likes */
		$cmb->add_field( array(
			'name'    => 'Likes, Comments & Views',
			'id'      => 'course_meta_details',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
		
		/* Course Author Box */
		$cmb->add_field( array(
			'name'    => 'Author Box',
			'id'      => 'course_author_box',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'tabligh' ),
				'hide'   => __( 'Hide', 'tabligh' ),
			),
			'default' => 'display',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Sidebar Layout',
			'id'      => 'courses_sidebar_layout',
			'type'    => 'radio_inline',
			'options' => array(
				'right' => __( 'Right SideBar', 'cmb2' ),
				'left'   => __( 'Left SideBar', 'cmb2' ),
				'no'     => __( 'No SideBar', 'cmb2' ),
			),
			'default' => 'right',
		) );
		
		$cmb->add_field( array(
			'name'             => 'Select SideBar',
			'desc'             => 'Select Your Desired SideBar',
			'id'               => 'courses_sidebar_selected',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => '',
			'options_cb' => 'tabligh_cmb2_get_all_sidebars',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Author Intro Title',
			'desc'    => 'Add Author Box Intro Title Here',
			'default' => 'About Author:',
			'id'      => 'course_author_intro_title',
			'type'    => 'text',
		) );

	} /* Meta boxes Ends Here */

}