<?php /* Event Meta */
	/* Add Events Meta Boxes */
	add_action( 'cmb2_admin_init', 'tabligh_events_posttype_metaboxes' );

	function tabligh_events_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'events_metabox',
			'title'         => __( 'Event Options', 'tabligh' ),
			'object_types'  => array( 'event', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Currency Symbol', 'tabligh' ),
			'desc'       => __( 'Add Currency Symbol Here: $', 'tabligh' ),
			'id'         => 'event_booking_currency',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Booking Price', 'tabligh' ),
			'desc'       => __( 'Booking Price Starts From: 15.00', 'tabligh' ),
			'id'         => 'event_booking_price',
			'type'       => 'text',
		) );

		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Details Title', 'tabligh' ),
			'desc'       => __( 'ORGANIZER:', 'tabligh' ),
			'id'         => 'details_title',
			'type'       => 'text',
		) );
		
		// List of Details
		$cmb->add_field( array(
			'name' => __( 'Event Details List', 'tabligh' ),
			'desc' => __( 'Add List Here, Click -Add Row- To Enter More', 'tabligh' ),
			'id'   => 'event_detail_list',
			'type' => 'text',
			'repeatable' => true,
		) );
		
		// Event Speakers
		$cmb->add_field( array(
			'name'    => __( 'Select Event Speakers Category', 'cmb2' ),
			'desc'    => __( 'Select Speakers/Team Category For This Event', 'cmb2' ),
			'id'   => 'event_speaker_list',
			'type'    => 'select',
			'options_cb' => 'tabligh_cmb2_get_all_terms',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Sidebar Layout',
			'id'      => 'event_sidebar_layout',
			'type'    => 'radio_inline',
			'options' => array(
				'right' => __( 'Right SideBar', 'cmb2' ),
				'left'   => __( 'Left SideBar', 'cmb2' ),
				'no'     => __( 'No SideBar', 'cmb2' ),
			),
			'default' => 'right',
		) );
		
		$cmb->add_field( array(
			'name'             => 'Select SideBar',
			'desc'             => 'Select Your Desired SideBar',
			'id'               => 'event_sidebar_selected',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => '',
			'options_cb' => 'tabligh_cmb2_get_all_sidebars',
		) );
		
	} /* Meta boxes Ends Here */