<?php
/***** Required Functions For testimonial Post Type *****/
if ( ! function_exists('prefix_post_type_testimonial') ) {

/* 1. Register CLASSES Post Type */
function prefix_post_type_testimonial() {

	$labels = array(
		'name'                  => _x( 'Testimonial', 'Post Type General Name', 'tabligh' ),
		'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'tabligh' ),
		'menu_name'             => __( 'Testimonial', 'tabligh' ),
		'name_admin_bar'        => __( 'Testimonial', 'tabligh' ),
		'archives'              => __( 'Item Archives', 'tabligh' ),
		'attributes'            => __( 'Item Attributes', 'tabligh' ),
		'parent_item_colon'     => __( 'Parent Item:', 'tabligh' ),
		'all_items'             => __( 'All Items', 'tabligh' ),
		'add_new_item'          => __( 'Add New Testimonial', 'tabligh' ),
		'add_new'               => __( 'Add New Testimonial', 'tabligh' ),
		'new_item'              => __( 'Add New Testimonial', 'tabligh' ),
		'edit_item'             => __( 'Edit Testimonial', 'tabligh' ),
		'update_item'           => __( 'Update Item', 'tabligh' ),
		'view_item'             => __( 'View Item', 'tabligh' ),
		'view_items'            => __( 'View Items', 'tabligh' ),
		'search_items'          => __( 'Search Item', 'tabligh' ),
		'not_found'             => __( 'Not found', 'tabligh' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'tabligh' ),
		'featured_image'        => __( 'Testimonial Featured Image', 'tabligh' ),
		'set_featured_image'    => __( 'Set featured image', 'tabligh' ),
		'remove_featured_image' => __( 'Remove featured image', 'tabligh' ),
		'use_featured_image'    => __( 'Use as featured image', 'tabligh' ),
		'insert_into_item'      => __( 'Insert into item', 'tabligh' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'tabligh' ),
		'items_list'            => __( 'Items list', 'tabligh' ),
		'items_list_navigation' => __( 'Items list navigation', 'tabligh' ),
		'filter_items_list'     => __( 'Filter items list', 'tabligh' ),
	);
	$args = array(
		'label'                 => __( 'Testimonial', 'tabligh' ),
		'description'           => __( 'Testimonial Posts Generated By Ingeniofy Plugin', 'tabligh' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => true,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-id-alt',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => 'testimonial',
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'testimonial', $args );
	
	/* Add new taxonomy, make it hierarchical (like categories) */
	$cat_labels = array(
		'name'              => _x( 'Testimonial Categories', 'taxonomy general name', 'tabligh' ),
		'singular_name'     => _x( 'Testimonial Category', 'taxonomy singular name', 'tabligh' ),
		'search_items'      => __( 'Search Testimonial Category', 'tabligh' ),
		'all_items'         => __( 'All Testimonial Categories', 'tabligh' ),
		'parent_item'       => __( 'Parent Testimonial Category', 'tabligh' ),
		'parent_item_colon' => __( 'Parent Testimonial Category:', 'tabligh' ),
		'edit_item'         => __( 'Edit Testimonial Category', 'tabligh' ),
		'update_item'       => __( 'Update Testimonial Category', 'tabligh' ),
		'add_new_item'      => __( 'Add New Testimonial Category', 'tabligh' ),
		'new_item_name'     => __( 'New Testimonial Category Name', 'tabligh' ),
		'menu_name'         => __( 'Testimonial Categories', 'tabligh' ),
	);

	$cat_args = array(
		'hierarchical'      => true,
		'labels'            => $cat_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'testimonial-category' ),
	);

	register_taxonomy( 'testimonial-category', array( 'testimonial' ), $cat_args );

}

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_testimonial', 0 );

}