<?php

// Bismillah...

	defined( 'ABSPATH' ) or die( 'Stop! You can not do this!' );

	include_once('PrayTimeNamaz.php');
	
	if (!class_exists('uCal')) {
			include_once('uCal.php');
		}
	
/********** Modified Shortcode - Ingeniofy ***********/
   
	function tabligh_salat_times_shortcode() {
	
		$st_options = get_option("st_options");
		if (!is_array($st_options)) {
			$st_options = array(
				'lat_long_tz' => '23.7 90.4 6',
				'lat' => '23.7',
				'long' => '90.4',
				'custom_loc' => '0',
				'custom_loc' => '0',
				'calc_method' => '1',
				'asr_method' => '0',
				'time_format' => '1',
				'time_zone' => '6',
				'daylight' => '0',
				'wgt_title1' => 'Salat Times',
				'location' => 'London, UK',
				'show_date' => '1',
				'show_hdate' => '0',
				'hijri_adjust' => '-0',
				'dir' => 'inherit',
				'iqamah' => '900',
				'width' => '100%',
				'halign' => 'center',
				'talign' => 'center',
				'walign' => 'left',
				'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
				'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah',
				'lang' => 'en',
				'timetable' => '0' );
		}
	   
	   /* Get Option Value From Theme Options */
		global $tabligh_options;
		
		$jummah_title = $tabligh_options['jummah_title']; 
		$jummah_start = $tabligh_options['jummah_start']; 
		$jummah_iqamah = $tabligh_options['jummah_iqamah']; 
		
	
		if (!$st_options['timetable'] == '1') { // Automatic Timetable
	
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
		
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
	
			$color = explode(" ", $st_options['scheme']);
	
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah");
			}else{
				$cl = explode("-", $st_options['custom']); 
			}
			
			$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
			
			$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';
			
			$pattern_url = get_template_directory_uri().'/assets/images/pattern-bg.jpg';
			
			$return_time = '
			
			
			<ul class="time-list3 d-flex flex-wrap mb-0 list-unstyled">
				<li class="pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[2].'</span> '.$times[0].'<i>Iqamah: '.date('g:i a', strtotime("$iqamah_offset", strtotime($times[0]))).'</i>
				</li>
				<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[4].'</span> '.$times[2].'<i>Iqamah: '.date('g:i a', strtotime("$iqamah_offset", strtotime($times[2]))).'</i>
				</li>
				<li class="pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[5].'</span> '.$times[3].'<i>Iqamah: '.date('g:i a', strtotime("$iqamah_offset", strtotime($times[3]))).'</i>
				</li>
				<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[6].'</span> '.$times[4].'<i>Iqamah: '.date('g:i a', strtotime("$iqamah_offset", strtotime($times[4]))).'</i>
				</li>
				<li class="pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[7].'</span> '.$times[6].'<i>Iqamah: '.date('g:i a', strtotime("$iqamah_offset", strtotime($times[6]))).'</i>
				</li>';
				
				if(!empty($jummah_title) || !empty($jummah_start) || !empty($jummah_iqamah)){
				$return_time .= '
					<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
						<span>'.$jummah_title.'</span> '. $jummah_start . ' <i>Iqamah: '.$jummah_iqamah.'</i>
					</li>';
				}else{
					$return_time .= '
					<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
						<span>'.$cl[9].'</span> '. $times[2] . ' <i>Iqamah: '.date('g:i a', strtotime("$iqamah_offset", strtotime($times[2]))).'</i>
					</li>';
				}
				$return_time .= '
			</ul>';
			
			return $return_time;


		}else{ // Manual Timetable
		
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
			
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
	
			$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
			
			$file = $dir . 'manual_time.data';
			$lines = file($file);//file in to an array

			$lineN = gmdate("z", time()+$offset);
		
			$color = explode(" ", $st_options['scheme']);
		
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah");
			} else { $cl = explode("-", $st_options['custom']); }
			
			$times = explode("--", $lines[$lineN]);
			
			$return_time = '
			
			
			<ul class="time-list3 d-flex flex-wrap mb-0 list-unstyled">
				<li class="pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[2].'</span> '.$times[1].'<i>Iqamah: '.$times[6].'</i>
				</li>
				<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[4].'</span> '.$times[2].'<i>Iqamah: '.$times[7].'</i>
				</li>
				<li class="pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[5].'</span> '.$times[3].'<i>Iqamah: '.$times[8].'</i>
				</li>
				<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[6].'</span> '.$times[4].'<i>Iqamah: '.$times[9].'</i>
				</li>
				<li class="pat-bg thm-layer opc7 back-blend-multiply thm-bg" style="background-image: url('.$pattern_url.');">
					<span>'.$cl[7].'</span> '.$times[5].'<i>Iqamah: '.$times[10].'</i>
				</li>';
				
				if(!empty($jummah_title) || !empty($jummah_start) || !empty($jummah_iqamah)){
				$return_time .= '
					<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
						<span>'.$jummah_title.'</span> '. $jummah_start . ' <i>Iqamah: '.$jummah_iqamah.'</i>
					</li>';
				}else{
					$return_time .= '
					<li class="pat-bg grn-layer2 opc7 back-blend-multiply bg-color2" style="background-image: url('.$pattern_url.');">
						<span>'.$cl[9].'</span> '. $times[2] . ' <i>Iqamah: '.$times[7].'</i>
					</li>';
				}
				$return_time .= '
			</ul>';
			
			return $return_time;
			
		}
	}


/* Ramadan Timings */
function tabligh_ramadan_timings_shortcode() {
	
	$st_options = get_option("st_options");
	if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'iqamah' => '900',
			'calc_method' => '1',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'daylight' => '0',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, UK',
			'show_date' => '1',
			'show_hdate' => '0',
			'hijri_adjust' => '-0',
			'dir' => 'inherit',
			'width' => '100%',
			'halign' => 'center',
			'talign' => 'center',
			'walign' => 'left',
			'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
			'custom' => 'Salah-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah',
			'lang' => 'en',
			'timetable' => '0' );
	}
	
	
	/* Variable Redux Options */
	global $tabligh_options;
	
	/* Get Ramadan Time Table */
	$ramadan_times = $tabligh_options['ramadan-sehr-iftar'];
	/* Convert Times Into Array */
	$ramadan_times = explode(PHP_EOL, $ramadan_times); /* explode at every end of line eol */
	$lineN = gmdate("z", time());
	$times = explode("--", $ramadan_times[$lineN]);
	
	$prayTime = new PrayTimeNamaz();
	$prayTime->setCalcMethod($st_options['calc_method']);
	$prayTime->setAsrMethod($st_options['asr_method']);
	$prayTime->setTimeFormat($st_options['time_format']);
	
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2]+$st_options['daylight'];
	}else { 
		$latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone']+$st_options['daylight'];
	}
	
	$d = new uCal;
	$offset = $time_zone *60*60;
	$hoffset = $st_options['hijri_adjust']*60*60;
		

	if ($st_options['show_date'] == '1') {
		$stdate = gmdate("l, jS F, Y", time()+$offset);
	}
	if ($st_options['show_hdate'] == '1') {
		$sthdate = $d->date("jS F, Y", time()+$hoffset);
	}

	
	return array($times[1], $times[2], $stdate, $sthdate);
		
}

/* Hijri Date Only */
function tabligh_hijridate_shortcode() {
	
	$st_options = get_option("st_options");
	if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'iqamah' => '900',
			'calc_method' => '1',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'daylight' => '0',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, England',
			'show_date' => '1',
			'show_hdate' => '0',
			'hijri_adjust' => '-0',
			'dir' => 'inherit',
			'width' => '100%',
			'halign' => 'center',
			'talign' => 'center',
			'walign' => 'left',
			'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
			'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah',
			'lang' => 'en',
			'timetable' => '0' );
	}
	
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2]+$st_options['daylight'];
	}else { 
		$latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone']+$st_options['daylight'];
	}
	
	$d = new uCal;
	$offset = $time_zone *60*60;
	$hoffset = $st_options['hijri_adjust']*60*60;
		

	if ($st_options['show_date'] == '1') {
		$stdate = gmdate("D, jS M, Y", time()+$offset);
	}
	if ($st_options['show_hdate'] == '1') {
		$sthdate = $d->date("jS F, Y", time()+$hoffset);
	}
	
	
// 	$output = $sthdate.' - '.$stdate.' - '.$st_options['location']; 
	
// 	return $output;
}


/********** Modified Shortcode - Ingeniofy ***********/
   
	function tabligh_salat_times_elementor_widget_shortcode() {
	
		$st_options = get_option("st_options");
		if (!is_array($st_options)) {
			$st_options = array(
				'lat_long_tz' => '23.7 90.4 6',
				'lat' => '23.7',
				'long' => '90.4',
				'custom_loc' => '0',
				'custom_loc' => '0',
				'calc_method' => '1',
				'asr_method' => '0',
				'time_format' => '1',
				'time_zone' => '6',
				'iqamah' => '900',
				'daylight' => '0',
				'wgt_title1' => 'Salat Times',
				'location' => 'London, UK',
				'show_date' => '1',
				'show_hdate' => '0',
				'hijri_adjust' => '-0',
				'dir' => 'inherit',
				'width' => '100%',
				'halign' => 'center',
				'talign' => 'center',
				'walign' => 'left',
				'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
				'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat',
				'lang' => 'en',
				'timetable' => '0' );
		}
	   
	    /* Get Option Value From Theme Options */
		global $tabligh_options;
		
		$jummah_title = $tabligh_options['jummah_title']; 
		$jummah_start = $tabligh_options['jummah_start']; 
		$jummah_iqamah = $tabligh_options['jummah_iqamah']; 
	
		if (!$st_options['timetable'] == '1') { // Automatic Timetable
	
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
			
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
	
			$color = explode(" ", $st_options['scheme']);
	
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
			}else{
				$cl = explode("-", $st_options['custom']); 
			}
	
			/* <span><i class="thm-clr">'.$cl[1].':</i>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[0]))).'</span> */

			$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
			
			$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';

			$return_time = '
			
			<ul class="time-list mb-0 list-unstyled">
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[2].'</span>
						<span>'.$times[0].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[4].'</span>
						<span>'.$times[2].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[5].'</span>
						<span>'.$times[3].'</span>
					</div>
				</li>
			</ul>
			<ul class="time-list mb-0 list-unstyled">
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[6].'</span>
						<span>'.$times[4].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[7].'</span>
						<span>'.$times[6].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$jummah_title.'</span>
						<span>'.$jummah_iqamah.'</span>
					</div>
				</li>
			</ul>';
				
			return $return_time;

		}else{ // Manual Timetable - Elementor Namaz Time Widget
		
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
			
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
			$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
			
			$file = $dir . 'manual_time.data';
			$lines = file($file);//file in to an array

			$lineN = gmdate("z", time()+$offset);
		
			$color = explode(" ", $st_options['scheme']);
		
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
			} else { $cl = explode("-", $st_options['custom']); }

			$times = explode("--", $lines[$lineN]);
			
			$return_time = '
			
			<ul class="time-list mb-0 list-unstyled">
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[2].'</span>
						<span>'.$times[6].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[4].'</span>
						<span>'.$times[7].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[5].'</span>
						<span>'.$times[8].'</span>
					</div>
				</li>
			</ul>
			<ul class="time-list mb-0 list-unstyled">
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[6].'</span>
						<span>'.$times[9].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$cl[7].'</span>
						<span>'.$times[10].'</span>
					</div>
				</li>
				<li>
					<div class="time-box d-flex flex-wrap align-items-center justify-content-between">
						<span><i class="flaticon-rub-el-hizb"></i>'.$jummah_title.'</span>
						<span>'.$jummah_iqamah.'</span>
					</div>
				</li>
			</ul>';
				
			return $return_time;			
		
		}
	}


function tabligh_sunrise_sunset_shortcode() {
		$st_options = get_option("st_options");
	  if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'calc_method' => '1',
			'iqamah' => '900',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, UK',
			'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat',
			'show_date' => '1',
			'width' => '100%',
			'lang' => 'en', 'timetable' => '0' );
	   }
	
	   
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2];
		}
	else { $latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone'];
		}
	
	$offset = $time_zone *60*60;
	
	$date = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
	
	if ($st_options['lang'] == "en") {
		$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
	}else{
		$cl = explode("-", $st_options['custom']); 
	}
	
	$prayTime = new PrayTimeNamaz();
	$prayTime->setCalcMethod($st_options['calc_method']);
	$prayTime->setAsrMethod($st_options['asr_method']);
	$prayTime->setTimeFormat($st_options['time_format']);
	
	/* Get Option Value From Theme Options */
	global $tabligh_options;

// 	$head_1 = $tabligh_options['topbar_salat_head1'];
// 	$head_2 = $tabligh_options['topbar_salat_head2'];
// 	$head_3 = $tabligh_options['topbar_salat_head3'];
	
	if (!$st_options['timetable'] == '1') { /* automatic data in header dropdown*/
		$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
		
		if ($st_options['lang'] == "en") {
		$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
	}else{
		$cl = explode("-", $st_options['custom']); 
	}
		
	$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';
		
		//Modified Code
		$html = '
					<li>
						<i class="thm-clr flaticon-sun"></i>
						'.esc_html__('Sunrise At:','tabligh').' 
						<span class="thm-clr">'.$times[1].'</span>
					</li>
					<li>
						<i class="thm-clr flaticon-moon"></i>
						'.esc_html__('Sunset At:','tabligh').' 
						<span class="thm-clr">'.$times[5].'</span>
					</li>';
					
		return $html;
	
	}else{ /* MANUAL data in header dropdown */
	
	
		$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
				
		$file = $dir . 'manual_time.data';
		$lines = file($file);//file in to an array

		$lineN = gmdate("z", time());
		
		$times = explode("--", $lines[$lineN]);
		
		if ($st_options['lang'] == "en") {
			$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
		}else{
			$cl = explode("-", $st_options['custom']); 
		}
		
		
		//Modified Code
		$html = '
				<li>
					<i class="thm-clr flaticon-sun"></i>
					'.esc_html__('Sunrise At:','tabligh').' 
					<span class="thm-clr">'.$times[1].'</span>
				</li>
				<li>
					<i class="thm-clr flaticon-moon"></i>
					'.esc_html__('Sunset At:','tabligh').' 
					<span class="thm-clr">'.$times[5].'</span>
				</li>';
					
		return $html;
	}
}

function tabligh_namaz_timings_header() {
		$st_options = get_option("st_options");
	  if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'calc_method' => '1',
			'iqamah' => '900',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, UK',
			'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat',
			'show_date' => '1',
			'width' => '100%',
			'lang' => 'en', 'timetable' => '0' );
	   }
	
	   
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2];
		}
	else { $latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone'];
		}
	
	$offset = $time_zone *60*60;
	
	$date = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
	
	if ($st_options['lang'] == "en") {
		$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
	}else{
		$cl = explode("-", $st_options['custom']); 
	}
	
	$prayTime = new PrayTimeNamaz();
	$prayTime->setCalcMethod($st_options['calc_method']);
	$prayTime->setAsrMethod($st_options['asr_method']);
	$prayTime->setTimeFormat($st_options['time_format']);
	
	/* Get Option Value From Theme Options */
	global $tabligh_options;
	
	$jummah_title = $tabligh_options['jummah_title']; 
	$jummah_start = $tabligh_options['jummah_start']; 
	$jummah_iqamah = $tabligh_options['jummah_iqamah']; 
	
	if (!$st_options['timetable'] == '1') { /* automatic data in header dropdown*/
		$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
		
		if ($st_options['lang'] == "en") {
		$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
	}else{
		$cl = explode("-", $st_options['custom']); 
	}
		
	$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';
	
	$html_return = '
	
		<ul class="time-list2 d-flex flex-wrap w-100 mb-0 list-unstyled">
			<li><span>'.$cl[2].':</span>'.$times[0].'</li>
			<li><span>'.$cl[4].':</span>'.$times[2].'</li>
			<li><span>'.$cl[5].':</span>'.$times[3].'</li>
			<li><span>'.$cl[6].':</span>'.$times[4].'</li>
			<li><span>'.$cl[7].':</span>'.$times[6].'</li>
			<li><span>'.$jummah_title.':</span>'.$jummah_iqamah.'</li>
		</ul>';
		
	
	return $html_return;
		
	
	}else{ /* MANUAL data in header dropdown */
	
	
		$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
				
		$file = $dir . 'manual_time.data';
		$lines = file($file);//file in to an array

		$lineN = gmdate("z", time());
		
		$times = explode("--", $lines[$lineN]);
		
		if ($st_options['lang'] == "en") {
			$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
		}else{
			$cl = explode("-", $st_options['custom']); 
		}
		
		$html_return = '
	
		<ul class="time-list2 d-flex flex-wrap w-100 mb-0 list-unstyled">
			<li><span>'.$cl[2].':</span>'.$times[6].'</li>
			<li><span>'.$cl[4].':</span>'.$times[7].'</li>
			<li><span>'.$cl[5].':</span>'.$times[8].'</li>
			<li><span>'.$cl[6].':</span>'.$times[9].'</li>
			<li><span>'.$cl[7].':</span>'.$times[10].'</li>
			<li><span>'.$jummah_title.':</span>'.$jummah_iqamah.'</li>
		</ul>';
		
	
		return $html_return;
		
	}
}


// ========== Action Links =================
 
function st_action_links($links) {
	$links[] = '<a href="' . get_admin_url(null, 'options-general.php?page=salat_times') . '">Settings</a>';
	return $links;
}

	add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'st_action_links');

// =====================
add_shortcode('tabligh_salat_times', 'tabligh_salat_times_shortcode');
add_shortcode('tabligh_salat_headers', 'tabligh_namaz_timings_header');
add_shortcode('tabligh_ramadan_timings', 'tabligh_ramadan_timings_shortcode');
add_shortcode('tabligh_salat_times_elementor', 'tabligh_salat_times_elementor_widget_shortcode');
add_shortcode('tabligh_hijri_date', 'tabligh_hijridate_shortcode');
add_shortcode('tabligh_sunrise_sunset', 'tabligh_sunrise_sunset_shortcode');

    if(is_admin())
    include 'salat_times_admin.php';
?>