<?php
class information_hours extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget style2', 'description' => 'Information' );
		parent::__construct('information_hours', ' *Information : Hours/Time & Days ', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$widget_facebook = isset( $instance['facebook'] ) ? esc_html( $instance['facebook'] ) : '';
	$widget_twitter = isset( $instance['twitter'] ) ? esc_html( $instance['twitter'] ) : '';
	$widget_linkedin = isset( $instance['linkedin'] ) ? esc_html( $instance['linkedin'] ) : '';
	$widget_googleplus = isset( $instance['googleplus'] ) ? esc_html( $instance['googleplus'] ) : '';
	$widget_pinterest = isset( $instance['pinterest'] ) ? esc_html( $instance['pinterest'] ) : '';
	$select_post_type = empty($instance['select_post_type']) ? '' : apply_filters('widget_title', $instance['select_post_type']);
	$number_of_posts = empty($instance['number_of_posts']) ? '' : apply_filters('widget_title', $instance['number_of_posts']);
	
?>
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>   
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('facebook')); ?>">
		 <?php esc_html_e('Description:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('facebook')); ?>" name="<?php echo esc_attr($this->get_field_name('facebook')); ?>" type="text" value="<?php echo esc_html($widget_facebook); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('twitter')); ?>">
		 <?php esc_html_e('Hours Title:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('twitter')); ?>" name="<?php echo esc_attr($this->get_field_name('twitter')); ?>" type="text" value="<?php echo esc_html($widget_twitter); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('linkedin')); ?>">
		 <?php esc_html_e('Mon-Fri:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('linkedin')); ?>" name="<?php echo esc_attr($this->get_field_name('linkedin')); ?>" type="text" value="<?php echo esc_html($widget_linkedin); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('googleplus')); ?>">
		 <?php esc_html_e('Saturday:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('googleplus')); ?>" name="<?php echo esc_attr($this->get_field_name('googleplus')); ?>" type="text" value="<?php echo esc_html($widget_googleplus); ?>" />
	  </label>
	</p>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('pinterest')); ?>">
		 <?php esc_html_e('Sunday:','tabligh');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('pinterest')); ?>" name="<?php echo esc_attr($this->get_field_name('pinterest')); ?>" type="text" value="<?php echo esc_html($widget_pinterest); ?>" />
	  </label>
	</p>
	 <p>
  <label for="<?php echo esc_attr($this->get_field_id('select_post_type')); ?>">
	  <?php esc_html_e('Select Post Type:','tabligh');?>
	  <select class="widefat" id="<?php echo esc_attr($this->get_field_id('select_post_type')); ?>" name="<?php echo esc_attr($this->get_field_name('select_post_type')); ?>" style="width:225px">
		<?php
				foreach ( get_post_types( '', 'names' ) as $post_type){ ?>
                    <option <?php if(esc_attr($select_post_type) == ucfirst($post_type)){echo 'selected';}?> value="<?php echo esc_attr(ucfirst($post_type));?>" >
	                    <?php echo substr(esc_attr(ucfirst($post_type)), 0, 20);	if ( strlen(ucfirst($post_type)) > 20 ) echo "...";?>
                    </option>						
			<?php }?>
      </select>
  </label>
  </p>  
  <p>
  <label for="<?php echo esc_attr($this->get_field_id('number_of_posts')); ?>">
	  <?php esc_html_e('Number of Posts To Display','tabligh');?>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id('number_of_posts')); ?>" name="<?php echo esc_attr($this->get_field_name('number_of_posts'));?>" type="text" value="<?php echo esc_attr($number_of_posts);?>"/>
  </label>
  </p>
	
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		 $instance['facebook'] = $new_instance['facebook'];
		 $instance['twitter'] = $new_instance['twitter'];
		 $instance['linkedin'] = $new_instance['linkedin'];
		 $instance['googleplus'] = $new_instance['googleplus'];
		 $instance['pinterest'] = $new_instance['pinterest'];
		 $instance['select_post_type'] = $new_instance['select_post_type'];
	    $instance['number_of_posts'] = $new_instance['number_of_posts'];
		 

		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		$widget_title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		 $visioncare_facebook = isset( $instance['facebook'] ) ? esc_attr( $instance['facebook'] ) : '';	
		 $visioncare_twitter = isset( $instance['twitter'] ) ? esc_attr( $instance['twitter'] ) : '';	
		 $visioncare_linkedin = isset( $instance['linkedin'] ) ? esc_attr( $instance['linkedin'] ) : '';	
		 $visioncare_googleplus = isset( $instance['googleplus'] ) ? esc_attr( $instance['googleplus'] ) : '';	
		 $visioncare_pinterest = isset( $instance['pinterest'] ) ? esc_attr( $instance['pinterest'] ) : '';	
		 	$select_post_type = isset( $instance['select_post_type'] ) ? esc_attr( $instance['select_post_type'] ) : '';		
		$number_of_posts = isset( $instance['number_of_posts'] ) ? esc_attr( $instance['number_of_posts'] ) : '';	
		
		echo html_entity_decode($before_widget);
    
		/* Widget HTML Markup */
			$widget_html .= '<div class="widget">
				<h5 itemprop="headline">'.$widget_title.'</h5>
				<p itemprop="description">'.$visioncare_facebook.'</p>';
			
	
		if(!empty($visioncare_pinterest) || !empty($visioncare_googleplus) || !empty($visioncare_linkedin)){
			$widget_html .= '	
			<div class="widget">
				<h5 itemprop="headline">'.$visioncare_twitter.'</h5>';
			    	$widget_html .= '<div class="timing-scdul">';
					if(!empty($visioncare_linkedin)){ $widget_html .= '<span><i class="theme-clr">'.esc_html__('Mon-Fri:','tabligh').'</i> '.$visioncare_linkedin.'</span>'; }
					if(!empty($visioncare_googleplus)){ $widget_html .= '<span><i class="theme-clr">'.esc_html__('Saturday:','tabligh').'</i> '.$visioncare_googleplus.'</span>'; }
			     	if(!empty($visioncare_pinterest)){ 	 $widget_html .= '<span><i class="theme-clr">'.esc_html__('Sunday:','tabligh').'</i> '.$visioncare_pinterest.'</span>'; }
				 $widget_html .= '</div>';
			
			  $widget_html .= '
			</div>';
		}	
				global $wpdb, $post, $wp_query;
				
				$args = array(
					'posts_per_page'			=> $number_of_posts,
					'post_type'					=> $select_post_type,
					'post_status'				=> 'publish',
					'orderby'					=> 'date',
					'order'						=> 'DESC',
				);
					
				query_posts($args);

				if ( have_posts() ) {

					$widget_html .= '<ul>';
					
					/* HTML Markup */
						while ( have_posts() ): the_post(); global $post;
							
							if(strlen(get_the_title()) > 30){
								$title = mb_substr(get_the_title(), 0 , 30).'...';
							}else{
								$title = get_the_title();
							}
							
								$widget_html .= '
									
									<li>
										<a itemprop="url" href="'.esc_url(get_the_permalink()).'">'.esc_attr($title).'</a>
									</li>';
										
							endwhile; /* end while */ wp_reset_query();	
					
					$widget_html .= '	</ul>';

			
				
				}else{
				
					$widget_html .= '<div class="forums-widget"><ul><li>'.esc_html__('There is no Post to Show From This Post-Type','tabligh').'</li></ul></div>';
				}
			
            	$widget_html .= '</div>';
		echo $widget_html;
		
	/* WIDGET display CODE End*/
	echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of information_hours class */
	
	
add_action( 'widgets_init', create_function('', 'return register_widget("information_hours");') );?>